/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.table;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableInfo<T> {
    private final Class<T> dataClass;
    private final String tableName;
    private final FieldType[] fieldTypes;
    private final FieldType idField;
    private final Constructor<T> constructor;
    private Map<String, FieldType> fieldNameMap;

    public TableInfo(DatabaseType databaseType, Class<T> dataClass) throws SQLException {
        this(databaseType, DatabaseTableConfig.fromClass(databaseType, dataClass));
    }

    public TableInfo(DatabaseType databaseType, DatabaseTableConfig<T> tableConfig) throws SQLException {
        this.dataClass = tableConfig.getDataClass();
        this.tableName = tableConfig.getTableName();
        this.fieldTypes = tableConfig.extractFieldTypes(databaseType);
        FieldType findIdFieldType = null;
        for (FieldType fieldType : this.fieldTypes) {
            if (!fieldType.isId()) continue;
            if (findIdFieldType != null) {
                throw new SQLException("More than 1 idField configured for class " + this.dataClass + " (" + findIdFieldType + "," + fieldType + ")");
            }
            findIdFieldType = fieldType;
        }
        if (this.fieldTypes.length == 1 && findIdFieldType != null && findIdFieldType.isGeneratedId()) {
            throw new SQLException("Must have more than a single field which is a generated-id for class " + this.dataClass);
        }
        this.idField = findIdFieldType;
        this.constructor = this.findNoArgConstructor(this.dataClass);
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public FieldType[] getFieldTypes() {
        return this.fieldTypes;
    }

    public FieldType getFieldTypeByColumnName(String columnName) {
        FieldType fieldType;
        if (this.fieldNameMap == null) {
            this.fieldNameMap = new HashMap<String, FieldType>();
            for (FieldType fieldType2 : this.fieldTypes) {
                this.fieldNameMap.put(fieldType2.getDbColumnName(), fieldType2);
            }
        }
        if ((fieldType = this.fieldNameMap.get(columnName)) == null) {
            for (FieldType fieldType2 : this.fieldTypes) {
                if (!fieldType2.getFieldName().equals(columnName)) continue;
                throw new IllegalArgumentException("You should use columnName '" + fieldType2.getDbColumnName() + "' for table " + this.tableName + " instead of fieldName '" + columnName + "'");
            }
            throw new IllegalArgumentException("Unknown column name '" + columnName + "' in table " + this.tableName);
        }
        return fieldType;
    }

    public FieldType getIdField() {
        return this.idField;
    }

    public String objectToString(T object) {
        StringBuilder sb = new StringBuilder();
        sb.append(object.getClass().getSimpleName());
        for (FieldType fieldType : this.fieldTypes) {
            sb.append(' ').append(fieldType.getDbColumnName()).append("=");
            try {
                sb.append(fieldType.getConvertedFieldValue(object));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not generate toString of field " + fieldType, e);
            }
        }
        return sb.toString();
    }

    public T createObject() throws SQLException {
        boolean accessible = this.constructor.isAccessible();
        try {
            if (!accessible) {
                this.constructor.setAccessible(true);
            }
            T t = this.constructor.newInstance(new Object[0]);
            return t;
        }
        catch (Exception e) {
            throw SqlExceptionUtil.create("Could not create object for " + this.dataClass, e);
        }
        finally {
            if (!accessible) {
                this.constructor.setAccessible(false);
            }
        }
    }

    private Constructor<T> findNoArgConstructor(Class<T> dataClass) {
        Constructor<?>[] constructors;
        try {
            Constructor<?>[] consts;
            constructors = consts = dataClass.getDeclaredConstructors();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't lookup declared constructors for " + dataClass, e);
        }
        for (Constructor<?> con : constructors) {
            if (con.getParameterTypes().length != 0) continue;
            return con;
        }
        throw new IllegalArgumentException("Can't find a no-arg constructor for " + dataClass);
    }
}

