/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.jdbc.JdbcDatabaseConnection;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JdbcPooledConnectionSource
extends JdbcConnectionSource
implements ConnectionSource {
    private static Logger logger = LoggerFactory.getLogger(JdbcPooledConnectionSource.class);
    private static final int DEFAULT_MAX_CONNECTIONS_FREE = 5;
    private static final int DEFAULT_MAX_CONNECTION_AGE_MILLIS = 3600000;
    private int maxConnectionsFree = 5;
    private long maxConnectionAgeMillis = 3600000L;
    private boolean usesTransactions = false;
    private List<ConnectionMetaData> connList = new ArrayList<ConnectionMetaData>();
    private ThreadLocal<DatabaseConnection> transactionConnection = new ThreadLocal();
    private Map<DatabaseConnection, ConnectionMetaData> connectionMap = new HashMap<DatabaseConnection, ConnectionMetaData>();
    private final Object lock = new Object();
    private int openCount = 0;
    private int closeCount = 0;
    private int maxInUse = 0;

    public JdbcPooledConnectionSource() {
    }

    public JdbcPooledConnectionSource(String url) throws SQLException {
        super(url, null, null, null);
    }

    public JdbcPooledConnectionSource(String url, DatabaseType databaseType) throws SQLException {
        super(url, null, null, databaseType);
    }

    public JdbcPooledConnectionSource(String url, String username, String password) throws SQLException {
        super(url, username, password, null);
    }

    public JdbcPooledConnectionSource(String url, String username, String password, DatabaseType databaseType) throws SQLException {
        super(url, username, password, databaseType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        logger.debug("closing", new Object[0]);
        Object object = this.lock;
        synchronized (object) {
            for (ConnectionMetaData connMetaData : this.connList) {
                this.closeConnection(connMetaData.connection);
            }
            this.connList.clear();
            this.connList = null;
            this.connectionMap.clear();
        }
    }

    public DatabaseConnection getReadOnlyConnection() throws SQLException {
        return this.getReadWriteConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseConnection getReadWriteConnection() throws SQLException {
        DatabaseConnection stored;
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        if (this.usesTransactions && (stored = this.transactionConnection.get()) != null) {
            return stored;
        }
        Object object = this.lock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            while (this.connList.size() > 0) {
                ConnectionMetaData connMetaData = this.connList.remove(0);
                if (connMetaData.isExpired(now)) {
                    this.closeConnection(connMetaData.connection);
                    continue;
                }
                logger.debug("reusing connection {}", connMetaData);
                return connMetaData.connection;
            }
            JdbcDatabaseConnection connection = this.makeConnection(logger);
            ++this.openCount;
            this.connectionMap.put(connection, new ConnectionMetaData(connection));
            if (this.connectionMap.size() > this.maxInUse) {
                this.maxInUse = this.connectionMap.size();
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(DatabaseConnection connection) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        if (this.usesTransactions && this.transactionConnection.get() == connection) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.connList == null) {
                this.closeConnection(connection);
                return;
            }
            ConnectionMetaData meta = this.connectionMap.get(connection);
            if (meta == null) {
                logger.error("should have found connection {} in the map", connection);
                this.closeConnection(connection);
            } else {
                this.connList.add(meta);
                logger.debug("cache released connection {}", meta);
                if (this.connList.size() > this.maxConnectionsFree) {
                    meta = this.connList.remove(0);
                    logger.debug("cache too full, closing connection {}", meta);
                    this.closeConnection(meta.connection);
                }
            }
        }
    }

    public void saveTransactionConnection(DatabaseConnection connection) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        this.usesTransactions = true;
        this.transactionConnection.set(connection);
        if (logger.isDebugEnabled()) {
            ConnectionMetaData meta = this.connectionMap.get(connection);
            logger.debug("saved trxn connection {}", meta);
        }
    }

    public void clearTransactionConnection(DatabaseConnection connection) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        this.transactionConnection.set(null);
        if (logger.isDebugEnabled()) {
            ConnectionMetaData meta = this.connectionMap.get(connection);
            logger.debug("cleared trxn connection {}", meta);
        }
    }

    public void setUsesTransactions(boolean usesTransactions) {
        this.usesTransactions = usesTransactions;
    }

    public void setMaxConnectionsFree(int maxConnectionsFree) {
        this.maxConnectionsFree = maxConnectionsFree;
    }

    public void setMaxConnectionAgeMillis(long maxConnectionAgeMillis) {
        this.maxConnectionAgeMillis = maxConnectionAgeMillis;
    }

    public int getOpenCount() {
        return this.openCount;
    }

    public int getCloseCount() {
        return this.closeCount;
    }

    public int getMaxConnectionsInUse() {
        return this.maxInUse;
    }

    public int getCurrentConnectionsManaged() {
        return this.connectionMap.size();
    }

    private void closeConnection(DatabaseConnection connection) throws SQLException {
        ConnectionMetaData meta = this.connectionMap.remove(connection);
        connection.close();
        logger.debug("closed connection {}", meta);
        ++this.closeCount;
    }

    private class ConnectionMetaData {
        public final DatabaseConnection connection;
        private final long expiresMillis;

        public ConnectionMetaData(DatabaseConnection connection) {
            this.connection = connection;
            long now = System.currentTimeMillis();
            this.expiresMillis = JdbcPooledConnectionSource.this.maxConnectionAgeMillis > Long.MAX_VALUE - now ? Long.MAX_VALUE : now + JdbcPooledConnectionSource.this.maxConnectionAgeMillis;
        }

        public boolean isExpired(long now) {
            return this.expiresMillis <= now;
        }

        public String toString() {
            return "@" + Integer.toHexString(this.hashCode());
        }
    }
}

