/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.support.DatabaseResults;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;

public class JdbcDatabaseResults
implements DatabaseResults {
    private final PreparedStatement preparedStmt;
    private final ResultSet resultSet;
    private ResultSetMetaData metaData = null;

    public JdbcDatabaseResults(PreparedStatement preparedStmt, ResultSet resultSet) {
        this.preparedStmt = preparedStmt;
        this.resultSet = resultSet;
    }

    public int getColumnCount() throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.resultSet.getMetaData();
        }
        return this.metaData.getColumnCount();
    }

    public int findColumn(String columnName) throws SQLException {
        return this.resultSet.findColumn(columnName) - 1;
    }

    public InputStream getBlobStream(int columnIndex) throws SQLException {
        Blob blob = this.resultSet.getBlob(columnIndex + 1);
        if (blob == null) {
            return null;
        }
        return blob.getBinaryStream();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.resultSet.getBoolean(columnIndex + 1);
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this.resultSet.getByte(columnIndex + 1);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.resultSet.getBytes(columnIndex + 1);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.resultSet.getDouble(columnIndex + 1);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.resultSet.getFloat(columnIndex + 1);
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.resultSet.getInt(columnIndex + 1);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.resultSet.getLong(columnIndex + 1);
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.resultSet.getShort(columnIndex + 1);
    }

    public String getString(int columnIndex) throws SQLException {
        return this.resultSet.getString(columnIndex + 1);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.resultSet.getTimestamp(columnIndex + 1);
    }

    public boolean next() throws SQLException {
        if (this.resultSet.next()) {
            return true;
        }
        if (!this.preparedStmt.getMoreResults()) {
            return false;
        }
        return this.resultSet.next();
    }

    public boolean wasNull(int columnIndex) throws SQLException {
        return this.resultSet.wasNull();
    }
}

