/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.stmt.mapped.MappedPreparedStmt;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatementBuilder<T, ID> {
    private static Logger logger = LoggerFactory.getLogger(StatementBuilder.class);
    protected final TableInfo<T> tableInfo;
    protected final DatabaseType databaseType;
    private final StatementType type;
    private Where where = null;
    protected Integer limit = null;

    public StatementBuilder(DatabaseType databaseType, TableInfo<T> tableInfo, StatementType type) {
        this.databaseType = databaseType;
        this.tableInfo = tableInfo;
        this.type = type;
        if (type != StatementType.SELECT && type != StatementType.UPDATE && type != StatementType.DELETE) {
            throw new IllegalStateException("Building a statement from a " + (Object)((Object)type) + " statement is not allowed");
        }
    }

    public Where where() {
        this.where = new Where(this.tableInfo);
        return this.where;
    }

    public void setWhere(Where where) {
        this.where = where;
    }

    @Deprecated
    public MappedPreparedStmt<T> prepareStatement() throws SQLException {
        ArrayList<FieldType> argFieldTypeList = new ArrayList<FieldType>();
        ArrayList<FieldType> resultFieldTypeList = new ArrayList<FieldType>();
        ArrayList<SelectArg> selectArgList = new ArrayList<SelectArg>();
        String statement = this.buildStatementString(argFieldTypeList, resultFieldTypeList, selectArgList);
        return new MappedPreparedStmt<T>(this.tableInfo, statement, argFieldTypeList, resultFieldTypeList, selectArgList, this.databaseType.isLimitSqlSupported() ? null : this.limit, this.type);
    }

    public String prepareStatementString() throws SQLException {
        ArrayList<FieldType> argFieldTypeList = new ArrayList<FieldType>();
        ArrayList<FieldType> resultFieldTypeList = new ArrayList<FieldType>();
        ArrayList<SelectArg> selectArgList = new ArrayList<SelectArg>();
        return this.buildStatementString(argFieldTypeList, resultFieldTypeList, selectArgList);
    }

    protected String buildStatementString(List<FieldType> argFieldTypeList, List<FieldType> resultFieldTypeList, List<SelectArg> selectArgList) throws SQLException {
        StringBuilder sb = new StringBuilder();
        this.appendStatementStart(sb, resultFieldTypeList);
        if (this.where != null) {
            sb.append("WHERE ");
            this.where.appendSql(this.databaseType, sb, selectArgList);
        }
        for (SelectArg selectArg : selectArgList) {
            FieldType fieldType = this.tableInfo.getFieldTypeByName(selectArg.getColumnName());
            argFieldTypeList.add(fieldType);
        }
        this.appendStatementEnd(sb);
        String statement = sb.toString();
        logger.debug("built statement {}", statement);
        return statement;
    }

    protected abstract void appendStatementStart(StringBuilder var1, List<FieldType> var2) throws SQLException;

    protected abstract void appendStatementEnd(StringBuilder var1);

    protected FieldType verifyColumnName(String columnName) {
        FieldType fieldType = this.tableInfo.getFieldTypeByName(columnName);
        if (fieldType == null) {
            throw new IllegalArgumentException("Unknown column-name '" + columnName + "'");
        }
        return fieldType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatementType {
        INSERT,
        SELECT,
        UPDATE,
        DELETE,
        EXECUTE;

    }
}

