/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.jdbc.JdbcDatabaseConnection;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class JdbcConnectionSource
implements ConnectionSource {
    private static Logger logger = LoggerFactory.getLogger(JdbcConnectionSource.class);
    private String url;
    private String username;
    private String password;
    private JdbcDatabaseConnection connection;

    public JdbcConnectionSource() {
    }

    public JdbcConnectionSource(String url) {
        this.url = url;
    }

    public JdbcConnectionSource(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public void initialize() {
        if (this.url == null) {
            throw new IllegalStateException("url was never set on " + this.getClass().getSimpleName());
        }
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
            logger.debug("closed connection to {}", this.url);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DatabaseConnection getReadOnlyConnection() throws SQLException {
        return this.getReadWriteConnection();
    }

    public DatabaseConnection getReadWriteConnection() throws SQLException {
        if (this.connection != null) {
            if (this.connection.isClosed()) {
                throw new SQLException("Connection has already been closed");
            }
            return this.connection;
        }
        Properties properties = new Properties();
        if (this.username != null) {
            properties.setProperty("user", this.username);
        }
        if (this.password != null) {
            properties.setProperty("password", this.password);
        }
        logger.debug("opening connection to {}", this.url);
        this.connection = new JdbcDatabaseConnection(DriverManager.getConnection(this.url, properties));
        if (this.connection == null) {
            throw new SQLException("Could not establish connection to database URL: " + this.url);
        }
        return this.connection;
    }

    public void releaseConnection(DatabaseConnection connection) throws SQLException {
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

