/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.RawResults;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.PreparedStmt;
import com.j256.ormlite.stmt.SelectIterator;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.mapped.MappedCreate;
import com.j256.ormlite.stmt.mapped.MappedDelete;
import com.j256.ormlite.stmt.mapped.MappedDeleteCollection;
import com.j256.ormlite.stmt.mapped.MappedQueryForId;
import com.j256.ormlite.stmt.mapped.MappedRefresh;
import com.j256.ormlite.stmt.mapped.MappedUpdate;
import com.j256.ormlite.stmt.mapped.MappedUpdateId;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementExecutor<T, ID> {
    private static Logger logger = LoggerFactory.getLogger(StatementExecutor.class);
    private final DatabaseType databaseType;
    private final TableInfo<T> tableInfo;
    private final Class<T> dataClass;
    private final FieldType idField;
    private final MappedQueryForId<T, ID> mappedQueryForId;
    private final PreparedStmt<T> preparedQueryForAll;
    private final MappedCreate<T> mappedInsert;
    private final MappedUpdate<T> mappedUpdate;
    private final MappedUpdateId<T, ID> mappedUpdateId;
    private final MappedDelete<T> mappedDelete;
    private final MappedRefresh<T, ID> mappedRefresh;

    public StatementExecutor(DatabaseType databaseType, TableInfo<T> tableInfo) throws SQLException {
        this.databaseType = databaseType;
        this.tableInfo = tableInfo;
        this.dataClass = tableInfo.getDataClass();
        this.idField = tableInfo.getIdField();
        this.mappedQueryForId = MappedQueryForId.build(databaseType, tableInfo);
        this.preparedQueryForAll = new StatementBuilder(databaseType, tableInfo).prepareStatement();
        this.mappedInsert = MappedCreate.build(databaseType, tableInfo);
        this.mappedUpdate = MappedUpdate.build(databaseType, tableInfo);
        this.mappedUpdateId = MappedUpdateId.build(databaseType, tableInfo);
        this.mappedDelete = MappedDelete.build(databaseType, tableInfo);
        this.mappedRefresh = MappedRefresh.build(databaseType, tableInfo);
    }

    public T queryForId(DatabaseConnection databaseConnection, ID id) throws SQLException {
        if (this.mappedQueryForId == null) {
            throw new SQLException("Cannot query-for-id with " + this.dataClass + " because it doesn't have an id field");
        }
        return this.mappedQueryForId.execute(databaseConnection, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T queryForFirst(DatabaseConnection databaseConnection, PreparedStmt<T> preparedStmt) throws SQLException {
        CompiledStatement stmt = null;
        try {
            stmt = preparedStmt.compile(databaseConnection);
            DatabaseResults results = stmt.executeQuery();
            if (results.next()) {
                logger.debug("query-for-first of '{}' returned at least 1 result", preparedStmt.getStatement());
                Object t = preparedStmt.mapRow(results);
                return t;
            }
            logger.debug("query-for-first of '{}' returned at 0 results", preparedStmt.getStatement());
            T t = null;
            return t;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public List<T> queryForAll(ConnectionSource connectionSource) throws SQLException {
        return this.query(connectionSource, this.preparedQueryForAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> query(ConnectionSource connectionSource, PreparedStmt<T> preparedStmt) throws SQLException {
        SelectIterator<T, ID> iterator = null;
        try {
            iterator = this.buildIterator(null, connectionSource, preparedStmt);
            ArrayList<T> results = new ArrayList<T>();
            while (iterator.hasNextThrow()) {
                results.add(iterator.nextThrow());
            }
            logger.debug("query of '{}' returned {} results", preparedStmt.getStatement(), results.size());
            ArrayList<T> arrayList = results;
            return arrayList;
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawResults queryRaw(ConnectionSource connectionSource, String query) throws SQLException {
        SelectIterator iterator = null;
        try {
            DatabaseConnection connection = connectionSource.getReadOnlyConnection();
            CompiledStatement compiledStatement = connection.compileStatement(query);
            RawResultsList results = new RawResultsList(compiledStatement);
            iterator = new SelectIterator(String[].class, null, results, connectionSource, connection, compiledStatement, null);
            while (iterator.hasNextThrow()) {
                results.add(iterator.nextThrow());
            }
            logger.debug("query of '{}' returned {} results", query, results.size());
            RawResultsList rawResultsList = results;
            return rawResultsList;
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    public SelectIterator<T, ID> buildIterator(BaseDaoImpl<T, ID> classDao, ConnectionSource connectionSource) throws SQLException {
        return this.buildIterator(classDao, connectionSource, this.preparedQueryForAll);
    }

    public SelectIterator<T, ID> buildIterator(BaseDaoImpl<T, ID> classDao, ConnectionSource connectionSource, PreparedStmt<T> preparedStmt) throws SQLException {
        DatabaseConnection connection = connectionSource.getReadOnlyConnection();
        return new SelectIterator<T, ID>(this.dataClass, classDao, preparedStmt, connectionSource, connection, preparedStmt.compile(connection), preparedStmt.getStatement());
    }

    public RawResults buildIterator(ConnectionSource connectionSource, String query) throws SQLException {
        DatabaseConnection connection = connectionSource.getReadOnlyConnection();
        return new RawResultsIterator(query, connectionSource, connection, connection.compileStatement(query));
    }

    public int create(DatabaseConnection databaseConnection, T data) throws SQLException {
        return this.mappedInsert.insert(databaseConnection, data);
    }

    public int update(DatabaseConnection databaseConnection, T data) throws SQLException {
        if (this.mappedUpdate == null) {
            throw new SQLException("Cannot update " + this.dataClass + " because it doesn't have an id field defined or only has id field");
        }
        return this.mappedUpdate.update(databaseConnection, data);
    }

    public int updateId(DatabaseConnection databaseConnection, T data, ID newId) throws SQLException {
        if (this.mappedUpdateId == null) {
            throw new SQLException("Cannot update " + this.dataClass + " because it doesn't have an id field defined");
        }
        return this.mappedUpdateId.execute(databaseConnection, data, newId);
    }

    public int refresh(DatabaseConnection databaseConnection, T data) throws SQLException {
        if (this.mappedQueryForId == null) {
            throw new SQLException("Cannot refresh " + this.dataClass + " because it doesn't have an id field defined");
        }
        Object result = this.mappedRefresh.execute(databaseConnection, data);
        if (result == null) {
            return 0;
        }
        return 1;
    }

    public int delete(DatabaseConnection databaseConnection, T data) throws SQLException {
        if (this.mappedDelete == null) {
            throw new SQLException("Cannot delete " + this.dataClass + " because it doesn't have an id field defined");
        }
        return this.mappedDelete.delete(databaseConnection, data);
    }

    public int deleteObjects(DatabaseConnection databaseConnection, Collection<T> datas) throws SQLException {
        if (this.idField == null) {
            throw new SQLException("Cannot delete " + this.dataClass + " because it doesn't have an id field defined");
        }
        return MappedDeleteCollection.deleteObjects(this.databaseType, this.tableInfo, databaseConnection, datas);
    }

    public int deleteIds(DatabaseConnection databaseConnection, Collection<ID> ids) throws SQLException {
        if (this.idField == null) {
            throw new SQLException("Cannot delete " + this.dataClass + " because it doesn't have an id field defined");
        }
        return MappedDeleteCollection.deleteIds(this.databaseType, this.tableInfo, databaseConnection, ids);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RawResultsIterator
    extends BaseRawResults {
        private final CompiledStatement statement;
        private final String query;
        private final ConnectionSource connectionSource;
        private final DatabaseConnection connection;

        public RawResultsIterator(String query, ConnectionSource connectionSource, DatabaseConnection connection, CompiledStatement statement) throws SQLException {
            super(statement);
            this.query = query;
            this.statement = statement;
            this.connectionSource = connectionSource;
            this.connection = connection;
        }

        @Override
        public CloseableIterator<String[]> iterator() {
            try {
                return new SelectIterator(String[].class, null, this, this.connectionSource, this.connection, this.statement, this.query);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RawResultsList
    extends BaseRawResults {
        private final List<String[]> results = new ArrayList<String[]>();

        public RawResultsList(CompiledStatement preparedStmt) throws SQLException {
            super(preparedStmt);
        }

        void add(String[] result) throws SQLException {
            this.results.add(result);
        }

        int size() {
            return this.results.size();
        }

        @Override
        public CloseableIterator<String[]> iterator() {
            return new RawResultsListIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RawResultsListIterator
        implements CloseableIterator<String[]> {
            private int resultC = 0;

            private RawResultsListIterator() {
            }

            @Override
            public boolean hasNext() {
                return RawResultsList.this.results.size() > this.resultC;
            }

            @Override
            public String[] next() {
                return (String[])RawResultsList.this.results.get(this.resultC++);
            }

            @Override
            public void remove() {
            }

            @Override
            public void close() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BaseRawResults
    implements RawResults,
    GenericRowMapper<String[]> {
        protected final int columnN;
        protected final String[] columnNames;

        protected BaseRawResults(CompiledStatement compiledStmt) throws SQLException {
            this.columnN = compiledStmt.getColumnCount();
            this.columnNames = new String[this.columnN];
            for (int colC = 0; colC < this.columnN; ++colC) {
                this.columnNames[colC] = compiledStmt.getColumnName(colC + 1);
            }
        }

        @Override
        public int getNumberColumns() {
            return this.columnN;
        }

        @Override
        public String[] getColumnNames() {
            return this.columnNames;
        }

        @Override
        public String[] mapRow(DatabaseResults rs) throws SQLException {
            String[] result = new String[this.columnN];
            for (int colC = 0; colC < this.columnN; ++colC) {
                result[colC] = rs.getString(colC + 1);
            }
            return result;
        }
    }
}

