/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import com.j256.ormlite.logger.Log;
import com.j256.ormlite.logger.LoggerFactory;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidLog
implements Log {
    private String className;
    private static Method isLoggableMethod;
    private static int VERBOSE;
    private static int DEBUG;
    private static int INFO;
    private static int WARN;
    private static int ERROR;
    private static Method vMethod;
    private static Method vThrowableMethod;
    private static Method dMethod;
    private static Method dThrowableMethod;
    private static Method iMethod;
    private static Method iThrowableMethod;
    private static Method wMethod;
    private static Method wThrowableMethod;
    private static Method eMethod;
    private static Method eThrowableMethod;

    public AndroidLog(String className) {
        this.className = LoggerFactory.getSimpleClassName(className);
        if (isLoggableMethod == null) {
            AndroidLog.findMethods();
        }
    }

    @Override
    public boolean isTraceEnabled() {
        try {
            return (Boolean)isLoggableMethod.invoke(null, this.className, VERBOSE);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLevelEnabled(DEBUG);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLevelEnabled(INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLevelEnabled(WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLevelEnabled(ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isLevelEnabled(ERROR);
    }

    @Override
    public void trace(String message) {
        this.logMessage(vMethod, message);
    }

    @Override
    public void trace(String message, Throwable t) {
        this.logMessage(vThrowableMethod, message, t);
    }

    @Override
    public void debug(String message) {
        this.logMessage(dMethod, message);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.logMessage(dThrowableMethod, message, t);
    }

    @Override
    public void info(String message) {
        this.logMessage(iMethod, message);
    }

    @Override
    public void info(String message, Throwable t) {
        this.logMessage(iThrowableMethod, message, t);
    }

    @Override
    public void warn(String message) {
        this.logMessage(wMethod, message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.logMessage(wThrowableMethod, message, t);
    }

    @Override
    public void error(String message) {
        this.logMessage(eMethod, message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.logMessage(eThrowableMethod, message, t);
    }

    @Override
    public void fatal(String message) {
        this.logMessage(eMethod, message);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.logMessage(eThrowableMethod, message, t);
    }

    private static void findMethods() {
        Class<?> clazz;
        try {
            clazz = Class.forName("android.util.Log");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        isLoggableMethod = AndroidLog.getMethod(clazz, "isLoggable", String.class, Integer.TYPE);
        VERBOSE = AndroidLog.getIntField(clazz, "VERBOSE");
        DEBUG = AndroidLog.getIntField(clazz, "DEBUG");
        INFO = AndroidLog.getIntField(clazz, "INFO");
        WARN = AndroidLog.getIntField(clazz, "WARN");
        ERROR = AndroidLog.getIntField(clazz, "ERROR");
        vMethod = AndroidLog.getMethod(clazz, "v", String.class, String.class);
        vThrowableMethod = AndroidLog.getMethod(clazz, "v", String.class, String.class, Throwable.class);
        dMethod = AndroidLog.getMethod(clazz, "d", String.class, String.class);
        dThrowableMethod = AndroidLog.getMethod(clazz, "d", String.class, String.class, Throwable.class);
        iMethod = AndroidLog.getMethod(clazz, "i", String.class, String.class);
        iThrowableMethod = AndroidLog.getMethod(clazz, "i", String.class, String.class, Throwable.class);
        wMethod = AndroidLog.getMethod(clazz, "w", String.class, String.class);
        wThrowableMethod = AndroidLog.getMethod(clazz, "w", String.class, String.class, Throwable.class);
        eMethod = AndroidLog.getMethod(clazz, "e", String.class, String.class);
        eThrowableMethod = AndroidLog.getMethod(clazz, "e", String.class, String.class, Throwable.class);
    }

    private boolean isLevelEnabled(int level) {
        if (isLoggableMethod == null) {
            return false;
        }
        try {
            return (Boolean)isLoggableMethod.invoke(null, this.className, level);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void logMessage(Method method, String message) {
        if (method != null) {
            try {
                method.invoke(null, this.className, message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void logMessage(Method method, String message, Throwable t) {
        if (method != null) {
            try {
                method.invoke(null, this.className, message, t);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int getIntField(Class<?> clazz, String fieldName) {
        try {
            return (Integer)clazz.getField(fieldName).get(null);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

