/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;

public class DatabaseTableConfigUtil {
    public static <T> DatabaseTableConfig<T> fromClass(ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        String tableName = DatabaseTableConfig.extractTableName(databaseType, clazz);
        ArrayList<DatabaseFieldConfig> fieldConfigs = new ArrayList<DatabaseFieldConfig>();
        for (Class<T> classWalk = clazz; classWalk != null; classWalk = classWalk.getSuperclass()) {
            for (Field field : classWalk.getDeclaredFields()) {
                DatabaseFieldConfig config = DatabaseFieldConfig.fromField(databaseType, tableName, field);
                if (config == null || !config.isPersisted()) continue;
                fieldConfigs.add(config);
            }
        }
        if (fieldConfigs.size() == 0) {
            return null;
        }
        return new DatabaseTableConfig<T>(clazz, tableName, fieldConfigs);
    }
}

