/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.table;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableUtils {
    private static Logger logger = LoggerFactory.getLogger(TableUtils.class);
    private static final FieldType[] noFieldTypes = new FieldType[0];

    private TableUtils() {
    }

    public static <T> int createTable(ConnectionSource connectionSource, Class<T> dataClass) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        return TableUtils.doCreateTable(databaseType, connectionSource, DatabaseTableConfig.fromClass(databaseType, dataClass));
    }

    public static <T> int createTable(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        return TableUtils.doCreateTable(connectionSource.getDatabaseType(), connectionSource, tableConfig);
    }

    public static <T> List<String> getCreateTableStatements(ConnectionSource connectionSource, Class<T> dataClass) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        return TableUtils.doCreateTableStatements(databaseType, DatabaseTableConfig.fromClass(databaseType, dataClass));
    }

    public static <T> List<String> getCreateTableStatements(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        return TableUtils.doCreateTableStatements(databaseType, tableConfig);
    }

    public static <T> int dropTable(ConnectionSource connectionSource, Class<T> dataClass, boolean ignoreErrors) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        return TableUtils.doDropTable(databaseType, connectionSource, DatabaseTableConfig.fromClass(databaseType, dataClass), ignoreErrors);
    }

    public static <T> int dropTable(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig, boolean ignoreErrors) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        return TableUtils.doDropTable(databaseType, connectionSource, tableConfig, ignoreErrors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> int doDropTable(DatabaseType databaseType, ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig, boolean ignoreErrors) throws SQLException {
        TableInfo<T> tableInfo = new TableInfo<T>(databaseType, tableConfig);
        logger.debug("dropping table '{}'", tableInfo.getTableName());
        Collection<String> statements = TableUtils.dropTableStatements(databaseType, tableInfo);
        DatabaseConnection connection = connectionSource.getReadWriteConnection();
        try {
            int n = TableUtils.doDropStatements(connection, statements, ignoreErrors);
            return n;
        }
        finally {
            connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doDropStatements(DatabaseConnection connection, Collection<String> statements, boolean ignoreErrors) throws SQLException {
        int stmtC = 0;
        for (String statement : statements) {
            int rowC = 0;
            CompiledStatement prepStmt = null;
            try {
                logger.debug("executing drop table statement: {}", statement);
                prepStmt = connection.compileStatement(statement, StatementBuilder.StatementType.EXECUTE, noFieldTypes, noFieldTypes);
                rowC = prepStmt.executeUpdate();
            }
            catch (SQLException e) {
                if (!ignoreErrors) {
                    throw e;
                }
            }
            finally {
                if (prepStmt != null) {
                    prepStmt.close();
                }
            }
            if (rowC < 0) {
                throw new SQLException("SQL statement " + statement + " updated " + rowC + " rows, we were expecting >= 0");
            }
            ++stmtC;
        }
        return stmtC;
    }

    private static <T> void createTableStatements(DatabaseType databaseType, TableInfo<T> tableInfo, List<String> statements, List<String> queriesAfter) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        databaseType.appendEscapedEntityName(sb, tableInfo.getTableName());
        sb.append(" (");
        ArrayList<String> additionalArgs = new ArrayList<String>();
        ArrayList<String> statementsBefore = new ArrayList<String>();
        ArrayList<String> statementsAfter = new ArrayList<String>();
        boolean first = true;
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            databaseType.appendColumnArg(sb, fieldType, additionalArgs, statementsBefore, statementsAfter, queriesAfter);
        }
        for (String arg : additionalArgs) {
            sb.append(", ").append(arg);
        }
        sb.append(") ");
        databaseType.appendCreateTableSuffix(sb);
        statements.addAll(statementsBefore);
        statements.add(sb.toString());
        statements.addAll(statementsAfter);
    }

    private static <T> Collection<String> dropTableStatements(DatabaseType databaseType, TableInfo<T> tableInfo) {
        ArrayList<String> statementsBefore = new ArrayList<String>();
        ArrayList<String> statementsAfter = new ArrayList<String>();
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            databaseType.dropColumnArg(fieldType, statementsBefore, statementsAfter);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE ");
        databaseType.appendEscapedEntityName(sb, tableInfo.getTableName());
        sb.append(' ');
        ArrayList<String> statements = new ArrayList<String>();
        statements.addAll(statementsBefore);
        statements.add(sb.toString());
        statements.addAll(statementsAfter);
        return statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> int doCreateTable(DatabaseType databaseType, ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        TableInfo<T> tableInfo = new TableInfo<T>(databaseType, tableConfig);
        logger.debug("creating table '{}'", tableInfo.getTableName());
        ArrayList<String> statements = new ArrayList<String>();
        ArrayList<String> queriesAfter = new ArrayList<String>();
        TableUtils.createTableStatements(databaseType, tableInfo, statements, queriesAfter);
        DatabaseConnection connection = connectionSource.getReadWriteConnection();
        try {
            int n = TableUtils.doCreateStatements(connection, databaseType, statements, queriesAfter);
            return n;
        }
        finally {
            connectionSource.releaseConnection(connection);
        }
    }

    private static int doCreateStatements(DatabaseConnection connection, DatabaseType databaseType, List<String> statements, List<String> queriesAfter) throws SQLException {
        int stmtC = 0;
        for (String statement : statements) {
            int rowC;
            CompiledStatement prepStmt = null;
            try {
                logger.debug("executing create table statement: {}", statement);
                prepStmt = connection.compileStatement(statement, StatementBuilder.StatementType.EXECUTE, noFieldTypes, noFieldTypes);
                rowC = prepStmt.executeUpdate();
            }
            catch (SQLException e) {
                throw SqlExceptionUtil.create("SQL statement failed: " + statement, e);
            }
            finally {
                if (prepStmt != null) {
                    prepStmt.close();
                }
            }
            if (rowC < 0) {
                throw new SQLException("SQL statement updated " + rowC + " rows, we were expecting >= 0: " + statement);
            }
            if (rowC > 0 && databaseType.isCreateTableReturnsZero()) {
                throw new SQLException("SQL statement updated " + rowC + " rows, we were expecting == 0: " + statement);
            }
            ++stmtC;
        }
        for (String query : queriesAfter) {
            CompiledStatement prepStmt = null;
            DatabaseResults results = null;
            try {
                prepStmt = connection.compileStatement(query, StatementBuilder.StatementType.EXECUTE, noFieldTypes, noFieldTypes);
                results = prepStmt.executeQuery();
                int rowC = 0;
                while (results.next()) {
                    ++rowC;
                }
                logger.debug("executing create table after-query got {} results: {}", rowC, query);
            }
            catch (SQLException e) {
                throw SqlExceptionUtil.create("executing create table after-query failed: " + query, e);
            }
            finally {
                if (prepStmt != null) {
                    prepStmt.close();
                }
            }
            ++stmtC;
        }
        return stmtC;
    }

    private static <T> List<String> doCreateTableStatements(DatabaseType databaseType, DatabaseTableConfig<T> tableConfig) throws SQLException {
        TableInfo<T> tableInfo = new TableInfo<T>(databaseType, tableConfig);
        ArrayList<String> statements = new ArrayList<String>();
        ArrayList<String> queriesAfter = new ArrayList<String>();
        TableUtils.createTableStatements(databaseType, tableInfo, statements, queriesAfter);
        return statements;
    }
}

