/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.RawResults;
import com.j256.ormlite.dao.RawRowMapper;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.PreparedStmt;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectIterator;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.mapped.MappedCreate;
import com.j256.ormlite.stmt.mapped.MappedDelete;
import com.j256.ormlite.stmt.mapped.MappedDeleteCollection;
import com.j256.ormlite.stmt.mapped.MappedQueryForId;
import com.j256.ormlite.stmt.mapped.MappedRefresh;
import com.j256.ormlite.stmt.mapped.MappedUpdate;
import com.j256.ormlite.stmt.mapped.MappedUpdateId;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementExecutor<T, ID> {
    private static Logger logger = LoggerFactory.getLogger(StatementExecutor.class);
    private final DatabaseType databaseType;
    private final TableInfo<T> tableInfo;
    private MappedQueryForId<T, ID> mappedQueryForId;
    private PreparedQuery<T> preparedQueryForAll;
    private MappedCreate<T, ID> mappedInsert;
    private MappedUpdate<T, ID> mappedUpdate;
    private MappedUpdateId<T, ID> mappedUpdateId;
    private MappedDelete<T, ID> mappedDelete;
    private MappedRefresh<T, ID> mappedRefresh;
    private final FieldType[] noFieldTypes = new FieldType[0];

    public StatementExecutor(DatabaseType databaseType, TableInfo<T> tableInfo) throws SQLException {
        this.databaseType = databaseType;
        this.tableInfo = tableInfo;
    }

    public T queryForId(DatabaseConnection databaseConnection, ID id) throws SQLException {
        if (this.mappedQueryForId == null) {
            this.mappedQueryForId = MappedQueryForId.build(this.databaseType, this.tableInfo);
        }
        return this.mappedQueryForId.execute(databaseConnection, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T queryForFirst(DatabaseConnection databaseConnection, PreparedStmt<T> preparedQuery) throws SQLException {
        CompiledStatement stmt = null;
        try {
            stmt = preparedQuery.compile(databaseConnection);
            DatabaseResults results = stmt.executeQuery();
            if (results.next()) {
                logger.debug("query-for-first of '{}' returned at least 1 result", preparedQuery.getStatement());
                Object t = preparedQuery.mapRow(results);
                return t;
            }
            logger.debug("query-for-first of '{}' returned at 0 results", preparedQuery.getStatement());
            T t = null;
            return t;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public List<T> queryForAll(ConnectionSource connectionSource) throws SQLException {
        this.prepareQueryForAll();
        return this.query(connectionSource, this.preparedQueryForAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> query(ConnectionSource connectionSource, PreparedStmt<T> preparedQuery) throws SQLException {
        SelectIterator<T, ID> iterator = null;
        try {
            iterator = this.buildIterator(null, connectionSource, preparedQuery);
            ArrayList<T> results = new ArrayList<T>();
            while (iterator.hasNextThrow()) {
                results.add(iterator.nextThrow());
            }
            logger.debug("query of '{}' returned {} results", preparedQuery.getStatement(), results.size());
            ArrayList<T> arrayList = results;
            return arrayList;
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawResults queryRaw(ConnectionSource connectionSource, String query) throws SQLException {
        SelectIterator iterator = null;
        try {
            DatabaseConnection connection = connectionSource.getReadOnlyConnection();
            CompiledStatement compiledStatement = connection.compileStatement(query, StatementBuilder.StatementType.SELECT, this.noFieldTypes, this.tableInfo.getFieldTypes());
            RawResultsList results = new RawResultsList(compiledStatement);
            iterator = new SelectIterator(String[].class, null, results, connectionSource, connection, compiledStatement, null);
            while (iterator.hasNextThrow()) {
                results.add(iterator.nextThrow());
            }
            logger.debug("query of '{}' returned {} results", query, results.size());
            RawResultsList rawResultsList = results;
            return rawResultsList;
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    public SelectIterator<T, ID> buildIterator(BaseDaoImpl<T, ID> classDao, ConnectionSource connectionSource) throws SQLException {
        this.prepareQueryForAll();
        return this.buildIterator(classDao, connectionSource, this.preparedQueryForAll);
    }

    public SelectIterator<T, ID> buildIterator(BaseDaoImpl<T, ID> classDao, ConnectionSource connectionSource, PreparedStmt<T> preparedQuery) throws SQLException {
        DatabaseConnection connection = connectionSource.getReadOnlyConnection();
        return new SelectIterator<T, ID>(this.tableInfo.getDataClass(), classDao, preparedQuery, connectionSource, connection, preparedQuery.compile(connection), preparedQuery.getStatement());
    }

    public RawResults buildIterator(ConnectionSource connectionSource, String query) throws SQLException {
        DatabaseConnection connection = connectionSource.getReadOnlyConnection();
        return new RawResultsIterator(query, connectionSource, connection, connection.compileStatement(query, StatementBuilder.StatementType.SELECT, this.noFieldTypes, this.tableInfo.getFieldTypes()));
    }

    public int create(DatabaseConnection databaseConnection, T data) throws SQLException {
        if (this.mappedInsert == null) {
            this.mappedInsert = MappedCreate.build(this.databaseType, this.tableInfo);
        }
        return this.mappedInsert.insert(databaseConnection, data);
    }

    public int update(DatabaseConnection databaseConnection, T data) throws SQLException {
        if (this.mappedUpdate == null) {
            this.mappedUpdate = MappedUpdate.build(this.databaseType, this.tableInfo);
        }
        return this.mappedUpdate.update(databaseConnection, data);
    }

    public int updateId(DatabaseConnection databaseConnection, T data, ID newId) throws SQLException {
        if (this.mappedUpdateId == null) {
            this.mappedUpdateId = MappedUpdateId.build(this.databaseType, this.tableInfo);
        }
        return this.mappedUpdateId.execute(databaseConnection, data, newId);
    }

    public int update(DatabaseConnection databaseConnection, PreparedUpdate<T> preparedUpdate) throws SQLException {
        CompiledStatement stmt = preparedUpdate.compile(databaseConnection);
        return stmt.executeUpdate();
    }

    public int refresh(DatabaseConnection databaseConnection, T data) throws SQLException {
        if (this.mappedRefresh == null) {
            this.mappedRefresh = MappedRefresh.build(this.databaseType, this.tableInfo);
        }
        return this.mappedRefresh.executeRefresh(databaseConnection, data);
    }

    public int delete(DatabaseConnection databaseConnection, T data) throws SQLException {
        if (this.mappedDelete == null) {
            this.mappedDelete = MappedDelete.build(this.databaseType, this.tableInfo);
        }
        return this.mappedDelete.delete(databaseConnection, data);
    }

    public int deleteObjects(DatabaseConnection databaseConnection, Collection<T> datas) throws SQLException {
        return MappedDeleteCollection.deleteObjects(this.databaseType, this.tableInfo, databaseConnection, datas);
    }

    public int deleteIds(DatabaseConnection databaseConnection, Collection<ID> ids) throws SQLException {
        return MappedDeleteCollection.deleteIds(this.databaseType, this.tableInfo, databaseConnection, ids);
    }

    public int delete(DatabaseConnection databaseConnection, PreparedDelete<T> preparedDelete) throws SQLException {
        CompiledStatement stmt = preparedDelete.compile(databaseConnection);
        return stmt.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <CT> CT callBatchTasks(DatabaseConnection connection, Callable<CT> callable) throws Exception {
        CT CT;
        block4: {
            boolean autoCommitAtStart = false;
            try {
                if (connection.isAutoCommitSupported() && (autoCommitAtStart = connection.getAutoCommit())) {
                    connection.setAutoCommit(false);
                    logger.debug("disabled auto-commit on table {} before batch tasks", this.tableInfo.getTableName());
                }
                CT = callable.call();
                if (!autoCommitAtStart) break block4;
            }
            catch (Throwable throwable) {
                if (autoCommitAtStart) {
                    connection.setAutoCommit(true);
                    logger.debug("re-enabled auto-commit on table {} after batch tasks", this.tableInfo.getTableName());
                }
                throw throwable;
            }
            connection.setAutoCommit(true);
            logger.debug("re-enabled auto-commit on table {} after batch tasks", this.tableInfo.getTableName());
        }
        return CT;
    }

    private void prepareQueryForAll() throws SQLException {
        if (this.preparedQueryForAll == null) {
            this.preparedQueryForAll = new QueryBuilder(this.databaseType, this.tableInfo).prepare();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RawRowMapperIterator<T>
    implements CloseableIterator<T> {
        private String[] columnNames;
        private CloseableIterator<String[]> stringIterator;
        private RawRowMapper<T> rowMapper;

        public RawRowMapperIterator(String[] columnNames, CloseableIterator<String[]> stringIterator, RawRowMapper<T> rowMapper) {
            this.columnNames = columnNames;
            this.stringIterator = stringIterator;
            this.rowMapper = rowMapper;
        }

        @Override
        public boolean hasNext() {
            return this.stringIterator.hasNext();
        }

        @Override
        public T next() {
            String[] stringResult = (String[])this.stringIterator.next();
            return this.rowMapper.mapRow(this.columnNames, stringResult);
        }

        @Override
        public void remove() {
            this.stringIterator.remove();
        }

        @Override
        public void close() throws SQLException {
            this.stringIterator.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RawResultsIterator
    extends BaseRawResults {
        private final CompiledStatement statement;
        private final String query;
        private final ConnectionSource connectionSource;
        private final DatabaseConnection connection;

        public RawResultsIterator(String query, ConnectionSource connectionSource, DatabaseConnection connection, CompiledStatement statement) throws SQLException {
            super(statement);
            this.query = query;
            this.statement = statement;
            this.connectionSource = connectionSource;
            this.connection = connection;
            logger.debug("executing raw results iterator for: {}", query);
        }

        @Override
        public CloseableIterator<String[]> iterator() {
            try {
                return new SelectIterator(String[].class, null, this, this.connectionSource, this.connection, this.statement, this.query);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RawResultsList
    extends BaseRawResults {
        private final List<String[]> results = new ArrayList<String[]>();

        public RawResultsList(CompiledStatement preparedStmt) throws SQLException {
            super(preparedStmt);
        }

        void add(String[] result) throws SQLException {
            this.results.add(result);
        }

        int size() {
            return this.results.size();
        }

        @Override
        public CloseableIterator<String[]> iterator() {
            return new RawResultsListIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RawResultsListIterator
        implements CloseableIterator<String[]> {
            private int resultC = 0;

            private RawResultsListIterator() {
            }

            @Override
            public boolean hasNext() {
                return RawResultsList.this.results.size() > this.resultC;
            }

            @Override
            public String[] next() {
                return (String[])RawResultsList.this.results.get(this.resultC++);
            }

            @Override
            public void remove() {
            }

            @Override
            public void close() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BaseRawResults
    implements RawResults,
    GenericRowMapper<String[]> {
        protected final int columnN;
        protected final String[] columnNames;

        protected BaseRawResults(CompiledStatement compiledStmt) throws SQLException {
            this.columnN = compiledStmt.getColumnCount();
            this.columnNames = new String[this.columnN];
            for (int colC = 0; colC < this.columnN; ++colC) {
                this.columnNames[colC] = compiledStmt.getColumnName(colC + 1);
            }
        }

        @Override
        public int getNumberColumns() {
            return this.columnN;
        }

        @Override
        public String[] getColumnNames() {
            return this.columnNames;
        }

        @Override
        public String[] mapRow(DatabaseResults rs) throws SQLException {
            String[] result = new String[this.columnN];
            for (int colC = 0; colC < this.columnN; ++colC) {
                result[colC] = rs.getString(colC + 1);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String[]> getResults() throws SQLException {
            ArrayList<String[]> results = new ArrayList<String[]>();
            CloseableIterator iterator = this.iterator();
            try {
                while (iterator.hasNext()) {
                    results.add((String[])iterator.next());
                }
                ArrayList<String[]> arrayList = results;
                return arrayList;
            }
            finally {
                iterator.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> List<T> getMappedResults(RawRowMapper<T> mapper) throws SQLException {
            ArrayList<T> results = new ArrayList<T>();
            RawRowMapperIterator<T> iterator = new RawRowMapperIterator<T>(this.columnNames, this.iterator(), mapper);
            try {
                while (iterator.hasNext()) {
                    results.add(iterator.next());
                }
                ArrayList<T> arrayList = results;
                return arrayList;
            }
            finally {
                iterator.close();
            }
        }

        @Override
        public <T> CloseableIterator<T> iterator(RawRowMapper<T> mapper) {
            return new RawRowMapperIterator<T>(this.columnNames, this.iterator(), mapper);
        }
    }
}

