/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.mapped.BaseMappedQuery;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedPreparedStmt<T, ID>
extends BaseMappedQuery<T, ID>
implements PreparedQuery<T>,
PreparedDelete<T>,
PreparedUpdate<T> {
    private final SelectArg[] selectArgs;
    private final Integer limit;
    private final StatementBuilder.StatementType type;

    public MappedPreparedStmt(TableInfo<T> tableInfo, String statement, List<FieldType> argFieldTypeList, List<FieldType> resultFieldTypeList, List<SelectArg> selectArgList, Integer limit, StatementBuilder.StatementType type) {
        super(tableInfo, statement, argFieldTypeList, resultFieldTypeList);
        this.selectArgs = selectArgList.toArray(new SelectArg[selectArgList.size()]);
        if (this.argSqlTypes == null || this.selectArgs.length != this.argSqlTypes.length) {
            throw new IllegalArgumentException("Should be the same number of SelectArg and field-types in the arrays");
        }
        this.limit = limit;
        this.type = type;
    }

    @Override
    public CompiledStatement compile(DatabaseConnection databaseConnection) throws SQLException {
        CompiledStatement stmt = databaseConnection.compileStatement(this.statement, this.type);
        if (this.limit != null) {
            stmt.setMaxRows(this.limit);
        }
        Object[] args = null;
        if (logger.isTraceEnabled() && this.selectArgs.length > 0) {
            args = new Object[this.selectArgs.length];
        }
        for (int i = 0; i < this.selectArgs.length; ++i) {
            Object arg = this.selectArgs[i].getSqlArgValue();
            if (arg == null) {
                stmt.setNull(i + 1, this.argSqlTypes[i]);
            } else {
                stmt.setObject(i + 1, arg, this.argSqlTypes[i]);
            }
            if (args == null) continue;
            args[i] = arg;
        }
        logger.debug("prepared statement '{}' with {} args", this.statement, this.selectArgs.length);
        if (args != null) {
            logger.trace("prepared statement arguments: {}", new Object[]{args});
        }
        return stmt;
    }

    @Override
    public String getStatement() {
        return this.statement;
    }
}

