/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.mapped.BaseMappedStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedDeleteCollection<T, ID>
extends BaseMappedStatement<T, ID> {
    private MappedDeleteCollection(TableInfo<T> tableInfo, String statement, List<FieldType> argFieldTypeList) {
        super(tableInfo, statement, argFieldTypeList);
    }

    public static <T, ID> int deleteObjects(DatabaseType databaseType, TableInfo<T> tableInfo, DatabaseConnection databaseConnection, Collection<T> datas) throws SQLException {
        MappedDeleteCollection<T, ID> deleteCollection = MappedDeleteCollection.build(databaseType, tableInfo, datas.size());
        Object[] fieldObjects = new Object[datas.size()];
        int objC = 0;
        for (T data : datas) {
            fieldObjects[objC] = tableInfo.getIdField().extractJavaFieldToSqlArgValue(data);
            ++objC;
        }
        return MappedDeleteCollection.updateRows(databaseConnection, deleteCollection, fieldObjects);
    }

    public static <T, ID> int deleteIds(DatabaseType databaseType, TableInfo<T> tableInfo, DatabaseConnection databaseConnection, Collection<ID> ids) throws SQLException {
        MappedDeleteCollection<T, ID> deleteCollection = MappedDeleteCollection.build(databaseType, tableInfo, ids.size());
        Object[] fieldObjects = new Object[ids.size()];
        int objC = 0;
        for (ID id : ids) {
            fieldObjects[objC] = tableInfo.getIdField().convertJavaFieldToSqlArgValue(id);
            ++objC;
        }
        return MappedDeleteCollection.updateRows(databaseConnection, deleteCollection, fieldObjects);
    }

    private static <T, ID> MappedDeleteCollection<T, ID> build(DatabaseType databaseType, TableInfo<T> tableInfo, int dataSize) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot delete " + tableInfo.getDataClass() + " because it doesn't have an id field defined");
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<FieldType> argFieldTypeList = new ArrayList<FieldType>();
        MappedDeleteCollection.appendTableName(databaseType, sb, "DELETE FROM ", tableInfo.getTableName());
        MappedDeleteCollection.appendWhereIds(databaseType, idField, sb, dataSize, argFieldTypeList);
        return new MappedDeleteCollection<T, ID>(tableInfo, sb.toString(), argFieldTypeList);
    }

    private static <T, ID> int updateRows(DatabaseConnection databaseConnection, MappedDeleteCollection<T, ID> deleteCollection, Object[] args) throws SQLException {
        try {
            int rowC = databaseConnection.delete(deleteCollection.statement, args, deleteCollection.argSqlTypes);
            logger.debug("delete-collection with statement '{}' and {} args, changed {} rows", deleteCollection.statement, args.length, rowC);
            if (args.length > 0) {
                logger.trace("delete-collection arguments: {}", new Object[]{args});
            }
            return rowC;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Unable to run delete collection stmt: " + deleteCollection.statement, e);
        }
    }

    private static void appendWhereIds(DatabaseType databaseType, FieldType idField, StringBuilder sb, int numDatas, List<FieldType> fieldTypeList) {
        sb.append("WHERE ");
        databaseType.appendEscapedEntityName(sb, idField.getDbColumnName());
        sb.append(" IN (");
        boolean first = true;
        for (int i = 0; i < numDatas; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append('?');
            if (fieldTypeList == null) continue;
            fieldTypeList.add(idField);
        }
        sb.append(") ");
    }
}

