/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.j256.ormlite.android.AndroidCompiledStatement;
import com.j256.ormlite.android.AndroidDatabaseResults;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.support.GeneratedKeyHolder;
import java.sql.Savepoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidDatabaseConnection
implements DatabaseConnection {
    private static Logger logger = LoggerFactory.getLogger(AndroidDatabaseConnection.class);
    private final SQLiteDatabase db;
    private final boolean readWrite;

    public AndroidDatabaseConnection(SQLiteDatabase db, boolean readWrite) {
        this.db = db;
        this.readWrite = readWrite;
        logger.trace("databased opened, read-write = {}: {}", (Object)readWrite, (Object)db);
    }

    public boolean isAutoCommitSupported() {
        return false;
    }

    public boolean getAutoCommit() throws java.sql.SQLException {
        try {
            boolean inTransaction = this.db.inTransaction();
            logger.trace("database in transaction is {}", (Object)inTransaction);
            return !inTransaction;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)"problems getting auto-commit from database", (Throwable)e);
        }
    }

    public void setAutoCommit(boolean autoCommit) {
    }

    public Savepoint setSavePoint(String name) throws java.sql.SQLException {
        try {
            this.db.beginTransaction();
            logger.trace("save-point set with name {}", (Object)name);
            return new OurSavePoint(name);
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("problems beginning transaction " + name), (Throwable)e);
        }
    }

    public boolean isReadWrite() {
        return this.readWrite;
    }

    public void commit(Savepoint savepoint) throws java.sql.SQLException {
        try {
            this.db.setTransactionSuccessful();
            this.db.endTransaction();
            if (savepoint == null) {
                logger.trace("database transaction is successfuly ended");
            } else {
                logger.trace("database transaction {} is successfuly ended", (Object)savepoint.getSavepointName());
            }
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("problems commiting transaction " + savepoint.getSavepointName()), (Throwable)e);
        }
    }

    public void rollback(Savepoint savepoint) throws java.sql.SQLException {
        try {
            this.db.endTransaction();
            if (savepoint == null) {
                logger.trace("database transaction is ended, unsuccessfuly");
            } else {
                logger.trace("database transaction {} is ended, unsuccessfuly", (Object)savepoint.getSavepointName());
            }
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("problems rolling back transaction " + savepoint.getSavepointName()), (Throwable)e);
        }
    }

    public CompiledStatement compileStatement(String statement, StatementBuilder.StatementType type, FieldType[] argFieldTypes) {
        AndroidCompiledStatement stmt = new AndroidCompiledStatement(statement, this.db, type);
        logger.trace("compiled statement: {}", (Object)statement);
        return stmt;
    }

    public CompiledStatement compileStatement(String statement, StatementBuilder.StatementType type, FieldType[] argFieldTypes, int resultFlags) {
        return this.compileStatement(statement, type, argFieldTypes);
    }

    public int insert(String statement, Object[] args, FieldType[] argFieldTypes, GeneratedKeyHolder keyHolder) throws java.sql.SQLException {
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement(statement);
            this.bindArgs(stmt, args, argFieldTypes);
            long rowId = stmt.executeInsert();
            if (keyHolder != null) {
                keyHolder.addKey((Number)rowId);
            }
            logger.trace("insert statement is compiled and executed: {}", (Object)statement);
            int n = 1;
            return n;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("inserting to database failed: " + statement), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public int update(String statement, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        return this.update(statement, args, argFieldTypes, "updated");
    }

    public int delete(String statement, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        return this.update(statement, args, argFieldTypes, "deleted");
    }

    public <T> Object queryForOne(String statement, Object[] args, FieldType[] argFieldTypes, GenericRowMapper<T> rowMapper, ObjectCache objectCache) throws java.sql.SQLException {
        Cursor cursor = null;
        try {
            cursor = this.db.rawQuery(statement, this.toStrings(args));
            AndroidDatabaseResults results = new AndroidDatabaseResults(cursor, objectCache);
            logger.trace("queried for one result with {}", (Object)statement);
            if (!results.first()) {
                Object var8_9 = null;
                return var8_9;
            }
            Object first = rowMapper.mapRow((DatabaseResults)results);
            if (results.next()) {
                Object object = MORE_THAN_ONE;
                return object;
            }
            Object object = first;
            return object;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("queryForOne from database failed: " + statement), (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public long queryForLong(String statement) throws java.sql.SQLException {
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement(statement);
            long result = stmt.simpleQueryForLong();
            logger.trace("query for long simple query returned {}: {}", (Object)result, (Object)statement);
            long l = result;
            return l;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("queryForLong from database failed: " + statement), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public long queryForLong(String statement, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        Cursor cursor = null;
        try {
            cursor = this.db.rawQuery(statement, this.toStrings(args));
            AndroidDatabaseResults results = new AndroidDatabaseResults(cursor, null);
            logger.trace("query for long raw query executed: {}", (Object)statement);
            if (results.first()) {
                long l = results.getLong(0);
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("queryForLong from database failed: " + statement), (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public void close() throws java.sql.SQLException {
        try {
            this.db.close();
            logger.trace("database closed: {}", (Object)this.db);
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)"problems closing the database connection", (Throwable)e);
        }
    }

    public boolean isClosed() throws java.sql.SQLException {
        try {
            boolean isOpen = this.db.isOpen();
            logger.trace("database is open returned {}", (Object)isOpen);
            return !isOpen;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)"problems detecting if the database is closed", (Throwable)e);
        }
    }

    public boolean isTableExists(String tableName) {
        Cursor cursor = this.db.rawQuery("SELECT DISTINCT tbl_name FROM sqlite_master WHERE tbl_name = '" + tableName + "'", null);
        return cursor != null && cursor.getCount() > 0;
    }

    private int update(String statement, Object[] args, FieldType[] argFieldTypes, String label) throws java.sql.SQLException {
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement(statement);
            this.bindArgs(stmt, args, argFieldTypes);
            stmt.execute();
            logger.trace("{} statement is compiled and executed: {}", (Object)label, (Object)statement);
            int n = 1;
            return n;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("updating database failed: " + statement), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private void bindArgs(SQLiteStatement stmt, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        if (args == null) {
            return;
        }
        block6: for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) {
                stmt.bindNull(i + 1);
                continue;
            }
            switch (argFieldTypes[i].getSqlType()) {
                case CHAR: 
                case STRING: 
                case LONG_STRING: {
                    stmt.bindString(i + 1, arg.toString());
                    continue block6;
                }
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INTEGER: 
                case LONG: {
                    stmt.bindLong(i + 1, ((Number)arg).longValue());
                    continue block6;
                }
                case FLOAT: 
                case DOUBLE: {
                    stmt.bindDouble(i + 1, ((Number)arg).doubleValue());
                    continue block6;
                }
                case BYTE_ARRAY: 
                case SERIALIZABLE: {
                    stmt.bindBlob(i + 1, (byte[])arg);
                    continue block6;
                }
                default: {
                    throw new java.sql.SQLException("Unknown sql argument type " + argFieldTypes[i].getSqlType());
                }
            }
        }
    }

    private String[] toStrings(Object[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        String[] strings = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            strings[i] = arg == null ? null : arg.toString();
        }
        return strings;
    }

    private static class OurSavePoint
    implements Savepoint {
        private String name;

        public OurSavePoint(String name) {
            this.name = name;
        }

        public int getSavepointId() {
            return 0;
        }

        public String getSavepointName() {
            return this.name;
        }
    }
}

