/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import com.j256.ormlite.android.AndroidDatabaseResults;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseResults;
import java.util.ArrayList;
import java.util.List;

public class AndroidCompiledStatement
implements CompiledStatement {
    private final String sql;
    private final SQLiteDatabase db;
    private final StatementBuilder.StatementType type;
    private Cursor cursor;
    private final List<Object> args = new ArrayList<Object>();
    private Integer max;

    public AndroidCompiledStatement(String sql, SQLiteDatabase db, StatementBuilder.StatementType type) {
        this.sql = sql;
        this.db = db;
        this.type = type;
    }

    public int getColumnCount() throws java.sql.SQLException {
        return this.getCursor().getColumnCount();
    }

    public String getColumnName(int column) throws java.sql.SQLException {
        return this.getCursor().getColumnName(column);
    }

    public DatabaseResults runQuery(ObjectCache objectCache) throws java.sql.SQLException {
        if (!this.type.isOkForQuery()) {
            throw new IllegalArgumentException("Cannot call query on a " + this.type + " statement");
        }
        return new AndroidDatabaseResults(this.getCursor(), objectCache);
    }

    public int runUpdate() throws java.sql.SQLException {
        if (!this.type.isOkForUpdate()) {
            throw new IllegalArgumentException("Cannot call update on a " + this.type + " statement");
        }
        String finalSql = null;
        try {
            finalSql = this.max == null ? this.sql : this.sql + " " + this.max;
            this.db.execSQL(finalSql, this.args.toArray(new Object[this.args.size()]));
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("Problems executing Android statement: " + finalSql), (Throwable)e);
        }
        return 1;
    }

    public int runExecute() throws java.sql.SQLException {
        if (!this.type.isOkForExecute()) {
            throw new IllegalArgumentException("Cannot call execute on a " + this.type + " statement");
        }
        try {
            this.db.execSQL(this.sql, new Object[0]);
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("Problems executing Android statement: " + this.sql), (Throwable)e);
        }
        return 0;
    }

    public void close() throws java.sql.SQLException {
        if (this.cursor != null) {
            try {
                this.cursor.close();
            }
            catch (SQLException e) {
                throw SqlExceptionUtil.create((String)"Problems closing Android cursor", (Throwable)e);
            }
        }
    }

    public void setObject(int parameterIndex, Object obj, SqlType sqlType) throws java.sql.SQLException {
        this.isInPrep();
        if (obj == null) {
            this.args.add(parameterIndex, null);
        } else {
            this.args.add(parameterIndex, obj.toString());
        }
    }

    public void setMaxRows(int max) throws java.sql.SQLException {
        this.isInPrep();
        this.max = max;
    }

    public Cursor getCursor() throws java.sql.SQLException {
        if (this.cursor == null) {
            String finalSql = null;
            try {
                finalSql = this.max == null ? this.sql : this.sql + " " + this.max;
                this.cursor = this.db.rawQuery(finalSql, this.args.toArray(new String[this.args.size()]));
                this.cursor.moveToFirst();
            }
            catch (SQLException e) {
                throw SqlExceptionUtil.create((String)("Problems executing Android query: " + finalSql), (Throwable)e);
            }
        }
        return this.cursor;
    }

    private void isInPrep() throws java.sql.SQLException {
        if (this.cursor != null) {
            throw new java.sql.SQLException("Query already run. Cannot add argument values.");
        }
    }
}

