/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.Log;
import java.util.Arrays;

public class Logger {
    private static final String ARG_STRING = "{}";
    private static final int ARG_STRING_LENGTH = "{}".length();
    private final Log log;

    public Logger(Log log) {
        this.log = log;
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    public void trace(String msg, Object ... args) {
        this.trace((Throwable)null, msg, args);
    }

    public void trace(Throwable throwable, String msg, Object ... args) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.buildFullMessage(msg, args), throwable);
        }
    }

    public void debug(String msg, Object ... args) {
        this.debug((Throwable)null, msg, args);
    }

    public void debug(Throwable throwable, String msg, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.buildFullMessage(msg, args), throwable);
        }
    }

    public void info(String msg, Object ... args) {
        this.info((Throwable)null, msg, args);
    }

    public void info(Throwable throwable, String msg, Object ... args) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.buildFullMessage(msg, args), throwable);
        }
    }

    public void warn(String msg, Object ... args) {
        this.warn((Throwable)null, msg, args);
    }

    public void warn(Throwable throwable, String msg, Object ... args) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(this.buildFullMessage(msg, args), throwable);
        }
    }

    public void error(String msg, Object ... args) {
        this.error((Throwable)null, msg, args);
    }

    public void error(Throwable throwable, String msg, Object ... args) {
        if (this.log.isErrorEnabled()) {
            this.log.error(this.buildFullMessage(msg, args), throwable);
        }
    }

    public void fatal(String msg, Object ... args) {
        this.fatal((Throwable)null, msg, args);
    }

    public void fatal(Throwable throwable, String msg, Object ... args) {
        if (this.log.isFatalEnabled()) {
            this.log.fatal(this.buildFullMessage(msg, args), throwable);
        }
    }

    private String buildFullMessage(String msg, Object[] args) {
        int argIndex;
        StringBuilder sb = new StringBuilder();
        int lastIndex = 0;
        int argC = 0;
        while ((argIndex = msg.indexOf(ARG_STRING, lastIndex)) != -1) {
            sb.append(msg.substring(lastIndex, argIndex));
            lastIndex = argIndex + ARG_STRING_LENGTH;
            if (argC >= args.length) continue;
            Object arg = args[argC];
            if (arg != null && arg.getClass().isArray()) {
                sb.append(Arrays.toString((Object[])arg));
            } else {
                sb.append(arg);
            }
            ++argC;
        }
        sb.append(msg.substring(lastIndex));
        return sb.toString();
    }
}

