/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android.apptools;

import android.content.Context;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenHelperManager {
    private static final String HELPER_CLASS_RESOURCE_NAME = "open_helper_classname";
    private static Logger logger = LoggerFactory.getLogger(OpenHelperManager.class);
    private static SqliteOpenHelperFactory factory = null;
    private static Class<? extends OrmLiteSqliteOpenHelper> helperClass = null;
    private static volatile OrmLiteSqliteOpenHelper helper = null;
    private static boolean wasClosed = false;
    private static int instanceCount = 0;

    @Deprecated
    public static void setOpenHelperFactory(SqliteOpenHelperFactory factory) {
        OpenHelperManager.factory = factory;
    }

    public static void setOpenHelperClass(Class<? extends OrmLiteSqliteOpenHelper> openHelperClass) {
        OpenHelperManager.innerSetHelperClass(openHelperClass);
    }

    public static synchronized OrmLiteSqliteOpenHelper getHelper(Context context) {
        if (helper == null) {
            if (context == null) {
                throw new IllegalArgumentException("context argument is null");
            }
            if (wasClosed) {
                logger.info("helper has already been closed and is being re-opened.", new Object[0]);
            }
            Context appContext = context.getApplicationContext();
            if (factory == null) {
                if (helperClass == null) {
                    OpenHelperManager.innerSetHelperClass(OpenHelperManager.lookupHelperClass(appContext, context.getClass()));
                }
                helper = OpenHelperManager.constructHelper(helperClass, appContext);
            } else {
                helper = factory.getHelper(appContext);
            }
            instanceCount = 0;
        }
        ++instanceCount;
        return helper;
    }

    public static OrmLiteSqliteOpenHelper getHelper(Context context, Class<? extends OrmLiteSqliteOpenHelper> openHelperClass) {
        if (helper == null) {
            OpenHelperManager.innerSetHelperClass(openHelperClass);
        }
        return OpenHelperManager.getHelper(context);
    }

    @Deprecated
    public static void release() {
        OpenHelperManager.releaseHelper();
    }

    public static synchronized void releaseHelper() {
        if (--instanceCount == 0) {
            if (helper != null) {
                helper.close();
                helper = null;
                wasClosed = true;
            }
        } else if (instanceCount < 0) {
            throw new IllegalStateException("Too many calls to release helper.  Instance count = " + instanceCount);
        }
    }

    private static void innerSetHelperClass(Class<? extends OrmLiteSqliteOpenHelper> openHelperClass) {
        if (helperClass == null) {
            helperClass = openHelperClass;
        } else if (helperClass != openHelperClass) {
            throw new IllegalStateException("Helper class was " + helperClass + " but is trying to be reset to " + openHelperClass);
        }
    }

    private static OrmLiteSqliteOpenHelper constructHelper(Class<? extends OrmLiteSqliteOpenHelper> openHelperClass, Context context) {
        Constructor<? extends OrmLiteSqliteOpenHelper> constructor;
        try {
            constructor = openHelperClass.getConstructor(Context.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not find constructor that takes a Context argument for " + openHelperClass, e);
        }
        try {
            return constructor.newInstance(context);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not construct instance of helper class " + openHelperClass, e);
        }
    }

    private static Class<? extends OrmLiteSqliteOpenHelper> lookupHelperClass(Context context, Class<?> componentClass) {
        int resourceId = context.getResources().getIdentifier(HELPER_CLASS_RESOURCE_NAME, "string", context.getPackageName());
        if (resourceId != 0) {
            String className = context.getResources().getString(resourceId);
            try {
                Class<?> castClass = Class.forName(className);
                return castClass;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create helper instance for class " + className, e);
            }
        }
        while (componentClass != null) {
            Type[] types;
            Type superType = componentClass.getGenericSuperclass();
            if (superType != null && superType instanceof ParameterizedType && (types = ((ParameterizedType)superType).getActualTypeArguments()) != null && types.length != 0) {
                for (Type type : types) {
                    Class clazz;
                    if (!(type instanceof Class) || !OrmLiteSqliteOpenHelper.class.isAssignableFrom(clazz = (Class)type)) continue;
                    Class castOpenHelperClass = clazz;
                    return castOpenHelperClass;
                }
            }
            componentClass = componentClass.getSuperclass();
        }
        throw new IllegalStateException("Could not find OpenHelperClass because none of its generic parameters extends OrmLiteSqliteOpenHelper: " + componentClass);
    }

    @Deprecated
    public static interface SqliteOpenHelperFactory {
        public OrmLiteSqliteOpenHelper getHelper(Context var1);
    }
}

