/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.service.impl;

import com.apache.api.manager.PluginConnector;
import com.apache.api.manager.ProxyManager;
import com.apache.api.vo.ParamsVo;
import com.apache.cache.util.Validator;
import com.apache.database.exception.DaoAccessException;
import com.apache.exception.BusinessException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IusProxyManagerImpl
implements ProxyManager {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected Map<String, List<PluginConnector>> plugins = new HashMap<String, List<PluginConnector>>();

    public void setPlugins(Map<String, List<PluginConnector>> plugins) {
        this.plugins = plugins;
    }

    public Object saveInvoke(ParamsVo vo) throws BusinessException {
        String key = vo.getKey();
        if (!Validator.isEmpty(this.plugins) && !Validator.isEmpty(this.plugins.get(key))) {
            Object result = null;
            try {
                for (PluginConnector plugin : this.plugins.get(key)) {
                    result = plugin.execute(vo);
                }
            }
            catch (Exception e) {
                if (e instanceof DaoAccessException || e instanceof BusinessException) {
                    throw new BusinessException(e.getMessage());
                }
                this.log.error("\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("\u6267\u884c\u51fa\u9519:" + e.getMessage(), (Throwable)e);
            }
            return result;
        }
        return null;
    }

    public Object doInvoke(ParamsVo vo) throws BusinessException {
        String key = vo.getKey();
        if (!Validator.isEmpty(this.plugins) && !Validator.isEmpty(this.plugins.get(key))) {
            Object result = null;
            try {
                for (PluginConnector plugin : this.plugins.get(key)) {
                    result = plugin.execute(vo);
                }
            }
            catch (Exception e) {
                if (e instanceof DaoAccessException || e instanceof BusinessException) {
                    throw new BusinessException(e.getMessage());
                }
                this.log.error("\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("\u6267\u884c\u51fa\u9519:" + e.getMessage(), (Throwable)e);
            }
            return result;
        }
        return null;
    }
}

