/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.apache.api.vo.ResultEntity;
import com.apache.cache.service.CacheManager;
import com.apache.cache.service.impl.LoadCacheFactory;
import com.apache.cache.service.impl.redis.RedisCoreFactory;
import com.apache.cache.util.Validator;
import com.apache.database.constant.SystemTools;
import com.apache.exception.BusinessException;
import com.apache.ius.plugin.IusPluginUtil;
import com.apache.tools.DataMap;
import com.apache.tools.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class InitCacheDataUtil {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static InitCacheDataUtil instance;
    private String datasource = "plateform";

    public void initDataToCacheOther(String sysEname, String tableObjName) {
        this.log.info("\u3010\u5f00\u59cb\u540c\u6b65\u5176\u4ed6\u6269\u5c55\u5185\u5bb9\u81f3\u7f13\u5b58\u3011--->[" + sysEname + "][" + tableObjName + "]");
        if ("plateform".equals(sysEname)) {
            sysEname = "";
        }
        if ("sysAppConfig".equals(tableObjName) || StrUtil.isNull((String)tableObjName)) {
            this.initSysAppConfig(sysEname);
        }
        if ("sysZuulRoute".equals(tableObjName) || StrUtil.isNull((String)tableObjName)) {
            this.initSysZuuulRoute(sysEname);
        }
        if ("sysZuulBlack".equals(tableObjName) || StrUtil.isNull((String)tableObjName)) {
            this.initZuulBlack();
        }
    }

    public void initDataToCacheOther(String sysEname, String tableObjName, List<DataMap> dataList, Map<String, String> paramMap) {
        this.log.info("\u3010\u5f00\u59cb\u540c\u6b65\u5176\u4ed6\u6269\u5c55\u5185\u5bb9\u81f3\u7f13\u5b58\u3011--->[" + sysEname + "][" + tableObjName + "]");
        if ("sysAppConfig".equals(tableObjName) || "sysZuulRoute".equals(tableObjName)) {
            if ("plateform".equals(sysEname)) {
                sysEname = "";
            }
            if ("sysAppConfig".equals(tableObjName) || StrUtil.isNull((String)tableObjName)) {
                this.initSysAppConfig(sysEname);
            }
            if ("sysZuulRoute".equals(tableObjName) || StrUtil.isNull((String)tableObjName)) {
                this.initSysZuuulRoute(sysEname);
            }
        } else {
            this.initOtherData(sysEname, tableObjName, dataList, paramMap);
        }
    }

    public void initSysAppConfig(String sysEname) {
        ResultEntity resultEntity;
        String searchObjName = "s_sysAppConfig";
        HashMap<String, Object> whereMap = new HashMap<String, Object>();
        if (!StrUtil.isNull((String)sysEname)) {
            whereMap.put("sysAppConfig.w_sysName", sysEname);
        }
        if ((resultEntity = IusPluginUtil.getInstance().select(this.datasource, "list", searchObjName, whereMap)).getEntity() == null) {
            return;
        }
        List restList = (List)resultEntity.getEntity();
        if (restList == null || restList.size() == 0) {
            this.log.info("\u540c\u6b65[\u9ad8\u7ea7\u914d\u7f6e]\u7f13\u5b58\uff1a\u65e0\u6570\u636e\u53ef\u540c\u6b65\uff01");
        }
        HashMap sysNameMap = new HashMap();
        for (DataMap item : restList) {
            String sysnameTemp = String.valueOf(item.get("sysName"));
            List<Object> dataListConfig = new ArrayList<DataMap>();
            if (sysNameMap.containsKey(sysnameTemp)) {
                dataListConfig = (List)sysNameMap.get(sysnameTemp);
            }
            dataListConfig.add(item);
            sysNameMap.put(sysnameTemp, dataListConfig);
        }
        Iterator iter00 = sysNameMap.entrySet().iterator();
        while (iter00.hasNext()) {
            String sysTitle = StrUtil.isNull((String)sysEname) ? "\u6240\u6709" : sysEname;
            Map.Entry entry = iter00.next();
            String key_sysName = String.valueOf(entry.getKey());
            List dataList = (List)entry.getValue();
            this.log.info("\u540c\u6b65[\u9ad8\u7ea7\u914d\u7f6e]\u7f13\u5b58\uff1a[" + sysTitle + "]\u5f85\u5904\u7406[" + dataList.size() + "]\u6570\u636estart....");
            if (Validator.isEmpty((List)dataList) || dataList.size() == 0) continue;
            String cache_spaceName = key_sysName + "_app_config";
            SystemTools.getInstance().getCache(cache_spaceName).removeAll();
            int count = dataList.size();
            HashMap typeMap = new HashMap();
            for (int i = 0; i < dataList.size(); ++i) {
                Map oldMap = new HashMap<String, Map>();
                Map obj = (Map)dataList.get(i);
                String typeCode = String.valueOf(obj.get("typeCode"));
                String appKey = String.valueOf(obj.get("appKey"));
                if (typeMap.containsKey(typeCode)) {
                    oldMap = (Map)typeMap.get(typeCode);
                }
                oldMap.put(appKey, obj);
                typeMap.put(typeCode, oldMap);
            }
            Iterator iter = typeMap.entrySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                Map.Entry entry22 = iter.next();
                String key = String.valueOf(entry22.getKey());
                Map value = (Map)entry22.getValue();
                this.log.info("-(" + ++i + ")[" + key + "][" + value + "] ");
            }
            SystemTools.getInstance().getCache(cache_spaceName).createCacheObject("app_config", typeMap);
            this.log.info("\u540c\u6b65[\u9ad8\u7ea7\u914d\u7f6e]\u7f13\u5b58\uff1a[" + sysTitle + "][" + i + "]\u7c7b\u5171\u8ba1[" + count + "]\u6761\u6570\u636e\u5230\u7f13\u5b58[" + cache_spaceName + "]\u5b8c\u6210\uff01");
        }
    }

    public void initSysZuuulRoute(String sysEname) {
        ResultEntity resultEntity;
        String cache_spaceName = "zuul.routes";
        String searchObjName = "s_sysZuulRoute";
        String sysTitle = StrUtil.isNull((String)sysEname) ? "\u6240\u6709" : sysEname;
        HashMap<String, Object> whereMap = new HashMap<String, Object>();
        whereMap.put("sysZuulRoute.w_enabled", "1");
        if (!StrUtil.isNull((String)sysEname)) {
            whereMap.put("sysZuulRoute.w_sysName", sysEname);
        }
        if ((resultEntity = IusPluginUtil.getInstance().select(this.datasource, "list", searchObjName, whereMap)).getEntity() == null) {
            return;
        }
        List dataList = (List)resultEntity.getEntity();
        if (dataList == null || dataList.size() == 0) {
            this.log.info("\u540c\u6b65[\u9ad8\u7ea7\u914d\u7f6e]\u7f13\u5b58\uff1a\u65e0\u6570\u636e\u53ef\u540c\u6b65\uff01");
        }
        this.log.info("\u540c\u6b65[\u7f51\u5173\u8def\u7531\u914d\u7f6e]\u7f13\u5b58\uff1a[" + sysTitle + "]\u5f85\u5904\u7406[" + dataList.size() + "]\u6570\u636estart....");
        int count = 0;
        if (Validator.isEmpty((List)dataList)) {
            SystemTools.getInstance().getCache(cache_spaceName).removeAll();
        } else {
            count = dataList.size();
            SystemTools.getInstance().getCache(cache_spaceName).removeAll();
            CacheManager zuulRoutes = LoadCacheFactory.getInstance().getCacheManager(cache_spaceName);
            for (int i = 0; i < dataList.size(); ++i) {
                Map map = (Map)dataList.get(i);
                String key = String.valueOf(map.get("infoId"));
                this.log.info("-(" + (i + 1) + ")[\u7f51\u5173\u8def\u7531\u914d\u7f6e][" + String.valueOf(map.get("serviceId")) + "->" + String.valueOf(map.get("path")) + "]\u5230\u7f13\u5b58");
                zuulRoutes.createCacheObject(key, (Object)map);
            }
        }
        this.log.info("\u540c\u6b65[\u7f51\u5173\u8def\u7531\u914d\u7f6e]\u7f13\u5b58\uff1a[" + sysTitle + "][" + count + "]\u6761\u6570\u636e\u5230\u7f13\u5b58[" + cache_spaceName + "]\u5b8c\u6210\uff01");
    }

    public void initZuulBlack() {
        String searchObjName = "s_sysZuulBlack";
        HashMap<String, Object> whereMap = new HashMap<String, Object>();
        whereMap.put("sysZuulBlack.w_enabled", "1");
        ResultEntity resultEntity = IusPluginUtil.getInstance().select(this.datasource, "list", searchObjName, whereMap);
        if (resultEntity.getEntity() == null) {
            return;
        }
        List dataList = (List)resultEntity.getEntity();
        if (dataList == null || dataList.size() == 0) {
            this.log.info("\u540c\u6b65[\u9ad8\u7ea7\u914d\u7f6e]\u7f13\u5b58\uff1a\u65e0\u6570\u636e\u53ef\u540c\u6b65\uff01");
        }
        this.buildCacheInfo("", null);
        if (!Validator.isEmpty((List)dataList)) {
            int count = dataList.size();
            for (int i = 0; i < count; ++i) {
                Map map = (Map)dataList.get(i);
                String key = String.valueOf(map.get("useIp"));
                this.buildCacheInfo(key, map);
                this.log.info("-(" + (i + 1) + ")[\u9ed1\u767d\u540d\u5355\u914d\u7f6e][" + (String)map.get("infoId") + "->" + key + "]\u5230\u7f13\u5b58");
            }
        }
    }

    public void initOtherData(String sysEname, String tableObjName, List<DataMap> dataList, Map<String, String> paramMap) {
        String sysTitle;
        String cache_spaceName = sysEname + "_" + tableObjName + "_cache";
        this.log.info("\u3010\u5f00\u59cb\u540c\u6b65\u67e5\u8be2\u5bf9\u8c61[" + tableObjName + "]\u7684\u5185\u5bb9\u81f3\u7f13\u5b58\u3011--->" + cache_spaceName);
        String dataCacheKey = paramMap.containsKey("dataCacheKey") ? paramMap.get("dataCacheKey") : "infoId";
        this.log.info("\u7f13\u5b58\u6570\u636ekey\u89c4\u5219\u4f9d\u636e-->[" + dataCacheKey + "]");
        String[] dataCacheKeyArr = dataCacheKey.split(",");
        String string = sysTitle = StrUtil.isNull((String)sysEname) ? "\u6240\u6709" : sysEname;
        if (dataList == null || dataList.size() == 0) {
            this.log.info("\u540c\u6b65\u7f13\u5b58\uff1a\u65e0\u6570\u636e\u53ef\u540c\u6b65\uff01");
        }
        this.log.info("\u540c\u6b65\u7f13\u5b58\uff1a\u5f85\u5904\u7406[" + dataList.size() + "]\u660e\u7ec6\u6570\u636estart....");
        int count = 0;
        int groupCount = 0;
        if (Validator.isEmpty(dataList)) {
            SystemTools.getInstance().getCache(cache_spaceName).removeAll();
        } else {
            count = dataList.size();
            SystemTools.getInstance().getCache(cache_spaceName).removeAll();
            CacheManager cacheManager = LoadCacheFactory.getInstance().getCacheManager(cache_spaceName);
            HashMap cacheListMap = new HashMap();
            if (count > 0) {
                for (int i = 0; i < dataList.size(); ++i) {
                    Map map = (Map)dataList.get(i);
                    String key = "";
                    for (String k : dataCacheKeyArr) {
                        key = key + String.valueOf(map.get(k)) + "_";
                    }
                    if (key.length() > 1) {
                        key = key.substring(0, key.length() - 1);
                    }
                    if (StrUtil.isNull((String)key)) {
                        this.log.error("\u8bf7\u6307\u5b9a\u6709\u6548\u503c\u4f5c\u4e3akey\uff0c\u53ef\u4ee5\u7528dataCacheKey\u4f20\u5165\u53c2\u6570\u660e\u786e\u8be5\u8868\u5185\u5b57\u6bb5\u540d\u79f0");
                        throw new BusinessException("\u8bf7\u6307\u5b9a\u6709\u6548\u503c\u5b57\u6bb5\u4f5c\u4e3a\u7f13\u5b58key\uff01");
                    }
                    List childList = new ArrayList<Map>();
                    if (cacheListMap.containsKey(key)) {
                        childList = (List)cacheListMap.get(key);
                    }
                    childList.add(map);
                    cacheListMap.put(key, childList);
                }
                if (cacheListMap.size() > 0) {
                    for (String key : cacheListMap.keySet()) {
                        List valueList = (List)cacheListMap.get(key);
                        cacheManager.createCacheObject(key, (Object)valueList);
                        this.log.warn("-[" + key + "]\u7f13\u5b58\u4e86[" + valueList.size() + "]\u6761\u6570\u636e\uff01");
                        ++groupCount;
                    }
                    this.log.info("\u540c\u6b65\u7f13\u5b58\uff1a[" + sysTitle + "][" + groupCount + "]\u7ec4\u6570\u636e\u7f13\u5b58[" + cache_spaceName + "]\u5b8c\u6210\uff01");
                }
            }
        }
    }

    public static InitCacheDataUtil getInstance() {
        if (null == instance) {
            instance = new InitCacheDataUtil();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildCacheInfo(String key, Map<String, String> info) {
        Jedis jedis = null;
        try {
            jedis = RedisCoreFactory.getInstance().getJedis();
            jedis.select(10);
            if (StrUtil.isNull((String)key)) {
                jedis.del("black.white");
                jedis.del("whiteIpList");
                return;
            }
            jedis.hsetnx("black.white", key, JSON.toJSONString(info));
            if ("1".equals(info.get("infoType"))) {
                String obj = jedis.get("whiteIpList");
                JSONArray ips = null;
                ips = StrUtil.isNull((String)obj) ? new JSONArray() : JSON.parseArray((String)obj);
                ips.add((Object)key);
                jedis.set("whiteIpList", ips.toJSONString());
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

