/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.impl;

import com.apache.api.manager.PluginConnector;
import com.apache.api.manager.ProxyManager;
import com.apache.api.vo.ParamsVo;
import com.apache.api.vo.ResultEntity;
import com.apache.cache.util.Validator;
import com.apache.database.db.IDao;
import com.apache.database.model.MethodParam;
import com.apache.exception.BusinessException;
import com.apache.ius.IusSqlTools;
import com.apache.tools.StrUtil;
import com.apache.tools.UUIDUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultPublicForSqlPluginImpl
implements PluginConnector {
    private IDao iusPubDao;
    private ProxyManager iusProxyManager;
    private ProxyManager netProxyManager;
    private Logger logger = LoggerFactory.getLogger((String)"ius logs");

    public Object execute(ParamsVo paramVo) throws Exception {
        String key = String.valueOf(paramVo.getParams("sqlKeyId"));
        ResultEntity entity = new ResultEntity();
        entity.setResult("true");
        if (Validator.isNull((String)key)) {
            key = "ByObjInfo";
            paramVo.setParams("sqlKeyId", (Object)"ByObjInfo");
        }
        MethodParam params = new MethodParam(key, "", "", "com.apache.ius.sql.DymicMapper");
        Map map = paramVo.getParams();
        String resultType = String.valueOf(paramVo.getParams("resultType"));
        map.remove("resultType");
        if (StrUtil.isNull((String)paramVo.getParamsToStr("traceId"))) {
            paramVo.setParams("traceId", (Object)UUIDUtil.getPrimaryKey());
        }
        try {
            if ("processSql".equalsIgnoreCase(resultType)) {
                paramVo.setKey("iusTransaction");
                paramVo.setParams("resultType", (Object)resultType);
                entity = (ResultEntity)this.iusProxyManager.saveInvoke(paramVo);
                if ("T".equalsIgnoreCase(entity.getResult())) {
                    paramVo.setParams("resultEntity", entity.getEntity());
                    IusSqlTools.getInstance().exeCustomPluginForAfter(paramVo, "after");
                    if (null != paramVo.getParams("afterPluginEntity")) {
                        entity.setEntity(paramVo.getParams("afterPluginEntity"));
                    }
                }
            } else if ("objInfo".equals(resultType)) {
                paramVo.setKey("iusTransaction");
                paramVo.setParams("resultType", (Object)resultType);
                entity = (ResultEntity)this.iusProxyManager.doInvoke(paramVo);
                paramVo.setParams("resultEntity", entity.getEntity());
                IusSqlTools.getInstance().exeCustomPluginForAfter(paramVo, "after");
                if (null != paramVo.getParams("afterPluginEntity")) {
                    entity.setEntity(paramVo.getParams("afterPluginEntity"));
                }
            } else if ("execSql".equalsIgnoreCase(resultType)) {
                this.execSql(entity, params, paramVo);
            } else if ("execInsertSql".equalsIgnoreCase(resultType)) {
                this.execInsertSql(entity, params, paramVo);
            } else {
                this.exeMarkSql(entity, params, map, resultType);
            }
        }
        catch (BusinessException e) {
            String exceptionStr = String.valueOf(paramVo.getParams("businessException"));
            if (Validator.isNotNull((String)exceptionStr)) {
                entity.setMessage(exceptionStr);
            } else {
                entity.setMessage(e.getMessage());
            }
            entity.setEntity((Object)"F");
        }
        params = null;
        paramVo = null;
        return entity;
    }

    private void execSql(ResultEntity entity, MethodParam params, ParamsVo paramVo) {
        String execSql = IusSqlTools.getInstance().cteageNativeSql(paramVo, "update");
        if (Validator.isNotNull((String)execSql)) {
            params.setParams("execSql", execSql);
            this.iusPubDao.select(params);
            String result = (String)params.getParamsByKey("result");
            if ("T".equals(result)) {
                entity.setEntity((Object)result);
            } else {
                entity.setMessage("\u6267\u884c\u5931\u8d25");
            }
        } else {
            entity.setMessage("\u7f3a\u5c11\u65b9\u6cd5\u6267\u884c\u53c2\u6570");
        }
    }

    private void execInsertSql(ResultEntity entity, MethodParam params, ParamsVo paramVo) {
        String execSql = IusSqlTools.getInstance().cteageNativeSql(paramVo, "insert");
        if (Validator.isNotNull((String)execSql)) {
            params.setParams("execSql", execSql);
            this.iusPubDao.select(params);
            String result = (String)params.getParamsByKey("result");
            if ("T".equals(result)) {
                entity.setEntity((Object)result);
            } else {
                entity.setMessage("\u6267\u884c\u5931\u8d25");
            }
        } else {
            entity.setMessage("\u7f3a\u5c11\u65b9\u6cd5\u6267\u884c\u53c2\u6570");
        }
    }

    private void exeMarkSql(ResultEntity entity, MethodParam params, Map<String, Object> map, String resultType) {
        String val = String.valueOf(map.get("resultObjType"));
        if (!Validator.isEmpty((Object)this.netProxyManager)) {
            params.setSpanceName("com.iussoft.net.trans.TransPublic");
        }
        if ("obj".equalsIgnoreCase(val)) {
            params.setParams(map);
            Object obj = this.iusPubDao.selectSingle(params);
            entity.setEntity(obj);
        } else if ("count".equalsIgnoreCase(resultType)) {
            params.setParams(map);
            long obj = this.iusPubDao.count(params);
            entity.setEntity((Object)obj);
        } else {
            params.setResultCache(false);
            String rows = String.valueOf(map.get("rows"));
            map.remove("rows");
            if (Validator.isNull((String)rows)) {
                params.setParams(map);
                entity.setEntity((Object)this.iusPubDao.select(params));
            } else {
                params.setPageIndex(Integer.valueOf(StrUtil.doNull((String)String.valueOf(map.get("page")), (String)"1")).intValue());
                map.remove("page");
                params.setParams(map);
                params.setPageSize(Integer.valueOf(rows).intValue());
                entity.setEntity((Object)this.iusPubDao.pageSelect(params));
            }
            entity.setMessage("\u67e5\u8be2\u6210\u529f");
        }
    }

    public void setIusPubDao(IDao iusPubDao) {
        this.iusPubDao = iusPubDao;
    }

    public void setIusProxyManager(ProxyManager iusProxyManager) {
        this.iusProxyManager = iusProxyManager;
    }

    public void setNetProxyManager(ProxyManager netProxyManager) {
        this.netProxyManager = netProxyManager;
    }
}

