/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.impl;

import com.apache.cache.service.CacheManager;
import com.apache.cache.service.impl.redis.RedisManagerImpl;
import com.apache.cache.util.Validator;
import com.apache.ius.plugin.MaxContentPorxyPlugin;
import com.apache.tools.DateUtils;
import com.apache.tools.FileOperate;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class MaxContentPorxyPluginImpl
implements MaxContentPorxyPlugin {
    private static MaxContentPorxyPluginImpl instance;
    private CacheManager cacheManager;
    String rootPath = "";

    public void init() {
        instance = this;
        this.cacheManager = new RedisManagerImpl();
        this.cacheManager.setCacheName("Max_Content_Spaces");
        this.rootPath = Validator.getClassLoaderPath().replace("WEB-INF/classes", "filedb");
    }

    public static MaxContentPorxyPluginImpl getInstance() {
        return instance;
    }

    @Override
    public Object saveContent(String key, Map<String, ?> params) {
        String content = String.valueOf(params.get("cacheContent"));
        if (Validator.isNull((String)content)) {
            return "";
        }
        String dbType = String.valueOf(params.get("dbType"));
        if ("file".equalsIgnoreCase(dbType)) {
            return this.saveFileInfo(key, content);
        }
        return this.saveCacheInfo(key, content);
    }

    @Override
    public void delContent(String key, String ... others) {
        String dbType = "";
        if (null != others && others.length > 0) {
            dbType = String.valueOf(others[0]);
        }
        if ("file".equalsIgnoreCase(dbType)) {
            File file = new File(this.rootPath + "/" + key);
            if (file.exists() && file.isFile()) {
                file.delete();
            }
        } else {
            this.cacheManager.removeCacheObject(key);
        }
    }

    @Override
    public Object doContent(String key, String ... others) {
        String dbType = "";
        if (null != others && others.length > 0) {
            dbType = String.valueOf(others[0]);
        }
        if ("file".equalsIgnoreCase(dbType)) {
            return this.viewFileInfo(key);
        }
        return this.viewCacheInfo(key);
    }

    private String saveCacheInfo(String key, Object obj) {
        if (Validator.isNull((String)key) || "fsId".equalsIgnoreCase(key)) {
            key = "cache_" + Validator.generate();
        }
        this.cacheManager.createCacheObject(key, obj);
        return key;
    }

    private String saveFileInfo(String key, String content) {
        String filePath = "";
        String result = key;
        if (Validator.isNull((String)key) || "fsId".equalsIgnoreCase(key)) {
            key = DateUtils.Now.fmt_HHmmssSSS().replace(":", "") + ".dl";
            String path = DateUtils.Now.fmt_yyyyMMdd().replace("-", "/");
            filePath = this.rootPath + path + "/";
            FileOperate.getInstance().newCreateFolder(filePath);
            filePath = filePath + key;
            result = path + "/" + key;
        } else {
            filePath = this.rootPath + key;
        }
        FileOperate.getInstance().newCreateFile(filePath, content);
        return result;
    }

    private String viewCacheInfo(String key) {
        if (this.cacheManager.checkCacheObject(key)) {
            return String.valueOf(this.cacheManager.getCacheCloneByKey(key));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String viewFileInfo(String key) {
        BufferedInputStream in = null;
        try {
            String content;
            in = new BufferedInputStream(new FileInputStream(this.rootPath + key));
            String string = content = IOUtils.toString((InputStream)in, (String)"UTF-8");
            IOUtils.closeQuietly((InputStream)in);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return "";
    }
}

