/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.controller;

import com.alibaba.fastjson.JSON;
import com.apache.api.api.ApiService;
import com.apache.api.vo.ParamsVo;
import com.apache.api.vo.ResultEntity;
import com.apache.api.vo.ResultMsg;
import com.apache.cache.service.impl.LoadCacheFactory;
import com.apache.database.constant.SpringContextLoader;
import com.apache.database.datasource.DynamicDataSource;
import com.apache.database.model.Page;
import com.apache.ius.common.BodyReaderHttpServletRequestWrapper;
import com.apache.ius.common.annotion.BeanFactory;
import com.apache.rpc.common.LoadRpcService;
import com.apache.tools.ConfigUtil;
import com.apache.tools.DataMap;
import com.apache.tools.RequestTools;
import com.apache.tools.StrUtil;
import com.apache.uct.common.LoginUser;
import com.apache.uct.common.PBOSSOTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;

public abstract class BaseAction {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    @Qualifier(value="iusService")
    protected ApiService iusService;
    protected static String defService;

    protected void gotoLogin(HttpServletRequest request, HttpServletResponse response, String msg) throws IOException {
        ResultMsg rmsg = new ResultMsg("F", StrUtil.doNull((String)msg, (String)"\u60a8\u8fd8\u6ca1\u6709\u767b\u5f55\uff0c\u8bf7\u60a8\u5148\u767b\u5f55\u518d\u8fdb\u884c\u76f8\u5e94\u64cd\u4f5c"));
        JSONObject array = JSONObject.fromObject((Object)rmsg);
        this.outputJson(array.toString(), response, request.getParameter("callback"));
    }

    protected LoginUser getLoginUser(HttpServletRequest request, HttpServletResponse response) {
        LoginUser loginUser = BeanFactory.getInstance().getLoginUser(request);
        return loginUser;
    }

    protected void gotoErrorPage(HttpServletRequest request, HttpServletResponse response, String errors) throws IOException, ServletException {
        ResultMsg rmsg = new ResultMsg("F", StrUtil.doNull((String)errors, (String)"\u8bf7\u6c42\u7684Action\u5730\u5740\u672a\u5b9a\u4e49"));
        JSONObject array = JSONObject.fromObject((Object)rmsg);
        this.log.info(array.toString());
        this.outputJson(array.toString(), response, request.getParameter("callback"));
    }

    protected void outputJson(String json, HttpServletResponse response, String callback) throws IOException {
        if (StrUtil.isNotNull((String)json)) {
            PrintWriter out = response.getWriter();
            if (StrUtil.isNull((String)callback)) {
                response.setContentType("text/html;charset=UTF-8");
                response.setHeader("Access-Control-Allow-Origin", "*");
                response.setHeader("Access-Control-Allow-Methods", "POST,GET");
                response.setHeader("Access-Control-Allow-Credentials", "true");
                out.print(json);
            } else {
                response.setContentType("application/javascript");
                out.print(callback + "(" + json + ")");
            }
            out.flush();
            out.close();
        }
    }

    protected Method doInvoke(Class queryclass, HttpServletRequest request, HttpServletResponse response, String methodType, String doCode) throws NullPointerException, SecurityException {
        Method[] methods = queryclass.getMethods();
        Method method = null;
        String methodName = methodType + doCode;
        if (methods != null) {
            int count = methods.length;
            for (int i = 0; i < count; ++i) {
                RequestMapping rm;
                String val;
                if (!methods[i].isAnnotationPresent(RequestMapping.class) || !(val = (rm = methods[i].getAnnotation(RequestMapping.class)).value()[0]).equals(methodName)) continue;
                method = methods[i];
                break;
            }
        }
        return method;
    }

    protected void getListData(ResultEntity entity, Map<String, Object> data) {
        data.put("flag", "T");
        if (null == entity.getEntity()) {
            data.put("flag", "F");
            data.put("msg", entity.getMessage());
        } else if (entity.getEntity() instanceof Page) {
            Page page = (Page)entity.getEntity();
            data.put("total", page.getCount());
            data.put("rows", page.getPageObjects());
        } else if (entity.getEntity() instanceof List) {
            List list = (List)entity.getEntity();
            data.put("total", list.size());
            data.put("rows", list);
            data.put("msg", StrUtil.doNull((String)entity.getMessage(), (String)entity.getResult()));
        } else if (entity.getEntity() instanceof JSONArray) {
            JSONArray list = (JSONArray)entity.getEntity();
            data.put("total", list.size());
            data.put("rows", list);
            data.put("msg", StrUtil.doNull((String)entity.getMessage(), (String)entity.getResult()));
        } else if (entity.getEntity() instanceof Map) {
            Map map = (Map)entity.getEntity();
            if (map.containsKey("pageObjects")) {
                data.put("total", map.get("count"));
                data.put("rows", map.get("pageObjects"));
            } else {
                if (map.isEmpty()) {
                    data.put("rows", new ArrayList());
                } else {
                    data.put("rows", entity.getEntity());
                }
                data.put("total", "0");
            }
        } else if (entity.getEntity() instanceof String && "F".equals(String.valueOf(entity.getEntity()))) {
            ArrayList list = new ArrayList(0);
            data.put("total", "0");
            data.put("rows", list);
            data.put("flag", "F");
            data.put("msg", entity.getMessage());
        } else {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(entity.getEntity());
            data.put("total", "1");
            data.put("rows", list);
        }
    }

    protected Map<String, Object> getResultEntityData(ResultEntity entity) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (entity == null) {
            result.put("flag", "F");
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25");
        } else {
            if ("\u67e5\u8be2\u6210\u529f".equals(entity.getResult()) || "true".equals(entity.getResult()) && !"F".equals(String.valueOf(entity.getEntity())) || "T".equals(entity.getResult())) {
                result.put("flag", "T");
            } else {
                result.put("flag", "F");
            }
            result.put("msg", StrUtil.doNull((String)(StrUtil.isNull((String)entity.getMessage()) ? "" : entity.getMessage()), (String)entity.getResult()));
            if (entity.getEntity() instanceof Page) {
                result.put("flag", "T");
                Page page = (Page)entity.getEntity();
                result.put("total", page.getCount());
                result.put("rows", page.getPageObjects());
            } else if (entity.getEntity() instanceof List) {
                List list = (List)entity.getEntity();
                result.put("flag", "T");
                result.put("total", list.size());
                result.put("rows", list);
            } else if (entity.getEntity() instanceof JSONArray) {
                JSONArray list = (JSONArray)entity.getEntity();
                result.put("total", list.size());
                result.put("rows", list);
                result.put("msg", StrUtil.doNull((String)entity.getMessage(), (String)entity.getResult()));
            } else if (entity.getEntity() instanceof DataMap) {
                result.put("flag", "T");
                result.put("result", entity.getEntity());
            } else if (entity.getEntity() instanceof HashMap) {
                result.put("flag", "T");
                result.put("ids", entity.getEntity());
                result.put("result", entity.getEntity());
            } else if (entity.getEntity() instanceof ResultEntity) {
                result.put("flag", "T");
                result.put("result", ((ResultEntity)entity.getEntity()).getEntity());
            } else {
                result.put("result", entity.getEntity());
            }
        }
        this.log.info("getResultEntityData->" + ((Object)result).toString());
        return result;
    }

    protected Map<String, String> getParameterMap(HttpServletRequest request) throws IOException {
        Map<String, String> map = new HashMap();
        if (request.getAttribute("requestParams") != null) {
            return (Map)request.getAttribute("requestParams");
        }
        if (request.getAttribute("defaultParams") != null) {
            map = (Map)request.getAttribute("defaultParams");
        }
        String ifBatch = StrUtil.doNull((String)request.getParameter("ifBatch"), (String)"F");
        BodyReaderHttpServletRequestWrapper req = new BodyReaderHttpServletRequestWrapper(request);
        String messages = IOUtils.toString((InputStream)req.getInputStream(), (String)"UTF-8");
        if (StrUtil.isNotNull((String)messages) && (messages.startsWith("{") || messages.startsWith("[{"))) {
            return this.json2Map((HttpServletRequest)req, messages);
        }
        String reqIp = RequestTools.getIp((HttpServletRequest)request);
        map.put("Client-IP", reqIp);
        map.put("sysPass", ConfigUtil.getInstance().interfacePass());
        Set keSet = req.getParameterMap().entrySet();
        Map<Object, Object> batchObjMap = new HashMap();
        if ("T".equals(ifBatch)) {
            batchObjMap = this.getChildBatachObjName(keSet);
        }
        for (Map.Entry me : keSet) {
            String ok = String.valueOf(me.getKey());
            if ("ifBatch".equalsIgnoreCase(ok)) continue;
            Object ov = me.getValue();
            String value = "";
            if (ov instanceof String[]) {
                String[] vls = (String[])ov;
                if ("F".equalsIgnoreCase(ifBatch)) {
                    value = vls[0];
                } else {
                    for (int i = 0; i < vls.length; ++i) {
                        if (i == vls.length - 1) {
                            String fieldObjname;
                            value = value + StrUtil.doNull((String)vls[i], (String)"_");
                            if (ok.indexOf(46) <= -1 || batchObjMap.containsKey(fieldObjname = ok.split("\\.")[0])) continue;
                            value = vls[i];
                            continue;
                        }
                        value = value + StrUtil.doNull((String)vls[i], (String)"_") + "-#-";
                    }
                }
            } else {
                value = String.valueOf(ov);
            }
            this.log.info(ok + "->" + value);
            if (StrUtil.isNotNull((String)value)) {
                String str = new String(value.getBytes("iso8859-1"), "iso8859-1");
                if (value.equals(str)) {
                    value = str;
                }
                map.put(ok, value);
                continue;
            }
            if (ok.indexOf("s_") == -1) continue;
            map.put(ok, "is null");
        }
        this.log.info("request getParameterMap after--> " + map);
        return map;
    }

    protected Map<String, String> json2Map(HttpServletRequest request, String jsonStr) throws IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String reqIp = RequestTools.getIp((HttpServletRequest)request);
        paramMap.put("Client-IP", reqIp);
        paramMap.put("sysPass", ConfigUtil.getInstance().interfacePass());
        com.alibaba.fastjson.JSONObject json = JSON.parseObject((String)jsonStr);
        Set keSet = json.entrySet();
        for (Map.Entry me : keSet) {
            String key = String.valueOf(me.getKey());
            Object ov = me.getValue();
            String value = "";
            if (ov instanceof List) {
                List list = (List)ov;
                for (int i = 0; i < list.size(); ++i) {
                    Map objMap = (Map)list.get(i);
                    Set keSet2 = objMap.entrySet();
                    for (Map.Entry me2 : keSet2) {
                        String key2 = String.valueOf(me2.getKey());
                        Object value2 = me2.getValue();
                        String keys = key + "." + key2;
                        String values = "";
                        if (paramMap.containsKey(keys)) {
                            values = (String)paramMap.get(keys) + "-#-";
                        }
                        values = values + String.valueOf(value2);
                        paramMap.put(keys, values);
                    }
                }
                continue;
            }
            if (ov instanceof Map) {
                Map reqMap = (Map)ov;
                Set set2 = reqMap.entrySet();
                for (Map.Entry me2 : set2) {
                    String key2 = String.valueOf(me2.getKey());
                    Object value2 = me2.getValue();
                    String keys = key + "." + key2;
                    String values = String.valueOf(value2);
                    paramMap.put(keys, values);
                }
                continue;
            }
            value = String.valueOf(ov);
            if (StrUtil.isNotNull((String)value)) {
                String str = new String(value.getBytes("iso8859-1"), "iso8859-1");
                if (value.equals(str)) {
                    value = str;
                }
                paramMap.put(key, value);
                continue;
            }
            if (key.indexOf("s_") == -1) continue;
            paramMap.put(key, "is null");
        }
        return paramMap;
    }

    private Map<String, String> getChildBatachObjName(Set keSet) {
        Iterator itr11 = keSet.iterator();
        HashMap<String, String> batchObjMap = new HashMap<String, String>();
        while (itr11.hasNext()) {
            Map.Entry me = (Map.Entry)itr11.next();
            String keys = String.valueOf(me.getKey());
            if (!keys.endsWith(".splitAttr")) continue;
            String objName = keys.split(".splitAttr")[0];
            batchObjMap.put(objName, keys);
        }
        this.log.info("splitAttr.objName->" + batchObjMap);
        return batchObjMap;
    }

    public void setIusService(ApiService iusService) {
        this.iusService = iusService;
    }

    protected ResultEntity doIusService(ParamsVo vo) {
        String modelTypes;
        String dataSource = vo.getParamsToStr("datasource");
        if (StrUtil.isNull((String)defService)) {
            defService = this.getBeanId(DynamicDataSource.getInstance().getDefaultDataSourceKey());
        }
        if (StrUtil.isNotNull((String)(modelTypes = vo.getParamsToStr("modelTypes"))) && modelTypes.indexOf("_uctLog") > -1) {
            return LoadRpcService.service().doService("auditService", vo.getMethodKey(), "json", vo.getParams(), null);
        }
        String beanId = this.getBeanId(dataSource);
        if (!defService.equals(beanId) && StrUtil.isNotNull((String)dataSource)) {
            return LoadRpcService.service().doService(beanId, vo.getMethodKey(), "xml", vo.getParams(), null);
        }
        if (null == this.iusService) {
            Object obj = SpringContextLoader.getBean((String)defService);
            if (obj == null) {
                return LoadRpcService.service().doService("iusService", vo.getMethodKey(), "xml", vo.getParams(), null);
            }
            this.iusService = (ApiService)obj;
        }
        return this.iusService.doService(vo);
    }

    protected Map getDefaultDataMap(HttpServletRequest request) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        LoginUser loginUser = PBOSSOTools.getLoginUser((HttpServletRequest)request);
        HashMap mapConfig = new HashMap();
        Map cfMap = ConfigUtil.getInstance().getLocalByKey("config.properties");
        if (cfMap != null) {
            mapConfig.putAll(cfMap);
        }
        parmMap.put("config", mapConfig);
        parmMap.put("loginUser", loginUser);
        parmMap.put("ctx", request.getContextPath());
        parmMap.put("formToken", UUID.randomUUID().toString());
        return parmMap;
    }

    protected String getBeanId(String datasourceName) {
        String beanId = "iusService";
        if (StrUtil.isNotNull((String)datasourceName)) {
            if ("cms".equals(datasourceName)) {
                beanId = "websiteService";
            } else {
                beanId = datasourceName + "Service";
                if (!this.isExites(beanId)) {
                    beanId = "iusService";
                }
            }
        }
        return beanId;
    }

    private boolean isExites(String beanId) {
        if (StrUtil.isNull((String)beanId)) {
            return false;
        }
        String cacheKey = "interfaceRegister_" + beanId;
        return LoadCacheFactory.getInstance().getCacheManager("").checkCacheObject(cacheKey);
    }
}

