/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.common.connectors.impl;

import com.apache.api.api.ApiService;
import com.apache.api.vo.ParamsVo;
import com.apache.api.vo.ResultEntity;
import com.apache.api.vo.ResultMsg;
import com.apache.cache.service.impl.LoadCacheFactory;
import com.apache.cache.service.impl.redis.JedisSsoUtil;
import com.apache.cache.service.impl.redis.RedisCoreFactory;
import com.apache.cache.util.Validator;
import com.apache.client.UctProtoclClient;
import com.apache.database.constant.SpringContextLoader;
import com.apache.database.constant.SystemTools;
import com.apache.exception.BusinessException;
import com.apache.ius.able.CacheHelper;
import com.apache.ius.common.CommonUtils;
import com.apache.ius.common.InterfaceCallUtils;
import com.apache.ius.common.annotion.AnntationBean;
import com.apache.ius.common.annotion.BeanFactory;
import com.apache.ius.common.connectors.BeforlerInterceptorAdapter;
import com.apache.ius.plugin.InitCacheDataUtil;
import com.apache.ius.plugin.IusPluginUtil;
import com.apache.oscache.BaseOsCache;
import com.apache.oscache.OsCacheOtherManager;
import com.apache.passport.common.PassportHelper;
import com.apache.rpc.common.LoadRpcService;
import com.apache.rpc.entity.InterfaceRegister;
import com.apache.rpc.entity.RpcDatasource;
import com.apache.tools.DataMap;
import com.apache.tools.StrUtil;
import com.apache.uct.common.LoginUser;
import com.apache.uct.common.ToolsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@AnntationBean(name="cacheReqParam")
public class CacheReqParamAdapterImpl
extends BeforlerInterceptorAdapter {
    private ApiService infoService;

    @Override
    public boolean beforPreHandle(HttpServletRequest request, HttpServletResponse response, ParamsVo param) {
        Map resultMap = param.getParams();
        param.setParams("ParamType", (Object)"json");
        String modelTypes = String.valueOf(resultMap.get("modelTypes"));
        String pageName = StrUtil.doNull((String)request.getParameter("pageName"), (String)param.getParamsToStr("pageName"));
        String formName = StrUtil.doNull((String)request.getParameter("formName"), (String)param.getParamsToStr("formName"));
        String key = formName + "_" + pageName;
        Map iusMap = (Map)CacheHelper.getInstance().getIusParamCache(key);
        if (ToolsUtil.isEmpty((Object)iusMap)) {
            throw new BusinessException("\u672a\u68c0\u6d4b\u5230\u76f8\u5e94\u7684\u53c2\u6570\u8bbe\u7f6e\uff0c\u4ee3\u7801\u53f7\uff1a\u3010" + pageName + ":" + formName + "\u3011");
        }
        switch (modelTypes = StrUtil.doNull((String)modelTypes, (String)String.valueOf(iusMap.get("modelTypes")))) {
            case "s_cacheData": {
                this.viewCache(param);
                break;
            }
            case "i_cacheData": {
                this.initCache(param, iusMap);
                break;
            }
            case "i_iusUserAct": {
                this.authorizeAct(request, param);
                break;
            }
            case "s_iusUserAct": {
                Object actObj = InterfaceCallUtils.getInstance().userActsAction(param.getParams(), BeanFactory.getInstance().getLoginUser(request));
                param.setParams("sys-cache-data", actObj);
                break;
            }
            case "s_iusSortInfo": 
            case "i_iusSortInfo": {
                param.setParams("sys-cache-data", InterfaceCallUtils.getInstance().databaseInvoke(param.getParams(), "infoService", "sortInfoAction"));
                break;
            }
            case "i_iusMetadata": {
                param.setParams("sys-cache-data", InterfaceCallUtils.getInstance().databaseInvoke(param.getParams(), "infoService", "metadataAction"));
                break;
            }
            case "s_iusSmsCode": {
                param.setParams("sys-cache-data", InterfaceCallUtils.getInstance().sendSmsCode(param.getParams()));
                break;
            }
            case "s_iusSsoCache": {
                String tokenId = PassportHelper.getInstance().getTokenId(request);
                param.setParams("sys-cache-data", InterfaceCallUtils.getInstance().sendSSOMsg(param.getParams(), tokenId));
                break;
            }
            case "i_iusTaskTimer": 
            case "u_iusTaskTimer": 
            case "d_iusTaskTimer": 
            case "s_iusTaskTimer": {
                param.setParams("sys-cache-data", InterfaceCallUtils.getInstance().taskInvoke(param.getParams(), modelTypes));
                break;
            }
            case "s_importData": {
                this.selectMetadatas(resultMap, param);
            }
        }
        return true;
    }

    private void viewCache(ParamsVo param) {
        String cacheSpaceName = StrUtil.doNull((String)param.getParamsToStr("cacheSpaceName"), (String)"");
        String cachekey = param.getParamsToStr("cachekey");
        HashMap<String, String> returnData = new HashMap<String, String>();
        if (Validator.isNull((String)cachekey)) {
            returnData.put("flag", "F");
            returnData.put("msg", "\u7f3a\u5c11\u7f13\u5b58\u53c2\u6570");
        } else {
            Object obj = LoadCacheFactory.getInstance().getCacheManager(cacheSpaceName).getCacheObjectByKey(cachekey);
            String resultStr = "\u6682\u65e0\u6570\u636e";
            if (obj != null) {
                resultStr = obj instanceof String ? obj.toString() : (obj instanceof List ? JSONArray.fromObject((Object)obj).toString() : JSONObject.fromObject((Object)obj).toString());
            }
            this.log.info("view cache->" + resultStr);
            returnData.put("flag", "T");
            returnData.put("msg", resultStr);
        }
        param.setParams("sys-cache-data", returnData);
    }

    private void initCache(ParamsVo param, Map iusMap) {
        String objName = param.getParamsToStr("objName");
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("flag", "F");
        if (StrUtil.isNull((String)objName)) {
            String relation = String.valueOf(iusMap.get("relation"));
            String dataPageName = "";
            String dataFormName = "";
            if (StrUtil.isNotNull((String)relation)) {
                String[] str = relation.split(",");
                for (int i = 0; i < str.length; ++i) {
                    String[] ps = str[i].split("=");
                    if ("pageName".equalsIgnoreCase(ps[0])) {
                        dataPageName = ps[1];
                        continue;
                    }
                    if (!"formName".equalsIgnoreCase(ps[0])) continue;
                    dataFormName = ps[1];
                }
            }
            String cache_key = dataFormName + "_" + dataPageName;
            Object cache_result = LoadCacheFactory.getInstance().getCacheManager("iusparamcache").getCacheObjectByKey(cache_key);
            Map dMap = (Map)cache_result;
            String searchObjName = String.valueOf(dMap.get("modelTypes"));
            searchObjName = searchObjName.replaceAll("tInterfaceRegister", "sysInterfaceRegister").replaceAll("tRpcDatasource", "sysRpcDatasource").replaceAll("tSystemConfig", "sysSystemConfig");
            objName = searchObjName.split(",")[0].split("_")[1];
        }
        String datasource = String.valueOf(iusMap.get("sysName"));
        String sysEname = StrUtil.doNull((String)CommonUtils.getSysEname(), (String)datasource);
        String tableObjName = objName;
        if (tableObjName.endsWith("sortInfo")) {
            sysEname = param.getParamsToStr("sortInfo.w_sysName");
            ParamsVo psvo = new ParamsVo();
            psvo.setMethodKey("metadataAction");
            psvo.setParams("method", (Object)"initCache");
            psvo.setParams("sysPass", (Object)param.getParamsToStr("sysPass"));
            psvo.setParams("sysName", (Object)sysEname);
            this.log.info("\u7cfb\u7edf[" + sysEname + "]\u4e0b\u6240\u6709[\u6570\u636e\u8868\u4fe1\u606f]\u5230\u7f13\u5b58\u4e2d...start !");
            this.getIusService(psvo);
        } else {
            HashMap<String, Object> whereMap = new HashMap<String, Object>();
            whereMap.putAll(param.getParams());
            whereMap.remove("page");
            whereMap.remove("row");
            whereMap.remove("pageName");
            whereMap.remove("formName");
            whereMap.remove("sysPass");
            whereMap.remove("Client-IP");
            whereMap.remove("objName");
            String searchObjName = "s_" + objName;
            ResultEntity resultEntity = IusPluginUtil.getInstance().select(datasource, "list", searchObjName, whereMap);
            if (Validator.isEmpty((Object)resultEntity.getEntity())) {
                returnData.put("msg", "\u672a\u627e\u5230\u63a5\u53e3\u6570\u636e\uff1a" + whereMap);
                param.setParams("sys-cache-data", returnData);
                return;
            }
            List dataList = (List)resultEntity.getEntity();
            if (tableObjName.endsWith("InterfaceRegister")) {
                String beanId = StrUtil.doNull((String)param.getParamsToStr(objName + ".w_beanId"), (String)param.getParamsToStr(objName + ".wi_beanId"));
                String cache_spaceName = "apachecache";
                this.log.info("\u7cfb\u7edf[" + beanId + "]\u4e0b\u6240\u6709[RPC\u63a5\u53e3]\u7f13\u5b58\u52a0\u8f7d...start !");
                if (StrUtil.isNull((String)beanId)) {
                    returnData.put("msg", "beanId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    param.setParams("sys-cache-data", returnData);
                    return;
                }
                String[] beanIdArray = new String[]{beanId};
                if (beanId.indexOf(",") > 0) {
                    beanIdArray = beanId.split(",");
                }
                for (String k : beanIdArray) {
                    this.initInterface(k, dataList, cache_spaceName);
                }
            } else if (tableObjName.endsWith("RpcDatasource")) {
                String cache_spaceName = "apachecache";
                sysEname = param.getParamsToStr(objName + ".w_sysEname");
                this.log.info("\u7cfb\u7edf[" + sysEname + "]\u4e0b\u6240\u6709[\u6570\u636e\u6e90\u63a5\u53e3]\u7f13\u5b58\u52a0\u8f7d...start !");
                if (StrUtil.isNull((String)sysEname)) {
                    this.log.error("initDataSource.\u7f3a\u5c11\u53c2\u6570\uff1asysRpcDatasource.w_sysEname");
                } else {
                    this.initDataSource(sysEname, dataList, cache_spaceName);
                }
            } else if ("sysParamManager".equals(tableObjName)) {
                this.log.info("\u7cfb\u7edf[" + sysEname + "]\u4e0b\u6240\u6709[IUS\u63a5\u53e3\u53c2\u6570]\u7f13\u5b58\u52a0\u8f7d...start !");
                this.initIusParams(dataList);
            } else if ("sysPluginGroup".equals(tableObjName)) {
                this.log.info("\u7cfb\u7edf[" + sysEname + "]\u4e0b\u6240\u6709[\u63d2\u4ef6\u7ec4\u5408]\u7f13\u5b58\u52a0\u8f7d...start !");
                this.initSysPluginGroup(dataList);
            } else if ("sysPluginManager".equals(tableObjName)) {
                this.log.info("\u7cfb\u7edf[" + sysEname + "]\u4e0b\u6240\u6709[\u63d2\u4ef6\u5b9a\u4e49]\u7f13\u5b58\u52a0\u8f7d...start !");
                this.initSysPluginManager(dataList);
            } else if ("sysVersion".equals(tableObjName)) {
                this.log.info("\u7cfb\u7edf[" + sysEname + "]\u4e0b\u6240\u6709[\u63a5\u53e3\u7248\u672c]\u7f13\u5b58\u52a0\u8f7d...start !");
                this.initVersion(dataList);
            } else {
                String sysNameParamName = tableObjName + ".w_sysName";
                if (param.getParams().containsKey(sysNameParamName)) {
                    sysEname = param.getParamsToStr(sysNameParamName);
                } else {
                    if (StrUtil.isNull((String)sysEname) && param.getParams().containsKey(tableObjName + ".sysName")) {
                        sysEname = param.getParamsToStr(tableObjName + ".sysName");
                    }
                    if (StrUtil.isNull((String)sysEname) && param.getParams().containsKey("sysName")) {
                        sysEname = param.getParamsToStr("sysName");
                    }
                    sysEname = "";
                }
                try {
                    InitCacheDataUtil.getInstance().initDataToCacheOther(sysEname, tableObjName, dataList, param.getParams());
                }
                catch (BusinessException be) {
                    returnData.put("flag", "F");
                    returnData.put("msg", be.getMessage());
                    param.setParams("sys-cache-data", returnData);
                    return;
                }
            }
        }
        returnData.put("flag", "T");
        returnData.put("msg", "\u7f13\u5b58\u66f4\u65b0\u6210\u529f");
        param.setParams("sys-cache-data", returnData);
    }

    private void authorizeAct(HttpServletRequest request, ParamsVo param) {
        ResultEntity entity;
        ResultMsg msg = new ResultMsg("F", "\u64cd\u4f5c\u5931\u8d25");
        String method = StrUtil.doNull((String)param.getParamsToStr("methodCall"), (String)"authorizeAct");
        param.setParams("method", (Object)method);
        param.delParamsByKey("methodCall");
        param.delParamsByKey("pageName");
        param.delParamsByKey("formName");
        LoginUser loginUser = BeanFactory.getInstance().getLoginUser(request);
        if ("roleToUser".equalsIgnoreCase(method)) {
            param.setParams("sysFlag", (Object)loginUser.getSysFlag());
        }
        if (loginUser != null) {
            param.setParams("createUser", (Object)loginUser.getUserEname());
        }
        if ("true".equalsIgnoreCase(String.valueOf((entity = UctProtoclClient.getInstance().doService("uctService", "userActsAction", param.getParams())).getEntity()))) {
            msg = new ResultMsg("T", "\u64cd\u4f5c\u6210\u529f");
            if ("true".equalsIgnoreCase(String.valueOf(param.getParamsToStr("ifIus")))) {
                msg = new ResultMsg("T", "\u64cd\u4f5c\u6210\u529f");
                String objType = param.getParamsToStr("objType");
                String iusId = StrUtil.doNull((String)param.getParamsToStr("uctActIus.iusId"), (String)param.getParamsToStr("uctActIus.w_iusId"));
                if (StrUtil.isNotNull((String)objType) && StrUtil.isNotNull((String)iusId)) {
                    String cacheKey = "act_ius_" + iusId;
                    BaseOsCache oscache = OsCacheOtherManager.getInstance().getBaseOsCache("ius_port", 600);
                    oscache.remove(cacheKey);
                    JedisSsoUtil.getInstance().delCacheNameForValue("act_ius_ports", cacheKey);
                }
            }
        } else {
            msg.setMsg(entity.getMessage());
        }
        param.setParams("sys-cache-data", (Object)msg);
    }

    private ResultEntity getIusService(ParamsVo vo) {
        Object obj;
        if (null == this.infoService && (obj = SpringContextLoader.getBean((String)"infoService")) != null) {
            this.infoService = (ApiService)obj;
        }
        if (null == this.infoService) {
            return LoadRpcService.service().doService("infoService", vo.getMethodKey(), "xml", vo.getParams(), null);
        }
        return this.infoService.doService(vo);
    }

    private void initIusParams(List dataList) {
        if (Validator.isEmpty((List)dataList)) {
            return;
        }
        if (!ToolsUtil.isEmpty((List)dataList)) {
            int count = dataList.size();
            for (int i = 0; i < dataList.size(); ++i) {
                Map map = (Map)dataList.get(i);
                String key = map.get("formName") + "_" + map.get("pageName");
                CacheHelper.getInstance().setIusParamCache(key, map);
            }
            this.log.info("\u521d\u59cb\u5316[IUS\u63a5\u53e3\u53c2\u6570][" + count + "]\u6761\u6570\u636e\u5230\u7f13\u5b58\u5b8c\u6210\uff01");
        }
    }

    private void initInterface(String beanId, List<DataMap> dataList, String cache_spaceName) {
        String cache_key = "interfaceRegister_" + beanId;
        this.log.info("\u63a5\u53e3\u6ce8\u518c\u4fe1\u606f\u52a0\u8f7dstart->" + cache_key);
        if (dataList.size() > 0) {
            ArrayList<InterfaceRegister> vos = (ArrayList<InterfaceRegister>)SystemTools.getInstance().getCache(cache_spaceName).getCacheObjectByKey(cache_key);
            if (Validator.isEmpty((List)vos)) {
                vos = new ArrayList<InterfaceRegister>();
            }
            for (int i = 0; i < dataList.size(); ++i) {
                Map dmObj = (Map)dataList.get(i);
                InterfaceRegister register = new InterfaceRegister();
                register.setRegisterId(String.valueOf(dmObj.get("registerId")));
                String data_beanId = String.valueOf(dmObj.get("beanId"));
                if (!data_beanId.equals(beanId)) continue;
                register.setBeanId(data_beanId);
                register.setBeanName(String.valueOf(dmObj.get("beanName")));
                register.setAddress(String.valueOf(dmObj.get("address")));
                register.setPort(String.valueOf(dmObj.get("port")));
                register.setMethodName(String.valueOf(dmObj.get("methodName")));
                register.setCallType(String.valueOf(dmObj.get("callType")));
                register.setFlag(String.valueOf(dmObj.get("flag")));
                register.setReserve1(String.valueOf(dmObj.get("reserve1")));
                register.setReserve2(String.valueOf(dmObj.get("reserve2")));
                register.setTimestampCreate(Long.valueOf(Long.parseLong(String.valueOf(dmObj.get("timestampCreate")))));
                register.setUserIdCreate(String.valueOf(dmObj.get("userIdCreate")));
                Iterator iterator = vos.iterator();
                while (iterator.hasNext()) {
                    InterfaceRegister ifr = (InterfaceRegister)iterator.next();
                    if (!ifr.getRegisterId().equals(register.getRegisterId())) continue;
                    iterator.remove();
                }
                vos.add(register);
                this.log.info(i + 1 + "\uff09\u63a5\u53e3\u6ce8\u518c\u5bf9\u8c61->" + JSONObject.fromObject((Object)register).toString());
            }
            SystemTools.getInstance().getCache(cache_spaceName).createCacheObject(cache_key, vos);
            this.log.info("\u521d\u59cb\u5316[\u63a5\u53e3\u6ce8\u518c\u4fe1\u606f][" + cache_key + "][" + vos.size() + "]\u6761\u6570\u636e\u5230\u7f13\u5b58\u5b8c\u6210\uff01");
        } else {
            SystemTools.getInstance().getCache(cache_spaceName).removeCacheObject(cache_key);
            this.log.info("\u6682\u65e0\u3010\u542f\u7528\u3011\u72b6\u6001\u7684\u63a5\u53e3\uff0c\u6545\u4e0d\u52a0\u8f7d\u7f13\u5b58\uff01");
        }
    }

    private void initDataSource(String sysEname, List<DataMap> dataList, String cache_spaceName) {
        if (dataList.size() > 0) {
            String cache_key = "rpc_datasource_" + sysEname;
            Map dmObj = (Map)dataList.get(0);
            RpcDatasource rds = new RpcDatasource();
            rds.setDataName(String.valueOf(dmObj.get("dataName")));
            rds.setDatabaseType(String.valueOf(dmObj.get("databaseType")));
            rds.setSysEname(String.valueOf(dmObj.get("sysEname")));
            rds.setDriverClassName(String.valueOf(dmObj.get("driverClassName")));
            rds.setJdbcPassword(String.valueOf(dmObj.get("jdbcPassword")));
            rds.setJdbcUrl(String.valueOf(dmObj.get("jdbcUrl")));
            rds.setJdbcUsername(String.valueOf(dmObj.get("jdbcUsername")));
            rds.setDatasource1(String.valueOf(dmObj.get("datasource1")));
            rds.setDatasource2(String.valueOf(dmObj.get("datasource2")));
            SystemTools.getInstance().getCache(cache_spaceName).createCacheObject(cache_key, (Object)rds);
            String cacheKeys = "rpc_datasource_keys";
            String cacheKeys_values = String.valueOf(SystemTools.getInstance().getCache(cache_spaceName).getCacheObjectByKey(cacheKeys));
            cacheKeys_values = Validator.getDefaultStr((String)cacheKeys_values, (String)"");
            if (cacheKeys_values.indexOf(sysEname) == -1) {
                if (!cacheKeys_values.endsWith(",")) {
                    cacheKeys_values = cacheKeys_values + ",";
                }
                cacheKeys_values = cacheKeys_values + sysEname;
                SystemTools.getInstance().getCache(cache_spaceName).createCacheObject(cacheKeys, (Object)cacheKeys_values);
                this.log.info("\u66f4\u65b0[\u6570\u636e\u6e90\u4fe1\u606f][" + cacheKeys + "->" + cacheKeys_values + "]\u5230\u7f13\u5b58");
            }
            this.log.info("\u66f4\u65b0[\u6570\u636e\u6e90\u4fe1\u606f][" + cache_key + "]\u5230\u7f13\u5b58\u5b8c\u6210\uff01");
        }
    }

    private void initSysPluginManager(List dataList) {
        String cache_spaceName = "pluginsCache";
        if (Validator.isEmpty((List)dataList)) {
            return;
        }
        if (!ToolsUtil.isEmpty((List)dataList)) {
            int count = dataList.size();
            for (int i = 0; i < dataList.size(); ++i) {
                Map map = (Map)dataList.get(i);
                String key = "group_" + String.valueOf(map.get("pluginShortName"));
                String value = String.valueOf(map.get("pluginFullName"));
                SystemTools.getInstance().getCache(cache_spaceName).createCacheObject(key, (Object)value);
                this.log.info(i + 1 + ".[" + key + "][" + value + "] " + String.valueOf(map.get("pluginRemark")));
            }
            this.log.info("\u66f4\u65b0[\u63d2\u4ef6][" + count + "]\u6761\u6570\u636e\u5230\u7f13\u5b58\u5b8c\u6210\uff01");
        }
    }

    private void initSysPluginGroup(List dataList) {
        String cache_spaceName = "pluginsCache";
        if (Validator.isEmpty((List)dataList)) {
            return;
        }
        if (!ToolsUtil.isEmpty((List)dataList)) {
            int count = dataList.size();
            for (int i = 0; i < dataList.size(); ++i) {
                Map map = (Map)dataList.get(i);
                String key = "plugin_" + String.valueOf(map.get("rulesCode"));
                String value = String.valueOf(map.get("rulesName"));
                SystemTools.getInstance().getCache(cache_spaceName).createCacheObject(key, (Object)value);
                this.log.info(i + 1 + ".[" + key + "][" + value + "] " + String.valueOf(map.get("rulesRemark")));
            }
            this.log.info("\u66f4\u65b0[\u63d2\u4ef6\u7ec4\u5408][" + count + "]\u6761\u6570\u636e\u5230\u7f13\u5b58\u5b8c\u6210\uff01");
        }
    }

    private void initVersion(List dataList) {
        String cache_spaceName = "versionCache";
        if (Validator.isEmpty((List)dataList)) {
            return;
        }
        if (!ToolsUtil.isEmpty((List)dataList)) {
            RedisCoreFactory.getInstance().getJedis().del(cache_spaceName);
            int count = dataList.size();
            for (int i = 0; i < dataList.size(); ++i) {
                Map map = (Map)dataList.get(i);
                String status = String.valueOf(map.get("status"));
                if ("1".equals(status)) {
                    SystemTools.getInstance().getCache(cache_spaceName).createCacheObject("current_version", (Object)String.valueOf(map.get("versionNo")));
                }
                String key = "version_" + String.valueOf(map.get("versionNo"));
                SystemTools.getInstance().getCache(cache_spaceName).createCacheObject(key, (Object)map);
                this.log.info(i + 1 + ".[" + key + "][" + map + "] ");
            }
            this.log.info("\u66f4\u65b0[\u63d2\u4ef6][" + count + "]\u6761\u6570\u636e\u5230\u7f13\u5b58\u5b8c\u6210\uff01");
        }
    }

    private void selectMetadatas(Map<String, Object> resultMap, ParamsVo param) {
        String key = resultMap.get("targetFormName") + "_" + resultMap.get("targetPageName");
        Map map = (Map)CacheHelper.getInstance().getIusParamCache(key);
        if (ToolsUtil.isEmpty((Object)map)) {
            ResultMsg msg = new ResultMsg("F", "\u672a\u68c0\u6d4b\u5230\u76f8\u5e94\u7684\u53c2\u6570\u8bbe\u7f6e\uff0c\u4ee3\u7801\u53f7\uff1a\u3010" + resultMap.get("targetPageName") + ":" + resultMap.get("targetFormName") + "\u3011");
            param.setParams("sys-cache-data", (Object)msg);
        } else {
            String modelTypes = (String)map.get("modelTypes");
            String[] model = modelTypes.split("_");
            StringBuilder sql = new StringBuilder();
            sql.append("select Concat('" + model[1] + ".',data_attr) data_attr,data_full_name from sys_metadata m ");
            sql.append(" where m.sort_id in(select sort_id from sys_sort_info where obj_name='" + model[1] + "' and sys_name='" + (String)map.get("sysName") + "')");
            List list = (List)IusPluginUtil.getInstance().select("plateform", sql.toString(), 0, 0);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("flag", "T");
            data.put("msg", "\u67e5\u8be2\u6210\u529f");
            data.put("total", list.size());
            data.put("rows", list);
            param.setParams("sys-cache-data", data);
        }
    }
}

