/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.able;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.apache.api.api.ApiService;
import com.apache.api.vo.ParamsVo;
import com.apache.api.vo.ResultEntity;
import com.apache.cache.util.Validator;
import com.apache.client.StringUtil;
import com.apache.database.model.Page;
import com.apache.excp.ExcelExpUtil;
import com.apache.ius.able.CacheHelper;
import com.apache.ius.plugin.IusPluginUtil;
import com.apache.tools.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportDataTask
implements Callable<Integer> {
    private Logger log = LoggerFactory.getLogger(ExportDataTask.class);
    private ParamsVo vo;
    private ApiService iusService;
    private Map<String, Object> resqData;
    private int exportPageSize = 5000;

    public ExportDataTask() {
    }

    public ExportDataTask(ParamsVo vo, ApiService iusService, Map<String, Object> resqData) {
        this.vo = vo;
        this.iusService = iusService;
        this.resqData = resqData;
    }

    public void setParams(ParamsVo vo, ApiService iusService, Map<String, Object> resqData) {
        this.vo = vo;
        this.iusService = iusService;
        this.resqData = resqData;
    }

    @Override
    public Integer call() throws Exception {
        try {
            String filePath = String.valueOf(this.resqData.get("filePath"));
            String fileName = String.valueOf(this.resqData.get("fileName"));
            String fileType = String.valueOf(this.resqData.get("fileType"));
            this.log.info("filePath->" + filePath);
            this.log.info("fileName->" + fileName);
            boolean isxlsx = ".xlsx".equals(fileType);
            long totalRows = 0L;
            if (StrUtil.isNull((String)this.vo.getParamsToStr("exportType"))) {
                totalRows = this.exportByPageNameFormName(filePath, fileName, isxlsx);
            } else {
                Object workbook = null;
                workbook = isxlsx ? ExcelExpUtil.getSXSSFWorkbook((int)100) : ExcelExpUtil.getHSSFWorkbook();
                this.log.info("\u5168\u8868\u6570\u636e\u5bfc\u51fa\uff0c\u5219\u9ed8\u8ba4\u53d6\u6570\u636e\u7ed3\u679c\u96c6\u4e2d\u7b2c1\u6761\u6570\u636e\u7684\u5b57\u6bb5\u540d\u79f0\u4e3a\u8868\u5934\u3002");
                String sql = "select * from " + this.vo.getParamsToStr("tableName");
                String datasource = this.vo.getParamsToStr("sysName");
                this.log.info("\u6570\u636e\u67e5\u8be2sql->" + sql);
                this.log.info("\u6570\u636e\u6e90datasource->" + datasource);
                int j = 1;
                String exportFileName = StrUtil.doNull((String)this.vo.getParamsToStr("fileName"), (String)this.vo.getParamsToStr("exportFileName"));
                this.log.info("sheetName->" + exportFileName);
                boolean mark = true;
                do {
                    int rowNum = (j - 1) * this.exportPageSize;
                    Page page = (Page)IusPluginUtil.getInstance().select(datasource, sql, j, this.exportPageSize);
                    totalRows = page.getCount();
                    if (StrUtil.isEmpty((List)page.getPageObjects())) {
                        this.log.info("\u67e5\u8be2\u7ed3\u679c\u65e0\u6570\u636e\uff0c\u6682\u4e0d\u8fdb\u884c\u5bfc\u51fa\u5904\u7406\uff01");
                        this.resqData.put("ex_msg", "\u67e5\u8be2\u7ed3\u679c\u65e0\u6570\u636e\uff0c\u6682\u4e0d\u8fdb\u884c\u5bfc\u51fa\u5904\u7406\uff01");
                        mark = false;
                        continue;
                    }
                    this.log.info(j + ").\u67e5\u8be2\u51fa\u6570\u636e[" + page.getPageObjects().size() + "]\u6761\u3002");
                    if (j >= page.getPageCount()) {
                        mark = false;
                    } else {
                        ++j;
                    }
                    if (rowNum > 0) {
                        ++rowNum;
                    }
                    ExcelExpUtil.doInvoke((Workbook)workbook, (String)exportFileName, null, (List)page.getPageObjects(), (int)rowNum);
                    page = null;
                } while (mark);
                if (null != workbook) {
                    ExcelExpUtil.writeXlsx((Workbook)workbook, (String)filePath, (String)fileName);
                }
            }
            if (!this.resqData.containsKey("ex_msg")) {
                this.log.info("\u672c\u6b21\u5171\u8ba1\u5bfc\u51fa\u6570\u636e[" + totalRows + "]\u6761\u3002");
                this.log.info("\u6587\u4ef6\u751f\u6210\u5b8c\u6210\uff1a" + filePath + "/" + fileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.resqData.put("ex_msg", "\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            return 0;
        }
        return 1;
    }

    private long exportByPageNameFormName(String filePath, String fileName, boolean isxlsx) throws Exception {
        boolean mark = true;
        long totalRows = 0L;
        int j = 1;
        this.vo.setParams("rows", (Object)this.exportPageSize);
        List cells = (List)this.resqData.get("data_titles");
        if (StrUtil.isEmpty((List)cells)) {
            this.log.info("\u672a\u914d\u7f6e\u8868\u5934\uff0c\u5219\u9ed8\u8ba4\u53d6\u6570\u636e\u7ed3\u679c\u96c6\u4e2d\u7b2c1\u6761\u6570\u636e\u7684\u5b57\u6bb5\u540d\u79f0\u4e3a\u8868\u5934\u3002");
        } else {
            this.log.info("\u5df2\u914d\u7f6e\u8868\u5934\uff0c\u5171\u8bb0\u914d\u7f6e[" + cells.size() + "]\u4e2a\uff01");
        }
        String exportFileName = StrUtil.doNull((String)this.vo.getParamsToStr("fileName"), (String)this.vo.getParamsToStr("exportFileName"));
        this.log.info("sheetName->" + exportFileName);
        Object workbook = null;
        workbook = isxlsx ? ExcelExpUtil.getSXSSFWorkbook((int)100) : ExcelExpUtil.getHSSFWorkbook();
        do {
            this.vo.setParams("_resultType", (Object)"F");
            this.vo.setParams("page", (Object)j);
            int rowNum = (j - 1) * this.exportPageSize;
            ResultEntity entity = this.iusService.doService(this.vo);
            if (null == entity.getEntity()) {
                mark = false;
                continue;
            }
            List list = new ArrayList();
            if (entity.getEntity() instanceof Page) {
                Page page = (Page)entity.getEntity();
                if (!Validator.isEmpty((List)page.getPageObjects())) {
                    list.addAll(page.getPageObjects());
                    if (j >= page.getPageCount()) {
                        mark = false;
                    } else {
                        ++j;
                    }
                } else {
                    mark = false;
                }
            } else if (entity.getEntity() instanceof List) {
                list = (List)entity.getEntity();
            } else {
                mark = false;
            }
            this.log.info(j + ").\u67e5\u8be2\u51fa\u6570\u636e[" + list.size() + "]\u6761\u3002");
            totalRows += (long)list.size();
            if (!list.isEmpty()) {
                if (rowNum > 0) {
                    ++rowNum;
                }
                ExcelExpUtil.doInvoke((Workbook)workbook, (String)exportFileName, (List)cells, list, (int)rowNum);
                list = null;
                continue;
            }
            this.log.info("\u67e5\u8be2\u7ed3\u679c\u65e0\u6570\u636e\uff0c\u6682\u4e0d\u8fdb\u884c\u5bfc\u51fa\u5904\u7406\uff01");
            this.resqData.put("ex_msg", "\u67e5\u8be2\u7ed3\u679c\u65e0\u6570\u636e\uff0c\u6682\u4e0d\u8fdb\u884c\u5bfc\u51fa\u5904\u7406\uff01");
        } while (mark);
        if (null != workbook) {
            ExcelExpUtil.writeXlsx((Workbook)workbook, (String)filePath, (String)fileName);
        }
        return totalRows;
    }

    public Map<String, Object> exportConfig(String pageName, String fromName) {
        HashMap<String, Object> resqData = new HashMap<String, Object>();
        if (StrUtil.isNull((String)pageName) && StrUtil.isNull((String)fromName)) {
            return resqData;
        }
        String pid = fromName + "_" + pageName;
        List list = (List)IusPluginUtil.getInstance().select("plateform", "select * from sys_export_conf where p_id='" + pid + "' order by order_no,create_time", 0, 0);
        if (!StrUtil.isEmpty((List)list)) {
            ArrayList result = new ArrayList();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                List dictList;
                JSONObject obj;
                Map map = (Map)list.get(i);
                HashMap<String, Object> data = new HashMap<String, Object>();
                if ("3".equals(map.get("attrType"))) {
                    obj = JSON.parseObject((String)((String)map.get("dictCof")));
                    dictList = this.getDictList("", obj);
                    Map<String, String> dictMap = this.getDicts(dictList, obj.getString("val"), obj.getString("text"));
                    data.put("data_dict", dictMap);
                    dictList = null;
                } else if ("2".equals(map.get("attrType"))) {
                    obj = JSON.parseObject((String)((String)map.get("dictCof")));
                    dictList = this.getDictList(obj.getString("dict"), obj);
                    Map<String, String> dictMap = this.getDicts(dictList, "itemValue", "itemText");
                    data.put("data_dict", dictMap);
                    dictList = null;
                }
                map.put("table_name", StringUtil.toCamelNamed((String)((String)map.get("tableName"))));
                data.put("attrName", map);
                String title = (String)map.get("attrTitle");
                switch ((String)map.get("expTitleType")) {
                    case "EN": {
                        title = (String)map.get("attrName");
                        break;
                    }
                    case "FD": {
                        title = (String)map.get("attrField");
                    }
                }
                data.put("title", "T".equals(map.get("ifTitleCap")) ? title.toUpperCase() : title.toLowerCase());
                result.add(data);
            }
            list = null;
            resqData.put("data_titles", result);
        }
        return resqData;
    }

    private Map<String, String> getDicts(List<Map> data, String key, String valName) {
        HashMap<String, String> dictMap = new HashMap<String, String>();
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            Map map = data.get(i);
            dictMap.put((String)map.get(key), (String)map.get(valName));
        }
        return dictMap;
    }

    private List getDictList(String enameCode, JSONObject obj) {
        String sql = null;
        String datasource = "plateform";
        if (StrUtil.isNotNull((String)enameCode)) {
            sql = "select item_value,item_text from sys_data_item where cate_ename='" + enameCode + "'";
        } else {
            Map map = (Map)CacheHelper.getInstance().getIusParamCache(obj.getString("formName") + "_" + obj.getString("pageName"));
            String objName = String.valueOf(map.get("modelTypes")).substring(2);
            String tableName = StringUtil.upperCharToUnderLine((String)objName);
            String colum = StringUtil.upperCharToUnderLine((String)obj.getString("val")) + "," + StringUtil.upperCharToUnderLine((String)obj.getString("text"));
            datasource = String.valueOf(map.get("sysName"));
            sql = "select " + colum + " from " + tableName;
        }
        this.log.info("dict sql->" + sql);
        return (List)IusPluginUtil.getInstance().select(datasource, sql, 0, 0);
    }
}

