/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius;

import com.apache.api.vo.ParamsVo;
import com.apache.cache.util.Validator;
import com.apache.database.datasource.DynamicDataSource;
import com.apache.database.datasource.DynamicDataSourceHolder;
import com.apache.database.db.IDao;
import com.apache.database.model.MethodParam;
import com.apache.ius.CustomMethodFactory;
import com.apache.ius.IusSqlTools;
import com.apache.ius.plugin.CustomMethodPlugin;
import com.apache.ius.plugin.IusSqlPorxyPlugin;
import com.apache.tools.DataMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IusSqlPorxyPluginImpl
implements IusSqlPorxyPlugin {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private IDao iusPubDao;
    private Map<String, String> plugins = new HashMap<String, String>(1);
    private final String plugins_cache_key = "plugin_";

    @Override
    public Object doInvoke(ParamsVo vo) {
        String key = String.valueOf(vo.getParams("sqlKeyId"));
        String methodKey = vo.getMethodKey();
        vo.setMethodKey("");
        if (Validator.isNull((String)methodKey)) {
            return null;
        }
        String str = this.getPlugins(key);
        HashMap resultmap = new HashMap();
        if (Validator.isNotNull((String)str)) {
            String[] strs = str.split(",");
            for (int i = 0; i < strs.length; ++i) {
                CustomMethodPlugin plugin = CustomMethodFactory.getInstance().getPluginByKey(strs[i]);
                if (null == plugin) {
                    return null;
                }
                Map map = null;
                if (Validator.isNotNull((String)methodKey) && "beforMethodKey".equalsIgnoreCase(methodKey)) {
                    map = (Map)plugin.beforeInvoke(vo.getParams());
                } else if (Validator.isNotNull((String)methodKey) && "afterMethodKey".equalsIgnoreCase(methodKey)) {
                    map = (Map)plugin.afterInvoke(vo.getParams());
                } else if (Validator.isNotNull((String)methodKey) && "invokeMethodKey".equalsIgnoreCase(methodKey)) {
                    map = (Map)plugin.doInvoke(vo.getParams());
                }
                if (Validator.isEmpty(map)) continue;
                resultmap.putAll(map);
            }
        }
        return resultmap;
    }

    public void setPlugins(Map<String, String> plugins) {
        this.log.info("\u63d2\u4ef6\u6570\u636e\u52a0\u8f7dstart");
        try {
            if (!IusSqlTools.getInstance().getPluginsCache().checkCacheObject("plugins_open_mark")) {
                if (!DynamicDataSource.getInstance().checkDataSource("plateform")) {
                    DynamicDataSource.getInstance().addDataSource("plateform");
                }
                DynamicDataSourceHolder.putDataSource((String)"plateform");
                MethodParam param = new MethodParam("SysPluginGroup", "", "", "com.apache.ius.sql.DymicMapper");
                List list = this.iusPubDao.select(param);
                if (!Validator.isEmpty((List)list)) {
                    IusSqlTools.getInstance().getPluginsCache().createCacheObject("plugins_open_mark", (Object)"true");
                    HashMap map = new HashMap(list.size());
                    int count = list.size();
                    for (int i = 0; i < count; ++i) {
                        DataMap mp = (DataMap)list.get(i);
                        String cacheKey = "plugin_" + String.valueOf(mp.get("rulesCode"));
                        IusSqlTools.getInstance().getPluginsCache().createCacheObject(cacheKey, (Object)String.valueOf(mp.get("rulesName")));
                    }
                    this.log.info("\u52a0\u8f7d\u4e86[" + count + "]\u6761\u63d2\u4ef6\u7ec4\u5408\u6570\u636e");
                }
            }
            CustomMethodFactory.getInstance().init();
            this.log.info("\u63d2\u4ef6\u6570\u636e\u52a0\u8f7dend");
        }
        catch (Exception e) {
            this.log.error("\u52a0\u8f7d\u63d2\u4ef6\u6570\u636e\u51fa\u9519 ", (Throwable)e);
        }
    }

    @Override
    public void setPluginInfo(String key, String value) {
        String cacheKey = "plugin_" + key;
        IusSqlTools.getInstance().getPluginsCache().removeCacheObject(cacheKey);
        if (Validator.isNotNull((String)value)) {
            IusSqlTools.getInstance().getPluginsCache().createCacheObject(cacheKey, (Object)value);
        }
    }

    private String getPlugins(String key) {
        String cacheKey = "plugin_" + key;
        String value = String.valueOf(IusSqlTools.getInstance().getPluginsCache().getCacheObjectByKey(cacheKey));
        return value;
    }

    public void setIusPubDao(IDao iusPubDao) {
        this.iusPubDao = iusPubDao;
    }
}

