/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.util;

import java.util.List;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysPermission;

public class PermissionDataUtil {
    public static SysPermission intelligentProcessData(SysPermission permission) {
        if (permission == null) {
            return null;
        }
        if (oConvertUtils.isNotEmpty(permission.getComponent())) {
            String component = permission.getComponent();
            if (component.startsWith("/")) {
                component = component.substring(1);
            }
            if (component.startsWith("views/")) {
                component = component.replaceFirst("views/", "");
            }
            if (component.startsWith("src/views/")) {
                component = component.replaceFirst("src/views/", "");
            }
            if (component.endsWith(".vue")) {
                component = component.replace(".vue", "");
            }
            permission.setComponent(component);
        }
        if (oConvertUtils.isNotEmpty(permission.getUrl())) {
            String url = permission.getUrl();
            if (url.endsWith(".vue")) {
                url = url.replace(".vue", "");
            }
            if (!(url.startsWith("http") || url.startsWith("/") || url.trim().startsWith("{{"))) {
                url = "/" + url;
            }
            permission.setUrl(url);
        }
        if (0 == permission.getMenuType() && oConvertUtils.isEmpty(permission.getComponent())) {
            permission.setComponent("layouts/RouteView");
        }
        return permission;
    }

    public static void addIndexPage(List<SysPermission> metaList) {
        boolean hasIndexMenu = false;
        for (SysPermission sysPermission : metaList) {
            if (!"\u9996\u9875".equals(sysPermission.getName())) continue;
            hasIndexMenu = true;
            break;
        }
        if (!hasIndexMenu) {
            metaList.add(0, new SysPermission(true));
        }
    }

    public static boolean hasIndexPage(List<SysPermission> metaList) {
        boolean hasIndexMenu = false;
        for (SysPermission sysPermission : metaList) {
            if (!"\u9996\u9875".equals(sysPermission.getName())) continue;
            hasIndexMenu = true;
            break;
        }
        return hasIndexMenu;
    }
}

