/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.mapper.SysUserDepartMapper;
import org.jeecg.modules.system.model.DepartIdModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysUserDepartService;
import org.jeecg.modules.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserDepartServiceImpl
extends ServiceImpl<SysUserDepartMapper, SysUserDepart>
implements ISysUserDepartService {
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private ISysUserService sysUserService;

    @Override
    public List<DepartIdModel> queryDepartIdsOfUser(String userId) {
        LambdaQueryWrapper queryUDep = new LambdaQueryWrapper();
        LambdaQueryWrapper queryDep = new LambdaQueryWrapper();
        try {
            queryUDep.eq(SysUserDepart::getUserId, (Object)userId);
            ArrayList<String> depIdList = new ArrayList<String>();
            ArrayList<DepartIdModel> depIdModelList = new ArrayList<DepartIdModel>();
            List userDepList = this.list((Wrapper)queryUDep);
            if (userDepList != null && userDepList.size() > 0) {
                for (SysUserDepart userDepart : userDepList) {
                    depIdList.add(userDepart.getDepId());
                }
                queryDep.in(SysDepart::getId, depIdList);
                List depList = this.sysDepartService.list((Wrapper)queryDep);
                if (depList != null || depList.size() > 0) {
                    for (SysDepart depart : depList) {
                        depIdModelList.add(new DepartIdModel().convertByUserDepart(depart));
                    }
                }
                return depIdModelList;
            }
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        return null;
    }

    @Override
    public List<SysUser> queryUserByDepId(String depId) {
        LambdaQueryWrapper queryUDep = new LambdaQueryWrapper();
        queryUDep.eq(SysUserDepart::getDepId, (Object)depId);
        ArrayList<String> userIdList = new ArrayList<String>();
        List uDepList = this.list((Wrapper)queryUDep);
        if (uDepList != null && uDepList.size() > 0) {
            for (SysUserDepart uDep : uDepList) {
                userIdList.add(uDep.getUserId());
            }
            List userList = this.sysUserService.listByIds(userIdList);
            for (SysUser sysUser : userList) {
                sysUser.setSalt("");
                sysUser.setPassword("");
            }
            return userList;
        }
        return new ArrayList<SysUser>();
    }

    @Override
    public List<SysUser> queryUserByDepCode(String depCode, String realname) {
        LambdaQueryWrapper queryByDepCode = new LambdaQueryWrapper();
        queryByDepCode.likeRight(SysDepart::getOrgCode, (Object)depCode);
        List sysDepartList = this.sysDepartService.list((Wrapper)queryByDepCode);
        List depIds = sysDepartList.stream().map(SysDepart::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryUDep = new LambdaQueryWrapper();
        queryUDep.in(SysUserDepart::getDepId, depIds);
        ArrayList<String> userIdList = new ArrayList<String>();
        List uDepList = this.list((Wrapper)queryUDep);
        if (uDepList != null && uDepList.size() > 0) {
            for (SysUserDepart uDep : uDepList) {
                userIdList.add(uDep.getUserId());
            }
            LambdaQueryWrapper queryUser = new LambdaQueryWrapper();
            queryUser.in(SysUser::getId, userIdList);
            if (oConvertUtils.isNotEmpty(realname)) {
                queryUser.like(SysUser::getRealname, (Object)realname.trim());
            }
            List userList = this.sysUserService.list((Wrapper)queryUser);
            for (SysUser sysUser : userList) {
                sysUser.setSalt("");
                sysUser.setPassword("");
            }
            return userList;
        }
        return new ArrayList<SysUser>();
    }
}

