/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.PermissionData;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ImportExcelUtil;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysDepartRole;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.entity.SysUserRole;
import org.jeecg.modules.system.model.DepartIdModel;
import org.jeecg.modules.system.model.SysUserSysDepartModel;
import org.jeecg.modules.system.service.ISysDepartRoleService;
import org.jeecg.modules.system.service.ISysDepartRoleUserService;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysUserDepartService;
import org.jeecg.modules.system.service.ISysUserRoleService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.vo.SysDepartUsersVO;
import org.jeecg.modules.system.vo.SysUserRoleVO;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sys/user"})
public class SysUserController {
    private static final Logger log = LoggerFactory.getLogger(SysUserController.class);
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysUserDepartService sysUserDepartService;
    @Autowired
    private ISysUserRoleService userRoleService;
    @Autowired
    private ISysDepartRoleUserService departRoleUserService;
    @Autowired
    private ISysDepartRoleService departRoleService;
    @Autowired
    private RedisUtil redisUtil;
    @Value(value="${jeecg.path.upload}")
    private String upLoadPath;

    @PermissionData(pageComponent="system/UserList")
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<SysUser>> queryPageList(SysUser user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<SysUser>> result = new Result<IPage<SysUser>>();
        QueryWrapper<SysUser> queryWrapper = QueryGenerator.initQueryWrapper(user, req.getParameterMap());
        queryWrapper.ne((Object)"username", (Object)"_reserve_user_external");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysUserService.page((IPage)page, (Wrapper)queryWrapper);
        List<String> userIds = pageList.getRecords().stream().map(SysUser::getId).collect(Collectors.toList());
        if (userIds != null && userIds.size() > 0) {
            Map<String, String> useDepNames = this.sysUserService.getDepNamesByUserIds(userIds);
            pageList.getRecords().forEach(item -> item.setOrgCodeTxt((String)useDepNames.get(item.getId())));
        }
        result.setSuccess(true);
        result.setResult(pageList);
        log.info(pageList.toString());
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<SysUser> add(@RequestBody JSONObject jsonObject) {
        Result<SysUser> result = new Result<SysUser>();
        String selectedRoles = jsonObject.getString("selectedroles");
        String selectedDeparts = jsonObject.getString("selecteddeparts");
        try {
            SysUser user = (SysUser)JSON.parseObject((String)jsonObject.toJSONString(), SysUser.class);
            user.setCreateTime(new Date());
            String salt = oConvertUtils.randomGen(8);
            user.setSalt(salt);
            String passwordEncode = PasswordUtil.encrypt(user.getUsername(), user.getPassword(), salt);
            user.setPassword(passwordEncode);
            user.setStatus(1);
            user.setDelFlag(CommonConstant.DEL_FLAG_0);
            this.sysUserService.addUserWithRole(user, selectedRoles);
            this.sysUserService.addUserWithDepart(user, selectedDeparts);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT})
    public Result<SysUser> edit(@RequestBody JSONObject jsonObject) {
        Result<SysUser> result = new Result<SysUser>();
        try {
            SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)((Object)jsonObject.getString("id")));
            this.sysBaseAPI.addLog("\u7f16\u8f91\u7528\u6237\uff0cid\uff1a " + jsonObject.getString("id"), 2, 2);
            if (sysUser == null) {
                result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
            } else {
                SysUser user = (SysUser)JSON.parseObject((String)jsonObject.toJSONString(), SysUser.class);
                user.setUpdateTime(new Date());
                user.setPassword(sysUser.getPassword());
                String roles = jsonObject.getString("selectedroles");
                String departs = jsonObject.getString("selecteddeparts");
                this.sysUserService.editUserWithRole(user, roles);
                this.sysUserService.editUserWithDepart(user, departs);
                this.sysUserService.updateNullPhoneEmail();
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.sysBaseAPI.addLog("\u5220\u9664\u7528\u6237\uff0cid\uff1a " + id, 2, 3);
        this.sysUserService.deleteUser(id);
        return Result.ok("\u5220\u9664\u7528\u6237\u6210\u529f");
    }

    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.sysBaseAPI.addLog("\u6279\u91cf\u5220\u9664\u7528\u6237\uff0c ids\uff1a " + ids, 2, 3);
        this.sysUserService.deleteBatchUsers(ids);
        return Result.ok("\u6279\u91cf\u5220\u9664\u7528\u6237\u6210\u529f");
    }

    @RequestMapping(value={"/frozenBatch"}, method={RequestMethod.PUT})
    public Result<SysUser> frozenBatch(@RequestBody JSONObject jsonObject) {
        Result<SysUser> result = new Result<SysUser>();
        try {
            String[] arr;
            String ids = jsonObject.getString("ids");
            String status = jsonObject.getString("status");
            for (String id : arr = ids.split(",")) {
                if (!oConvertUtils.isNotEmpty(id)) continue;
                this.sysUserService.update(new SysUser().setStatus(Integer.parseInt(status)), (Wrapper)new UpdateWrapper().lambda().eq(SysUser::getId, (Object)id));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25" + e.getMessage());
        }
        result.success("\u64cd\u4f5c\u6210\u529f!");
        return result;
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    public Result<SysUser> queryById(@RequestParam(name="id", required=true) String id) {
        Result<SysUser> result = new Result<SysUser>();
        SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)((Object)id));
        if (sysUser == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult(sysUser);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/queryUserRole"}, method={RequestMethod.GET})
    public Result<List<String>> queryUserRole(@RequestParam(name="userid", required=true) String userid) {
        Result<List<String>> result = new Result<List<String>>();
        ArrayList<String> list = new ArrayList<String>();
        List userRole = this.sysUserRoleService.list((Wrapper)new QueryWrapper().lambda().eq(SysUserRole::getUserId, (Object)userid));
        if (userRole == null || userRole.size() <= 0) {
            result.error500("\u672a\u627e\u5230\u7528\u6237\u76f8\u5173\u89d2\u8272\u4fe1\u606f");
        } else {
            for (SysUserRole sysUserRole : userRole) {
                list.add(sysUserRole.getRoleId());
            }
            result.setSuccess(true);
            result.setResult(list);
        }
        return result;
    }

    @RequestMapping(value={"/checkOnlyUser"}, method={RequestMethod.GET})
    public Result<Boolean> checkOnlyUser(SysUser sysUser) {
        Result<Boolean> result = new Result<Boolean>();
        result.setResult(true);
        try {
            SysUser user = (SysUser)this.sysUserService.getOne((Wrapper)new QueryWrapper((Object)sysUser));
            if (user != null) {
                result.setSuccess(false);
                result.setMessage("\u7528\u6237\u8d26\u53f7\u5df2\u5b58\u5728");
                return result;
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage(e.getMessage());
            return result;
        }
        result.setSuccess(true);
        return result;
    }

    @RequestMapping(value={"/changePassword"}, method={RequestMethod.PUT})
    public Result<?> changePassword(@RequestBody SysUser sysUser) {
        SysUser u = (SysUser)this.sysUserService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUser::getUsername, (Object)sysUser.getUsername()));
        if (u == null) {
            return Result.error("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        sysUser.setId(u.getId());
        return this.sysUserService.changePassword(sysUser);
    }

    @RequestMapping(value={"/userDepartList"}, method={RequestMethod.GET})
    public Result<List<DepartIdModel>> getUserDepartsList(@RequestParam(name="userId", required=true) String userId) {
        Result<List<DepartIdModel>> result = new Result<List<DepartIdModel>>();
        try {
            List<DepartIdModel> depIdModelList = this.sysUserDepartService.queryDepartIdsOfUser(userId);
            if (depIdModelList != null && depIdModelList.size() > 0) {
                result.setSuccess(true);
                result.setMessage("\u67e5\u627e\u6210\u529f");
                result.setResult(depIdModelList);
            } else {
                result.setSuccess(false);
                result.setMessage("\u67e5\u627e\u5931\u8d25");
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            result.setMessage("\u67e5\u627e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u4e86\u5f02\u5e38: " + e.getMessage());
            return result;
        }
    }

    @RequestMapping(value={"/generateUserId"}, method={RequestMethod.GET})
    public Result<String> generateUserId() {
        Result<String> result = new Result<String>();
        System.out.println("\u6211\u6267\u884c\u4e86,\u751f\u6210\u7528\u6237ID==============================");
        String userId = UUID.randomUUID().toString().replace("-", "");
        result.setSuccess(true);
        result.setResult(userId);
        return result;
    }

    @RequestMapping(value={"/queryUserByDepId"}, method={RequestMethod.GET})
    public Result<List<SysUser>> queryUserByDepId(@RequestParam(name="id", required=true) String id, @RequestParam(name="realname", required=false) String realname) {
        Result<List<SysUser>> result = new Result<List<SysUser>>();
        SysDepart sysDepart = (SysDepart)this.sysDepartService.getById((Serializable)((Object)id));
        List<SysUser> userList = this.sysUserDepartService.queryUserByDepCode(sysDepart.getOrgCode(), realname);
        List<String> userIds = userList.stream().map(SysUser::getId).collect(Collectors.toList());
        if (userIds != null && userIds.size() > 0) {
            Map<String, String> useDepNames = this.sysUserService.getDepNamesByUserIds(userIds);
            userList.forEach(item -> item.setOrgCode((String)useDepNames.get(item.getId())));
        }
        try {
            result.setSuccess(true);
            result.setResult(userList);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            return result;
        }
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(SysUser sysUser, HttpServletRequest request) {
        QueryWrapper<SysUser> queryWrapper = QueryGenerator.initQueryWrapper(sysUser, request.getParameterMap());
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        String selections = request.getParameter("selections");
        if (!oConvertUtils.isEmpty(selections)) {
            queryWrapper.in((Object)"id", (Object[])selections.split(","));
        }
        List pageList = this.sysUserService.list((Wrapper)queryWrapper);
        mv.addObject("fileName", (Object)"\u7528\u6237\u5217\u8868");
        mv.addObject("entity", SysUser.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ExportParams exportParams = new ExportParams("\u7528\u6237\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f");
        exportParams.setImageBasePath(this.upLoadPath);
        mv.addObject("params", (Object)exportParams);
        mv.addObject("data", (Object)pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<String> errorMessage = new ArrayList<String>();
        int successLines = 0;
        int errorLines = 0;
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List listSysUsers = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SysUser.class, (ImportParams)params);
                for (int i = 0; i < listSysUsers.size(); ++i) {
                    SysUser sysUserExcel = (SysUser)listSysUsers.get(i);
                    if (StringUtils.isBlank((String)sysUserExcel.getPassword())) {
                        sysUserExcel.setPassword("123456");
                    }
                    String salt = oConvertUtils.randomGen(8);
                    sysUserExcel.setSalt(salt);
                    String passwordEncode = PasswordUtil.encrypt(sysUserExcel.getUsername(), sysUserExcel.getPassword(), salt);
                    sysUserExcel.setPassword(passwordEncode);
                    try {
                        this.sysUserService.save(sysUserExcel);
                        ++successLines;
                    }
                    catch (Exception e) {
                        ++errorLines;
                        String message = e.getMessage();
                        int lineNumber = i + 1;
                        if (message.contains("uniq_sys_user_username")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u7528\u6237\u540d\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                        }
                        if (message.contains("uniq_sys_user_work_no")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u5de5\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                        }
                        if (message.contains("uniq_sys_user_phone")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u624b\u673a\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                        }
                        if (message.contains("uniq_sys_user_email")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u7535\u5b50\u90ae\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                        }
                        errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u672a\u77e5\u9519\u8bef\uff0c\u5ffd\u7565\u5bfc\u5165");
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    String departIds = sysUserExcel.getDepartIds();
                    if (!StringUtils.isNotBlank((String)departIds)) continue;
                    String userId = sysUserExcel.getId();
                    String[] departIdArray = departIds.split(",");
                    ArrayList<SysUserDepart> userDepartList = new ArrayList<SysUserDepart>(departIdArray.length);
                    for (String departId : departIdArray) {
                        userDepartList.add(new SysUserDepart(userId, departId));
                    }
                    this.sysUserDepartService.saveBatch(userDepartList);
                }
            }
            catch (Exception e) {
                errorMessage.add("\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return ImportExcelUtil.imporReturnRes(errorLines, successLines, errorMessage);
    }

    @RequestMapping(value={"/queryByIds"}, method={RequestMethod.GET})
    public Result<Collection<SysUser>> queryByIds(@RequestParam String userIds) {
        Result<Collection<SysUser>> result = new Result<Collection<SysUser>>();
        String[] userId = userIds.split(",");
        List<String> idList = Arrays.asList(userId);
        List userRole = this.sysUserService.listByIds(idList);
        result.setSuccess(true);
        result.setResult(userRole);
        return result;
    }

    @RequestMapping(value={"/updatePassword"}, method={RequestMethod.PUT})
    public Result<?> changPassword(@RequestBody JSONObject json) {
        String username = json.getString("username");
        String oldpassword = json.getString("oldpassword");
        String password = json.getString("password");
        String confirmpassword = json.getString("confirmpassword");
        SysUser user = (SysUser)this.sysUserService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUser::getUsername, (Object)username));
        if (user == null) {
            return Result.error("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        return this.sysUserService.resetPassword(username, oldpassword, password, confirmpassword);
    }

    @RequestMapping(value={"/userRoleList"}, method={RequestMethod.GET})
    public Result<IPage<SysUser>> userRoleList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<SysUser>> result = new Result<IPage<SysUser>>();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String roleId = req.getParameter("roleId");
        String username = req.getParameter("username");
        IPage<SysUser> pageList = this.sysUserService.getUserByRoleId((Page<SysUser>)page, roleId, username);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @RequestMapping(value={"/addSysUserRole"}, method={RequestMethod.POST})
    public Result<String> addSysUserRole(@RequestBody SysUserRoleVO sysUserRoleVO) {
        Result<String> result = new Result<String>();
        try {
            String sysRoleId = sysUserRoleVO.getRoleId();
            for (String sysUserId : sysUserRoleVO.getUserIdList()) {
                SysUserRole sysUserRole = new SysUserRole(sysUserId, sysRoleId);
                QueryWrapper queryWrapper = new QueryWrapper();
                ((QueryWrapper)queryWrapper.eq((Object)"role_id", (Object)sysRoleId)).eq((Object)"user_id", (Object)sysUserId);
                SysUserRole one = (SysUserRole)this.sysUserRoleService.getOne((Wrapper)queryWrapper);
                if (one != null) continue;
                this.sysUserRoleService.save(sysUserRole);
            }
            result.setMessage("\u6dfb\u52a0\u6210\u529f!");
            result.setSuccess(true);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            result.setMessage("\u51fa\u9519\u4e86: " + e.getMessage());
            return result;
        }
    }

    @RequestMapping(value={"/deleteUserRole"}, method={RequestMethod.DELETE})
    public Result<SysUserRole> deleteUserRole(@RequestParam(name="roleId") String roleId, @RequestParam(name="userId", required=true) String userId) {
        Result<SysUserRole> result = new Result<SysUserRole>();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"role_id", (Object)roleId)).eq((Object)"user_id", (Object)userId);
            this.sysUserRoleService.remove((Wrapper)queryWrapper);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u5220\u9664\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/deleteUserRoleBatch"}, method={RequestMethod.DELETE})
    public Result<SysUserRole> deleteUserRoleBatch(@RequestParam(name="roleId") String roleId, @RequestParam(name="userIds", required=true) String userIds) {
        Result<SysUserRole> result = new Result<SysUserRole>();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"role_id", (Object)roleId)).in((Object)"user_id", Arrays.asList(userIds.split(",")));
            this.sysUserRoleService.remove((Wrapper)queryWrapper);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u5220\u9664\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/departUserList"}, method={RequestMethod.GET})
    public Result<IPage<SysUser>> departUserList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<SysUser>> result = new Result<IPage<SysUser>>();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String depId = req.getParameter("depId");
        String username = req.getParameter("username");
        List<Object> subDepids = new ArrayList();
        if (oConvertUtils.isEmpty(depId)) {
            LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            int userIdentity = user.getUserIdentity() != null ? user.getUserIdentity() : CommonConstant.USER_IDENTITY_1;
            if (oConvertUtils.isNotEmpty(userIdentity) && userIdentity == CommonConstant.USER_IDENTITY_2) {
                subDepids = this.sysDepartService.getMySubDepIdsByDepId(user.getDepartIds());
            }
        } else {
            subDepids = this.sysDepartService.getSubDepIdsByDepId(depId);
        }
        if (subDepids != null && subDepids.size() > 0) {
            IPage<SysUser> pageList = this.sysUserService.getUserByDepIds((Page<SysUser>)page, subDepids, username);
            List<String> userIds = pageList.getRecords().stream().map(SysUser::getId).collect(Collectors.toList());
            if (userIds != null && userIds.size() > 0) {
                Map<String, String> useDepNames = this.sysUserService.getDepNamesByUserIds(userIds);
                pageList.getRecords().forEach(item -> item.setOrgCode((String)useDepNames.get(item.getId())));
            }
            result.setSuccess(true);
            result.setResult(pageList);
        } else {
            result.setSuccess(true);
            result.setResult(null);
        }
        return result;
    }

    @GetMapping(value={"/queryByOrgCode"})
    public Result<?> queryByDepartId(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orgCode") String orgCode, SysUser userParams) {
        IPage<SysUserSysDepartModel> pageList = this.sysUserService.queryUserByOrgCode(orgCode, userParams, (IPage)new Page((long)pageNo.intValue(), (long)pageSize.intValue()));
        return Result.ok(pageList);
    }

    @GetMapping(value={"/queryByOrgCodeForAddressList"})
    public Result<?> queryByOrgCodeForAddressList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orgCode", required=false) String orgCode, SysUser userParams) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<SysUserSysDepartModel> pageList = this.sysUserService.queryUserByOrgCode(orgCode, userParams, (IPage)page);
        List list = pageList.getRecords();
        HashMap<String, JSONObject> hasUser = new HashMap<String, JSONObject>(list.size());
        JSONArray resultJson = new JSONArray(list.size());
        for (SysUserSysDepartModel item : list) {
            String userId = item.getId();
            JSONObject getModel = (JSONObject)hasUser.get(userId);
            if (getModel != null) {
                String departName = getModel.get((Object)"departName").toString();
                getModel.put("departName", (Object)(departName + " | " + item.getDepartName()));
                continue;
            }
            JSONObject json = JSON.parseObject((String)JSON.toJSONString((Object)item));
            json.remove((Object)"id");
            json.put("userId", (Object)userId);
            json.put("departId", (Object)item.getDepartId());
            json.put("departName", (Object)item.getDepartName());
            resultJson.add((Object)json);
            hasUser.put(userId, json);
        }
        Page result = new Page((long)pageNo.intValue(), (long)pageSize.intValue(), pageList.getTotal());
        result.setRecords(resultJson.toJavaList(JSONObject.class));
        return Result.ok(result);
    }

    @RequestMapping(value={"/editSysDepartWithUser"}, method={RequestMethod.POST})
    public Result<String> editSysDepartWithUser(@RequestBody SysDepartUsersVO sysDepartUsersVO) {
        Result<String> result = new Result<String>();
        try {
            String sysDepId = sysDepartUsersVO.getDepId();
            for (String sysUserId : sysDepartUsersVO.getUserIdList()) {
                SysUserDepart sysUserDepart = new SysUserDepart(null, sysUserId, sysDepId);
                QueryWrapper queryWrapper = new QueryWrapper();
                ((QueryWrapper)queryWrapper.eq((Object)"dep_id", (Object)sysDepId)).eq((Object)"user_id", (Object)sysUserId);
                SysUserDepart one = (SysUserDepart)this.sysUserDepartService.getOne((Wrapper)queryWrapper);
                if (one != null) continue;
                this.sysUserDepartService.save(sysUserDepart);
            }
            result.setMessage("\u6dfb\u52a0\u6210\u529f!");
            result.setSuccess(true);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            result.setMessage("\u51fa\u9519\u4e86: " + e.getMessage());
            return result;
        }
    }

    @RequestMapping(value={"/deleteUserInDepart"}, method={RequestMethod.DELETE})
    public Result<SysUserDepart> deleteUserInDepart(@RequestParam(name="depId") String depId, @RequestParam(name="userId", required=true) String userId) {
        Result<SysUserDepart> result = new Result<SysUserDepart>();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"dep_id", (Object)depId)).eq((Object)"user_id", (Object)userId);
            boolean b = this.sysUserDepartService.remove((Wrapper)queryWrapper);
            if (b) {
                List sysDepartRoleList = this.departRoleService.list((Wrapper)new QueryWrapper().eq((Object)"depart_id", (Object)depId));
                List roleIds = sysDepartRoleList.stream().map(SysDepartRole::getId).collect(Collectors.toList());
                if (roleIds != null && roleIds.size() > 0) {
                    QueryWrapper query = new QueryWrapper();
                    ((QueryWrapper)query.eq((Object)"user_id", (Object)userId)).in((Object)"drole_id", roleIds);
                    this.departRoleUserService.remove((Wrapper)query);
                }
                result.success("\u5220\u9664\u6210\u529f!");
            } else {
                result.error500("\u5f53\u524d\u9009\u4e2d\u90e8\u95e8\u4e0e\u7528\u6237\u65e0\u5173\u8054\u5173\u7cfb!");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u5220\u9664\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/deleteUserInDepartBatch"}, method={RequestMethod.DELETE})
    public Result<SysUserDepart> deleteUserInDepartBatch(@RequestParam(name="depId") String depId, @RequestParam(name="userIds", required=true) String userIds) {
        Result<SysUserDepart> result = new Result<SysUserDepart>();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"dep_id", (Object)depId)).in((Object)"user_id", Arrays.asList(userIds.split(",")));
            boolean b = this.sysUserDepartService.remove((Wrapper)queryWrapper);
            if (b) {
                this.departRoleUserService.removeDeptRoleUser(Arrays.asList(userIds.split(",")), depId);
            }
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u5220\u9664\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/getCurrentUserDeparts"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> getCurrentUserDeparts() {
        Result<Map<String, Object>> result = new Result<Map<String, Object>>();
        try {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            List<SysDepart> list = this.sysDepartService.queryUserDeparts(sysUser.getId());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("list", list);
            map.put("orgCode", sysUser.getOrgCode());
            result.setSuccess(true);
            result.setResult(map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return result;
    }

    @PostMapping(value={"/register"})
    public Result<JSONObject> userRegister(@RequestBody JSONObject jsonObject, SysUser user) {
        SysUser sysUser3;
        String password;
        Result<JSONObject> result = new Result<JSONObject>();
        String phone = jsonObject.getString("phone");
        String smscode = jsonObject.getString("smscode");
        Object code = this.redisUtil.get(phone);
        String username = jsonObject.getString("username");
        if (oConvertUtils.isEmpty(username)) {
            username = phone;
        }
        if (oConvertUtils.isEmpty(password = jsonObject.getString("password"))) {
            password = RandomUtil.randomString((int)8);
        }
        String email = jsonObject.getString("email");
        SysUser sysUser1 = this.sysUserService.getUserByName(username);
        if (sysUser1 != null) {
            result.setMessage("\u7528\u6237\u540d\u5df2\u6ce8\u518c");
            result.setSuccess(false);
            return result;
        }
        SysUser sysUser2 = this.sysUserService.getUserByPhone(phone);
        if (sysUser2 != null) {
            result.setMessage("\u8be5\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
            result.setSuccess(false);
            return result;
        }
        if (oConvertUtils.isNotEmpty(email) && (sysUser3 = this.sysUserService.getUserByEmail(email)) != null) {
            result.setMessage("\u90ae\u7bb1\u5df2\u88ab\u6ce8\u518c");
            result.setSuccess(false);
            return result;
        }
        if (!smscode.equals(code)) {
            result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
            result.setSuccess(false);
            return result;
        }
        try {
            user.setCreateTime(new Date());
            String salt = oConvertUtils.randomGen(8);
            String passwordEncode = PasswordUtil.encrypt(username, password, salt);
            user.setSalt(salt);
            user.setUsername(username);
            user.setRealname(username);
            user.setPassword(passwordEncode);
            user.setEmail(email);
            user.setPhone(phone);
            user.setStatus(CommonConstant.USER_UNFREEZE);
            user.setDelFlag(CommonConstant.DEL_FLAG_0);
            user.setActivitiSync(CommonConstant.ACT_SYNC_0);
            this.sysUserService.addUserWithRole(user, "ee8626f80f7c2619917b6236f3a7f02b");
            result.success("\u6ce8\u518c\u6210\u529f");
        }
        catch (Exception e) {
            result.error500("\u6ce8\u518c\u5931\u8d25");
        }
        return result;
    }

    @GetMapping(value={"/querySysUser"})
    public Result<Map<String, Object>> querySysUser(SysUser sysUser) {
        SysUser user;
        String phone = sysUser.getPhone();
        String username = sysUser.getUsername();
        Result<Map<String, Object>> result = new Result<Map<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (oConvertUtils.isNotEmpty(phone) && (user = this.sysUserService.getUserByPhone(phone)) != null) {
            map.put("username", user.getUsername());
            map.put("phone", user.getPhone());
            result.setSuccess(true);
            result.setResult(map);
            return result;
        }
        if (oConvertUtils.isNotEmpty(username) && (user = this.sysUserService.getUserByName(username)) != null) {
            map.put("username", user.getUsername());
            map.put("phone", user.getPhone());
            result.setSuccess(true);
            result.setResult(map);
            return result;
        }
        result.setSuccess(false);
        result.setMessage("\u9a8c\u8bc1\u5931\u8d25");
        return result;
    }

    @PostMapping(value={"/phoneVerification"})
    public Result<Map<String, String>> phoneVerification(@RequestBody JSONObject jsonObject) {
        Object code;
        Result<Map<String, String>> result = new Result<Map<String, String>>();
        String phone = jsonObject.getString("phone");
        String smscode = jsonObject.getString("smscode");
        if (!smscode.equals(code = this.redisUtil.get(phone))) {
            result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
            result.setSuccess(false);
            return result;
        }
        this.redisUtil.set(phone, smscode, 600L);
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUser::getPhone, (Object)phone);
        SysUser user = (SysUser)this.sysUserService.getOne((Wrapper)query);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("smscode", smscode);
        map.put("username", user.getUsername());
        result.setResult(map);
        result.setSuccess(true);
        return result;
    }

    @GetMapping(value={"/passwordChange"})
    public Result<SysUser> passwordChange(@RequestParam(name="username") String username, @RequestParam(name="password") String password, @RequestParam(name="smscode") String smscode, @RequestParam(name="phone") String phone) {
        Result<SysUser> result = new Result<SysUser>();
        if (oConvertUtils.isEmpty(username) || oConvertUtils.isEmpty(password) || oConvertUtils.isEmpty(smscode) || oConvertUtils.isEmpty(phone)) {
            result.setMessage("\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25\uff01");
            result.setSuccess(false);
            return result;
        }
        SysUser sysUser = new SysUser();
        Object object = this.redisUtil.get(phone);
        if (null == object) {
            result.setMessage("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u6548\uff01");
            result.setSuccess(false);
            return result;
        }
        if (!smscode.equals(object)) {
            result.setMessage("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u5339\u914d\uff01");
            result.setSuccess(false);
            return result;
        }
        sysUser = (SysUser)this.sysUserService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUser::getUsername, (Object)username)).eq(SysUser::getPhone, (Object)phone));
        if (sysUser == null) {
            result.setMessage("\u672a\u627e\u5230\u7528\u6237\uff01");
            result.setSuccess(false);
            return result;
        }
        String salt = oConvertUtils.randomGen(8);
        sysUser.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt(sysUser.getUsername(), password, salt);
        sysUser.setPassword(passwordEncode);
        this.sysUserService.updateById(sysUser);
        result.setSuccess(true);
        result.setMessage("\u5bc6\u7801\u91cd\u7f6e\u5b8c\u6210\uff01");
        return result;
    }

    @GetMapping(value={"/getUserSectionInfoByToken"})
    public Result<?> getUserSectionInfoByToken(HttpServletRequest request, @RequestParam(name="token", required=false) String token) {
        try {
            String username = null;
            username = oConvertUtils.isEmpty(token) ? JwtUtil.getUserNameByToken(request) : JwtUtil.getUsername(token);
            log.info(" ------ \u901a\u8fc7\u4ee4\u724c\u83b7\u53d6\u90e8\u5206\u7528\u6237\u4fe1\u606f\uff0c\u5f53\u524d\u7528\u6237\uff1a " + username);
            SysUser sysUser = this.sysUserService.getUserByName(username);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sysUserId", sysUser.getId());
            map.put("sysUserCode", sysUser.getUsername());
            map.put("sysUserName", sysUser.getRealname());
            map.put("sysOrgCode", sysUser.getOrgCode());
            log.info(" ------ \u901a\u8fc7\u4ee4\u724c\u83b7\u53d6\u90e8\u5206\u7528\u6237\u4fe1\u606f\uff0c\u5df2\u83b7\u53d6\u7684\u7528\u6237\u4fe1\u606f\uff1a " + map);
            return Result.ok(map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error(500, "\u67e5\u8be2\u5931\u8d25:" + e.getMessage());
        }
    }

    @GetMapping(value={"/appUserList"})
    public Result<?> appUserList(@RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="username", required=false) String username, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="syncFlow", required=false) String syncFlow) {
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            if (oConvertUtils.isNotEmpty(syncFlow)) {
                query.eq(SysUser::getActivitiSync, (Object)"1");
            }
            query.eq(SysUser::getDelFlag, (Object)"0");
            if (oConvertUtils.isNotEmpty(username)) {
                if (username.contains(",")) {
                    query.in(SysUser::getUsername, (Object[])username.split(","));
                } else {
                    query.eq(SysUser::getUsername, (Object)username);
                }
            } else {
                query.and(i -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(SysUser::getUsername, (Object)keyword)).or()).like(SysUser::getRealname, (Object)keyword);
                });
            }
            Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
            IPage res = this.sysUserService.page((IPage)page, (Wrapper)query);
            return Result.ok(res);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error(500, "\u67e5\u8be2\u5931\u8d25:" + e.getMessage());
        }
    }

    @GetMapping(value={"/recycleBin"})
    public Result getRecycleBin() {
        List<SysUser> logicDeletedUserList = this.sysUserService.queryLogicDeleted();
        if (logicDeletedUserList.size() > 0) {
            List<String> userIds = logicDeletedUserList.stream().map(SysUser::getId).collect(Collectors.toList());
            Map<String, String> useDepNames = this.sysUserService.getDepNamesByUserIds(userIds);
            logicDeletedUserList.forEach(item -> item.setOrgCode((String)useDepNames.get(item.getId())));
        }
        return Result.ok(logicDeletedUserList);
    }

    @RequestMapping(value={"/putRecycleBin"}, method={RequestMethod.PUT})
    public Result putRecycleBin(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        String userIds = jsonObject.getString("userIds");
        if (StringUtils.isNotBlank((String)userIds)) {
            SysUser updateUser = new SysUser();
            updateUser.setUpdateBy(JwtUtil.getUserNameByToken(request));
            updateUser.setUpdateTime(new Date());
            this.sysUserService.revertLogicDeleted(Arrays.asList(userIds.split(",")), updateUser);
        }
        return Result.ok("\u8fd8\u539f\u6210\u529f");
    }

    @RequestMapping(value={"/deleteRecycleBin"}, method={RequestMethod.DELETE})
    public Result deleteRecycleBin(@RequestParam(value="userIds") String userIds) {
        if (StringUtils.isNotBlank((String)userIds)) {
            this.sysUserService.removeLogicDeleted(Arrays.asList(userIds.split(",")));
        }
        return Result.ok("\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/appEdit"}, method={RequestMethod.PUT})
    public Result<SysUser> appEdit(HttpServletRequest request, @RequestBody JSONObject jsonObject) {
        Result<SysUser> result = new Result<SysUser>();
        try {
            String username = JwtUtil.getUserNameByToken(request);
            SysUser sysUser = this.sysUserService.getUserByName(username);
            this.sysBaseAPI.addLog("\u79fb\u52a8\u7aef\u7f16\u8f91\u7528\u6237\uff0cid\uff1a " + jsonObject.getString("id"), 2, 2);
            if (sysUser == null) {
                result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u7528\u6237!");
            } else {
                String realname = jsonObject.getString("realname");
                String avatar = jsonObject.getString("avatar");
                String sex = jsonObject.getString("sex");
                String phone = jsonObject.getString("phone");
                String email = jsonObject.getString("email");
                Date birthday = jsonObject.getDate("birthday");
                sysUser.setRealname(realname);
                sysUser.setAvatar(avatar);
                sysUser.setSex(Integer.parseInt(sex));
                sysUser.setBirthday(birthday);
                sysUser.setPhone(phone);
                sysUser.setEmail(email);
                sysUser.setUpdateTime(new Date());
                this.sysUserService.updateById(sysUser);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25!");
        }
        return result;
    }

    @GetMapping(value={"/queryChildrenByUsername"})
    public Result queryChildrenByUsername(@RequestParam(value="userId") String userId) {
        String departIds;
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)((Object)userId));
        String username = sysUser.getUsername();
        Integer identity = sysUser.getUserIdentity();
        map.put("sysUser", sysUser);
        if (identity != null && identity == 2 && StringUtils.isNotBlank((String)(departIds = sysUser.getDepartIds()))) {
            List<String> departIdList = Arrays.asList(departIds.split(","));
            List<SysUser> childrenUser = this.sysUserService.queryByDepIds(departIdList, username);
            map.put("children", childrenUser);
        }
        return Result.ok(map);
    }

    @GetMapping(value={"/appQueryByDepartId"})
    public Result<List<SysUser>> appQueryByDepartId(@RequestParam(name="departId", required=false) String departId) {
        Result<List<SysUser>> result = new Result<List<SysUser>>();
        ArrayList<String> list = new ArrayList<String>();
        list.add(departId);
        List<SysUser> childrenUser = this.sysUserService.queryByDepIds(list, null);
        result.setResult(childrenUser);
        return result;
    }

    @GetMapping(value={"/appQueryUser"})
    public Result<List<SysUser>> appQueryUser(@RequestParam(name="keyword", required=false) String keyword) {
        List list;
        List<String> userIds;
        Result<List<SysUser>> result = new Result<List<SysUser>>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ne(SysUser::getUsername, (Object)"_reserve_user_external");
        if (StringUtils.isNotBlank((String)keyword)) {
            queryWrapper.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(SysUser::getUsername, (Object)keyword)).or()).like(SysUser::getRealname, (Object)keyword);
            });
        }
        if ((userIds = (list = this.sysUserService.list((Wrapper)queryWrapper)).stream().map(SysUser::getId).collect(Collectors.toList())) != null && userIds.size() > 0) {
            Map<String, String> useDepNames = this.sysUserService.getDepNamesByUserIds(userIds);
            list.forEach(item -> item.setOrgCodeTxt((String)useDepNames.get(item.getId())));
        }
        result.setResult(list);
        return result;
    }
}

