/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.DictQuery;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ImportExcelUtil;
import org.jeecg.common.util.SqlInjectionUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDict;
import org.jeecg.modules.system.entity.SysDictItem;
import org.jeecg.modules.system.model.SysDictTree;
import org.jeecg.modules.system.model.TreeSelectModel;
import org.jeecg.modules.system.service.ISysDictItemService;
import org.jeecg.modules.system.service.ISysDictService;
import org.jeecg.modules.system.vo.SysDictPage;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sys/dict"})
public class SysDictController {
    private static final Logger log = LoggerFactory.getLogger(SysDictController.class);
    @Autowired
    private ISysDictService sysDictService;
    @Autowired
    private ISysDictItemService sysDictItemService;
    @Autowired
    public RedisTemplate<String, Object> redisTemplate;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<SysDict>> queryPageList(SysDict sysDict, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<SysDict>> result = new Result<IPage<SysDict>>();
        QueryWrapper<SysDict> queryWrapper = QueryGenerator.initQueryWrapper(sysDict, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysDictService.page((IPage)page, (Wrapper)queryWrapper);
        log.debug("\u67e5\u8be2\u5f53\u524d\u9875\uff1a" + pageList.getCurrent());
        log.debug("\u67e5\u8be2\u5f53\u524d\u9875\u6570\u91cf\uff1a" + pageList.getSize());
        log.debug("\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\uff1a" + pageList.getRecords().size());
        log.debug("\u6570\u636e\u603b\u6570\uff1a" + pageList.getTotal());
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @RequestMapping(value={"/treeList"}, method={RequestMethod.GET})
    public Result<List<SysDictTree>> treeList(SysDict sysDict, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<List<SysDictTree>> result = new Result<List<SysDictTree>>();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        String dictName = sysDict.getDictName();
        if (oConvertUtils.isNotEmpty(dictName)) {
            query.like(true, SysDict::getDictName, (Object)dictName);
        }
        query.orderByDesc(true, (Object[])new SFunction[]{SysDict::getCreateTime});
        List list = this.sysDictService.list((Wrapper)query);
        ArrayList<SysDictTree> treeList = new ArrayList<SysDictTree>();
        for (SysDict node : list) {
            treeList.add(new SysDictTree(node));
        }
        result.setSuccess(true);
        result.setResult(treeList);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/getDictItems/{dictCode}"}, method={RequestMethod.GET})
    public Result<List<DictModel>> getDictItems(@PathVariable String dictCode, @RequestParam(value="sign", required=false) String sign, HttpServletRequest request) {
        log.info(" dictCode : " + dictCode);
        Result<List<DictModel>> result = new Result<List<DictModel>>();
        List<DictModel> ls = null;
        try {
            if (dictCode.indexOf(",") != -1) {
                String[] params = dictCode.split(",");
                if (params.length < 3) {
                    result.error500("\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    return result;
                }
                String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
                SqlInjectionUtil.filterContent(sqlInjCheck);
                if (params.length == 4) {
                    SqlInjectionUtil.specialFilterContent(params[3]);
                    ls = this.sysDictService.queryTableDictItemsByCodeAndFilter(params[0], params[1], params[2], params[3]);
                } else {
                    if (params.length != 3) {
                        result.error500("\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        return result;
                    }
                    ls = this.sysDictService.queryTableDictItemsByCode(params[0], params[1], params[2]);
                }
            } else {
                ls = this.sysDictService.queryDictItemsByCode(dictCode);
            }
            result.setSuccess(true);
            result.setResult(ls);
            log.info(result.toString());
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
            return result;
        }
    }

    @RequestMapping(value={"/queryAllDictItems"}, method={RequestMethod.GET})
    public Result<?> queryAllDictItems(HttpServletRequest request) {
        Map<Object, Object> res = new HashMap();
        res = this.sysDictService.queryAllDictItems();
        return Result.ok(res);
    }

    @RequestMapping(value={"/getDictText/{dictCode}/{key}"}, method={RequestMethod.GET})
    public Result<String> getDictText(@PathVariable(value="dictCode") String dictCode, @PathVariable(value="key") String key) {
        log.info(" dictCode : " + dictCode);
        Result<String> result = new Result<String>();
        String text = null;
        try {
            text = this.sysDictService.queryDictTextByKey(dictCode, key);
            result.setSuccess(true);
            result.setResult(text);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
            return result;
        }
        return result;
    }

    @RequestMapping(value={"/loadDict/{dictCode}"}, method={RequestMethod.GET})
    public Result<List<DictModel>> loadDict(@PathVariable String dictCode, @RequestParam(name="keyword") String keyword, @RequestParam(value="sign", required=false) String sign, HttpServletRequest request) {
        log.info(" \u52a0\u8f7d\u5b57\u5178\u8868\u6570\u636e,\u52a0\u8f7d\u5173\u952e\u5b57: " + keyword);
        Result<List<DictModel>> result = new Result<List<DictModel>>();
        List<DictModel> ls = null;
        try {
            if (dictCode.indexOf(",") != -1) {
                String[] params = dictCode.split(",");
                if (params.length != 3) {
                    result.error500("\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    return result;
                }
                ls = this.sysDictService.queryTableDictItems(params[0], params[1], params[2], keyword);
                result.setSuccess(true);
                result.setResult(ls);
                log.info(result.toString());
            } else {
                result.error500("\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
            return result;
        }
        return result;
    }

    @RequestMapping(value={"/loadDictItem/{dictCode}"}, method={RequestMethod.GET})
    public Result<List<String>> loadDictItem(@PathVariable String dictCode, @RequestParam(name="key") String keys, @RequestParam(value="sign", required=false) String sign, HttpServletRequest request) {
        Result<List<String>> result = new Result<List<String>>();
        try {
            if (dictCode.indexOf(",") != -1) {
                String[] params = dictCode.split(",");
                if (params.length != 3) {
                    result.error500("\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    return result;
                }
                List<String> texts = this.sysDictService.queryTableDictByKeys(params[0], params[1], params[2], keys);
                result.setSuccess(true);
                result.setResult(texts);
                log.info(result.toString());
            } else {
                result.error500("\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
            return result;
        }
        return result;
    }

    @RequestMapping(value={"/loadTreeData"}, method={RequestMethod.GET})
    public Result<List<TreeSelectModel>> loadTreeData(@RequestParam(name="pid") String pid, @RequestParam(name="pidField") String pidField, @RequestParam(name="tableName") String tbname, @RequestParam(name="text") String text, @RequestParam(name="code") String code, @RequestParam(name="hasChildField") String hasChildField, @RequestParam(name="condition") String condition, @RequestParam(value="sign", required=false) String sign, HttpServletRequest request) {
        Result<List<TreeSelectModel>> result = new Result<List<TreeSelectModel>>();
        Map query = null;
        if (oConvertUtils.isNotEmpty(condition)) {
            query = (Map)JSON.parseObject((String)condition, Map.class);
        }
        String dictCode = tbname + "," + text + "," + code + "," + condition;
        List<TreeSelectModel> ls = this.sysDictService.queryTreeList(query, tbname, text, code, pidField, pid, hasChildField);
        result.setSuccess(true);
        result.setResult(ls);
        return result;
    }

    @GetMapping(value={"/queryTableData"})
    public Result<List<DictModel>> queryTableData(DictQuery query, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="sign", required=false) String sign, HttpServletRequest request) {
        Result<List<DictModel>> res = new Result<List<DictModel>>();
        String dictCode = query.getTable() + "," + query.getText() + "," + query.getCode();
        List<DictModel> ls = this.sysDictService.queryDictTablePageList(query, pageSize, pageNo);
        res.setResult(ls);
        res.setSuccess(true);
        return res;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<SysDict> add(@RequestBody SysDict sysDict) {
        Result<SysDict> result = new Result<SysDict>();
        try {
            sysDict.setCreateTime(new Date());
            sysDict.setDelFlag(CommonConstant.DEL_FLAG_0);
            this.sysDictService.save(sysDict);
            result.success("\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT})
    public Result<SysDict> edit(@RequestBody SysDict sysDict) {
        Result<SysDict> result = new Result<SysDict>();
        SysDict sysdict = (SysDict)this.sysDictService.getById((Serializable)((Object)sysDict.getId()));
        if (sysdict == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            sysDict.setUpdateTime(new Date());
            boolean ok = this.sysDictService.updateById(sysDict);
            if (ok) {
                result.success("\u7f16\u8f91\u6210\u529f!");
            }
        }
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<SysDict> delete(@RequestParam(name="id", required=true) String id) {
        Result<SysDict> result = new Result<SysDict>();
        boolean ok = this.sysDictService.removeById((Serializable)((Object)id));
        if (ok) {
            result.success("\u5220\u9664\u6210\u529f!");
        } else {
            result.error500("\u5220\u9664\u5931\u8d25!");
        }
        return result;
    }

    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<SysDict> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result<SysDict> result = new Result<SysDict>();
        if (oConvertUtils.isEmpty(ids)) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.sysDictService.removeByIds(Arrays.asList(ids.split(",")));
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @RequestMapping(value={"/refleshCache"})
    public Result<?> refleshCache() {
        Result result = new Result();
        Set keys = this.redisTemplate.keys((Object)"sys:cache:dict*");
        Set keys2 = this.redisTemplate.keys((Object)"sys:cache:dictTable*");
        Set keys3 = this.redisTemplate.keys((Object)"sys:cache:depart:alldata*");
        Set keys4 = this.redisTemplate.keys((Object)"sys:cache:depart:allids*");
        this.redisTemplate.delete((Collection)keys);
        this.redisTemplate.delete((Collection)keys2);
        this.redisTemplate.delete((Collection)keys3);
        this.redisTemplate.delete((Collection)keys4);
        return result;
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(SysDict sysDict, HttpServletRequest request) {
        QueryWrapper<SysDict> queryWrapper = QueryGenerator.initQueryWrapper(sysDict, request.getParameterMap());
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        ArrayList<SysDictPage> pageList = new ArrayList<SysDictPage>();
        List sysDictList = this.sysDictService.list((Wrapper)queryWrapper);
        for (SysDict dictMain : sysDictList) {
            SysDictPage vo = new SysDictPage();
            BeanUtils.copyProperties((Object)dictMain, (Object)vo);
            List<SysDictItem> sysDictItemList = this.sysDictItemService.selectItemsByMainId(dictMain.getId());
            vo.setSysDictItemList(sysDictItemList);
            pageList.add(vo);
        }
        mv.addObject("fileName", (Object)"\u6570\u636e\u5b57\u5178");
        mv.addObject("entity", SysDictPage.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        mv.addObject("params", (Object)new ExportParams("\u6570\u636e\u5b57\u5178\u5217\u8868", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u6570\u636e\u5b57\u5178"));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(2);
            params.setNeedSave(true);
            try {
                List list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SysDictPage.class, (ImportParams)params);
                ArrayList<String> errorMessage = new ArrayList<String>();
                int successLines = 0;
                int errorLines = 0;
                for (int i = 0; i < list.size(); ++i) {
                    int lineNumber;
                    SysDict po = new SysDict();
                    BeanUtils.copyProperties(list.get(i), (Object)po);
                    po.setDelFlag(CommonConstant.DEL_FLAG_0);
                    try {
                        Integer integer = this.sysDictService.saveMain(po, ((SysDictPage)list.get(i)).getSysDictItemList());
                        if (integer > 0) {
                            ++successLines;
                            continue;
                        }
                        ++errorLines;
                        lineNumber = i + 1;
                        errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u5b57\u5178\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                        continue;
                    }
                    catch (Exception e) {
                        ++errorLines;
                        lineNumber = i + 1;
                        errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u5b57\u5178\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                    }
                }
                Result<?> result = ImportExcelUtil.imporReturnRes(errorLines, successLines, errorMessage);
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result<Object> result = Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/deleteList"}, method={RequestMethod.GET})
    public Result<List<SysDict>> deleteList() {
        Result<List<SysDict>> result = new Result<List<SysDict>>();
        List<SysDict> list = this.sysDictService.queryDeleteList();
        result.setSuccess(true);
        result.setResult(list);
        return result;
    }

    @RequestMapping(value={"/deletePhysic/{id}"}, method={RequestMethod.DELETE})
    public Result<?> deletePhysic(@PathVariable String id) {
        try {
            this.sysDictService.deleteOneDictPhysically(id);
            return Result.ok("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error("\u5220\u9664\u5931\u8d25!");
        }
    }

    @RequestMapping(value={"/back/{id}"}, method={RequestMethod.PUT})
    public Result<?> back(@PathVariable String id) {
        try {
            this.sysDictService.updateDictDelFlag(0, id);
            return Result.ok("\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error("\u64cd\u4f5c\u5931\u8d25!");
        }
    }
}

