/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDepartRole;
import org.jeecg.modules.system.entity.SysDepartRolePermission;
import org.jeecg.modules.system.entity.SysDepartRoleUser;
import org.jeecg.modules.system.entity.SysPermissionDataRule;
import org.jeecg.modules.system.service.ISysDepartPermissionService;
import org.jeecg.modules.system.service.ISysDepartRolePermissionService;
import org.jeecg.modules.system.service.ISysDepartRoleService;
import org.jeecg.modules.system.service.ISysDepartRoleUserService;
import org.jeecg.modules.system.service.ISysDepartService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u90e8\u95e8\u89d2\u8272"})
@RestController
@RequestMapping(value={"/sys/sysDepartRole"})
public class SysDepartRoleController
extends JeecgController<SysDepartRole, ISysDepartRoleService> {
    private static final Logger log = LoggerFactory.getLogger(SysDepartRoleController.class);
    @Autowired
    private ISysDepartRoleService sysDepartRoleService;
    @Autowired
    private ISysDepartRoleUserService departRoleUserService;
    @Autowired
    private ISysDepartPermissionService sysDepartPermissionService;
    @Autowired
    private ISysDepartRolePermissionService sysDepartRolePermissionService;
    @Autowired
    private ISysDepartService sysDepartService;

    @ApiOperation(value="\u90e8\u95e8\u89d2\u8272-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u90e8\u95e8\u89d2\u8272-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SysDepartRole sysDepartRole, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="deptId", required=false) String deptId, HttpServletRequest req) {
        QueryWrapper<SysDepartRole> queryWrapper = QueryGenerator.initQueryWrapper(sysDepartRole, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        Object deptIds = null;
        queryWrapper.eq((Object)"depart_id", (Object)deptId);
        IPage pageList = this.sysDepartRoleService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u90e8\u95e8\u89d2\u8272-\u6dfb\u52a0", notes="\u90e8\u95e8\u89d2\u8272-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SysDepartRole sysDepartRole) {
        this.sysDepartRoleService.save(sysDepartRole);
        return Result.ok("\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u90e8\u95e8\u89d2\u8272-\u7f16\u8f91", notes="\u90e8\u95e8\u89d2\u8272-\u7f16\u8f91")
    @PutMapping(value={"/edit"})
    public Result<?> edit(@RequestBody SysDepartRole sysDepartRole) {
        this.sysDepartRoleService.updateById(sysDepartRole);
        return Result.ok("\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u90e8\u95e8\u89d2\u8272-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u90e8\u95e8\u89d2\u8272-\u901a\u8fc7id\u5220\u9664", notes="\u90e8\u95e8\u89d2\u8272-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.sysDepartRoleService.removeById((Serializable)((Object)id));
        return Result.ok("\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u90e8\u95e8\u89d2\u8272-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u90e8\u95e8\u89d2\u8272-\u6279\u91cf\u5220\u9664", notes="\u90e8\u95e8\u89d2\u8272-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.sysDepartRoleService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.ok("\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u90e8\u95e8\u89d2\u8272-\u901a\u8fc7id\u67e5\u8be2", notes="\u90e8\u95e8\u89d2\u8272-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SysDepartRole sysDepartRole = (SysDepartRole)this.sysDepartRoleService.getById((Serializable)((Object)id));
        return Result.ok(sysDepartRole);
    }

    @RequestMapping(value={"/getDeptRoleList"}, method={RequestMethod.GET})
    public Result<List<SysDepartRole>> getDeptRoleList(@RequestParam(value="departId") String departId, @RequestParam(value="userId") String userId) {
        Result<List<SysDepartRole>> result = new Result<List<SysDepartRole>>();
        List deptRoleList = this.sysDepartRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysDepartRole::getDepartId, (Object)departId));
        result.setSuccess(true);
        result.setResult(deptRoleList);
        return result;
    }

    @RequestMapping(value={"/deptRoleUserAdd"}, method={RequestMethod.POST})
    public Result<?> deptRoleAdd(@RequestBody JSONObject json) {
        String newRoleId = json.getString("newRoleId");
        String oldRoleId = json.getString("oldRoleId");
        String userId = json.getString("userId");
        this.departRoleUserService.deptRoleUserAdd(userId, newRoleId, oldRoleId);
        return Result.ok("\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/getDeptRoleByUserId"}, method={RequestMethod.GET})
    public Result<List<SysDepartRoleUser>> getDeptRoleByUserId(@RequestParam(value="userId") String userId, @RequestParam(value="departId") String departId) {
        Result<List<SysDepartRoleUser>> result = new Result<List<SysDepartRoleUser>>();
        List roleList = this.sysDepartRoleService.list((Wrapper)new QueryWrapper().eq((Object)"depart_id", (Object)departId));
        List roleIds = roleList.stream().map(SysDepartRole::getId).collect(Collectors.toList());
        List roleUserList = this.departRoleUserService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId)).in((Object)"drole_id", roleIds));
        result.setSuccess(true);
        result.setResult(roleUserList);
        return result;
    }

    @GetMapping(value={"/datarule/{permissionId}/{departId}/{roleId}"})
    public Result<?> loadDatarule(@PathVariable(value="permissionId") String permissionId, @PathVariable(value="departId") String departId, @PathVariable(value="roleId") String roleId) {
        String drChecked;
        List<SysPermissionDataRule> list = this.sysDepartPermissionService.getPermRuleListByDeptIdAndPermId(departId, permissionId);
        if (list == null || list.size() == 0) {
            return Result.error("\u672a\u627e\u5230\u6743\u9650\u914d\u7f6e\u4fe1\u606f");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datarule", list);
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDepartRolePermission::getPermissionId, (Object)permissionId)).eq(SysDepartRolePermission::getRoleId, (Object)roleId);
        SysDepartRolePermission sysRolePermission = (SysDepartRolePermission)this.sysDepartRolePermissionService.getOne((Wrapper)query);
        if (sysRolePermission != null && oConvertUtils.isNotEmpty(drChecked = sysRolePermission.getDataRuleIds())) {
            map.put("drChecked", drChecked.endsWith(",") ? drChecked.substring(0, drChecked.length() - 1) : drChecked);
        }
        return Result.ok(map);
    }

    @PostMapping(value={"/datarule"})
    public Result<?> saveDatarule(@RequestBody JSONObject jsonObject) {
        try {
            String permissionId = jsonObject.getString("permissionId");
            String roleId = jsonObject.getString("roleId");
            String dataRuleIds = jsonObject.getString("dataRuleIds");
            log.info("\u4fdd\u5b58\u6570\u636e\u89c4\u5219>>\u83dc\u5355ID:" + permissionId + "\u89d2\u8272ID:" + roleId + "\u6570\u636e\u6743\u9650ID:" + dataRuleIds);
            LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDepartRolePermission::getPermissionId, (Object)permissionId)).eq(SysDepartRolePermission::getRoleId, (Object)roleId);
            SysDepartRolePermission sysRolePermission = (SysDepartRolePermission)this.sysDepartRolePermissionService.getOne((Wrapper)query);
            if (sysRolePermission == null) {
                return Result.error("\u8bf7\u5148\u4fdd\u5b58\u89d2\u8272\u83dc\u5355\u6743\u9650!");
            }
            sysRolePermission.setDataRuleIds(dataRuleIds);
            this.sysDepartRolePermissionService.updateById(sysRolePermission);
        }
        catch (Exception e) {
            log.error("SysRoleController.saveDatarule()\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return Result.error("\u4fdd\u5b58\u5931\u8d25");
        }
        return Result.ok("\u4fdd\u5b58\u6210\u529f!");
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SysDepartRole sysDepartRole) {
        return super.exportXls(request, sysDepartRole, SysDepartRole.class, "\u90e8\u95e8\u89d2\u8272");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, SysDepartRole.class);
    }
}

