/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.dynamic.db.DataSourceCachePool;
import org.jeecg.modules.system.entity.SysDataSource;
import org.jeecg.modules.system.service.ISysDataSourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u591a\u6570\u636e\u6e90\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/sys/dataSource"})
public class SysDataSourceController
extends JeecgController<SysDataSource, ISysDataSourceService> {
    private static final Logger log = LoggerFactory.getLogger(SysDataSourceController.class);
    @Autowired
    private ISysDataSourceService sysDataSourceService;

    @AutoLog(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SysDataSource sysDataSource, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<SysDataSource> queryWrapper = QueryGenerator.initQueryWrapper(sysDataSource, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysDataSourceService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @GetMapping(value={"/options"})
    public Result<?> queryOptions(SysDataSource sysDataSource, HttpServletRequest req) {
        QueryWrapper<SysDataSource> queryWrapper = QueryGenerator.initQueryWrapper(sysDataSource, req.getParameterMap());
        List pageList = this.sysDataSourceService.list((Wrapper)queryWrapper);
        JSONArray array = new JSONArray(pageList.size());
        for (SysDataSource item : pageList) {
            JSONObject option = new JSONObject(3);
            option.put("value", (Object)item.getCode());
            option.put("label", (Object)item.getName());
            option.put("text", (Object)item.getName());
            array.add((Object)option);
        }
        return Result.ok(array);
    }

    @AutoLog(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u6dfb\u52a0", notes="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SysDataSource sysDataSource) {
        this.sysDataSourceService.save(sysDataSource);
        return Result.ok("\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u7f16\u8f91", notes="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u7f16\u8f91")
    @PutMapping(value={"/edit"})
    public Result<?> edit(@RequestBody SysDataSource sysDataSource) {
        SysDataSource d = (SysDataSource)this.sysDataSourceService.getById((Serializable)((Object)sysDataSource.getId()));
        DataSourceCachePool.removeCache(d.getCode());
        this.sysDataSourceService.updateById(sysDataSource);
        return Result.ok("\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664", notes="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        SysDataSource sysDataSource = (SysDataSource)this.sysDataSourceService.getById((Serializable)((Object)id));
        DataSourceCachePool.removeCache(sysDataSource.getCode());
        this.sysDataSourceService.removeById((Serializable)((Object)id));
        return Result.ok("\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u6279\u91cf\u5220\u9664", notes="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        idList.forEach(item -> {
            SysDataSource sysDataSource = (SysDataSource)this.sysDataSourceService.getById((Serializable)((Object)item));
            DataSourceCachePool.removeCache(sysDataSource.getCode());
        });
        this.sysDataSourceService.removeByIds(idList);
        return Result.ok("\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @AutoLog(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2", notes="\u591a\u6570\u636e\u6e90\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SysDataSource sysDataSource = (SysDataSource)this.sysDataSourceService.getById((Serializable)((Object)id));
        return Result.ok(sysDataSource);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SysDataSource sysDataSource) {
        return super.exportXls(request, sysDataSource, SysDataSource.class, "\u591a\u6570\u636e\u6e90\u7ba1\u7406");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, SysDataSource.class);
    }
}

