/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.exceptions.ClientException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.DySmsEnum;
import org.jeecg.common.util.DySmsHelper;
import org.jeecg.common.util.MD5Util;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.encryption.EncryptedString;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.model.SysLoginModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysDictService;
import org.jeecg.modules.system.service.ISysLogService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.util.RandImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys"})
@Api(tags={"\u7528\u6237\u767b\u5f55"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private ISysLogService logService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private ISysDictService sysDictService;
    private static final String BASE_CHECK_CODES = "qwertyuiplkjhgfdsazxcvbnmQWERTYUPLKJHGFDSAZXCVBNM1234567890";

    @ApiOperation(value="\u767b\u5f55\u63a5\u53e3")
    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public Result<JSONObject> login(@RequestBody SysLoginModel sysLoginModel) {
        Result result = new Result();
        String username = sysLoginModel.getUsername();
        String password = sysLoginModel.getPassword();
        String captcha = sysLoginModel.getCaptcha();
        if (captcha == null) {
            result.error500("\u9a8c\u8bc1\u7801\u65e0\u6548");
            return result;
        }
        String lowerCaseCaptcha = captcha.toLowerCase();
        String realKey = MD5Util.MD5Encode(lowerCaseCaptcha + sysLoginModel.getCheckKey(), "utf-8");
        Object checkCode = this.redisUtil.get(realKey);
        if (checkCode == null || !checkCode.equals(lowerCaseCaptcha)) {
            result.error500("\u9a8c\u8bc1\u7801\u9519\u8bef");
            return result;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUser::getUsername, (Object)username);
        SysUser sysUser = (SysUser)this.sysUserService.getOne((Wrapper)queryWrapper);
        result = this.sysUserService.checkUserIsEffective(sysUser);
        if (!result.isSuccess()) {
            return result;
        }
        String userpassword = PasswordUtil.encrypt(username, password, sysUser.getSalt());
        String syspassword = sysUser.getPassword();
        if (!syspassword.equals(userpassword)) {
            result.error500("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            return result;
        }
        this.userInfo(sysUser, result);
        this.sysBaseAPI.addLog("\u7528\u6237\u540d: " + username + ",\u767b\u5f55\u6210\u529f\uff01", 1, null);
        return result;
    }

    @RequestMapping(value={"/logout"})
    public Result<Object> logout(HttpServletRequest request, HttpServletResponse response) {
        String token = request.getHeader("X-Access-Token");
        if (oConvertUtils.isEmpty(token)) {
            return Result.error("\u9000\u51fa\u767b\u5f55\u5931\u8d25\uff01");
        }
        String username = JwtUtil.getUsername(token);
        LoginUser sysUser = this.sysBaseAPI.getUserByName(username);
        if (sysUser != null) {
            this.sysBaseAPI.addLog("\u7528\u6237\u540d: " + sysUser.getRealname() + ",\u9000\u51fa\u6210\u529f\uff01", 1, null);
            log.info(" \u7528\u6237\u540d:  " + sysUser.getRealname() + ",\u9000\u51fa\u6210\u529f\uff01 ");
            this.redisUtil.del("prefix_user_token_" + token);
            this.redisUtil.del("shiro:cache:org.jeecg.modules.shiro.authc.ShiroRealm.authorizationCache:" + sysUser.getId());
            this.redisUtil.del(String.format("%s::%s", "sys:cache:user", sysUser.getUsername()));
            SecurityUtils.getSubject().logout();
            return Result.ok("\u9000\u51fa\u767b\u5f55\u6210\u529f\uff01");
        }
        return Result.error("Token\u65e0\u6548!");
    }

    @GetMapping(value={"loginfo"})
    public Result<JSONObject> loginfo() {
        Result<JSONObject> result = new Result<JSONObject>();
        JSONObject obj = new JSONObject();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date dayStart = calendar.getTime();
        ((Calendar)calendar).add(5, 1);
        Date dayEnd = calendar.getTime();
        Long totalVisitCount = this.logService.findTotalVisitCount();
        obj.put("totalVisitCount", (Object)totalVisitCount);
        Long todayVisitCount = this.logService.findTodayVisitCount(dayStart, dayEnd);
        obj.put("todayVisitCount", (Object)todayVisitCount);
        Long todayIp = this.logService.findTodayIp(dayStart, dayEnd);
        obj.put("todayIp", (Object)todayIp);
        result.setResult(obj);
        result.success("\u767b\u5f55\u6210\u529f");
        return result;
    }

    @GetMapping(value={"visitInfo"})
    public Result<List<Map<String, Object>>> visitInfo() {
        Result<List<Map<String, Object>>> result = new Result<List<Map<String, Object>>>();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        ((Calendar)calendar).add(5, 1);
        Date dayEnd = calendar.getTime();
        ((Calendar)calendar).add(5, -7);
        Date dayStart = calendar.getTime();
        List<Map<String, Object>> list = this.logService.findVisitCount(dayStart, dayEnd);
        result.setResult(oConvertUtils.toLowerCasePageList(list));
        return result;
    }

    @RequestMapping(value={"/selectDepart"}, method={RequestMethod.PUT})
    public Result<JSONObject> selectDepart(@RequestBody SysUser user) {
        Result<JSONObject> result = new Result<JSONObject>();
        String username = user.getUsername();
        if (oConvertUtils.isEmpty(username)) {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            username = sysUser.getUsername();
        }
        String orgCode = user.getOrgCode();
        this.sysUserService.updateUserDepart(username, orgCode);
        SysUser sysUser = this.sysUserService.getUserByName(username);
        JSONObject obj = new JSONObject();
        obj.put("userInfo", (Object)sysUser);
        result.setResult(obj);
        return result;
    }

    @PostMapping(value={"/sms"})
    public Result<String> sms(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        String mobile = jsonObject.get((Object)"mobile").toString();
        String smsmode = jsonObject.get((Object)"smsmode").toString();
        log.info(mobile);
        if (oConvertUtils.isEmpty(mobile)) {
            result.setMessage("\u624b\u673a\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            result.setSuccess(false);
            return result;
        }
        Object object = this.redisUtil.get(mobile);
        if (object != null) {
            result.setMessage("\u9a8c\u8bc1\u780110\u5206\u949f\u5185\uff0c\u4ecd\u7136\u6709\u6548\uff01");
            result.setSuccess(false);
            return result;
        }
        String captcha = RandomUtil.randomNumbers((int)6);
        JSONObject obj = new JSONObject();
        obj.put("code", (Object)captcha);
        try {
            boolean b = false;
            if ("1".equals(smsmode)) {
                SysUser sysUser = this.sysUserService.getUserByPhone(mobile);
                if (sysUser != null) {
                    result.error500(" \u624b\u673a\u53f7\u5df2\u7ecf\u6ce8\u518c\uff0c\u8bf7\u76f4\u63a5\u767b\u5f55\uff01");
                    this.sysBaseAPI.addLog("\u624b\u673a\u53f7\u5df2\u7ecf\u6ce8\u518c\uff0c\u8bf7\u76f4\u63a5\u767b\u5f55\uff01", 1, null);
                    return result;
                }
                b = DySmsHelper.sendSms(mobile, obj, DySmsEnum.REGISTER_TEMPLATE_CODE);
            } else {
                SysUser sysUser = this.sysUserService.getUserByPhone(mobile);
                result = this.sysUserService.checkUserIsEffective(sysUser);
                if (!result.isSuccess()) {
                    String message = result.getMessage();
                    if ("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u6ce8\u518c".equals(message)) {
                        result.error500("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\u6216\u672a\u7ed1\u5b9a\u624b\u673a\u53f7");
                    }
                    return result;
                }
                if ("0".equals(smsmode)) {
                    b = DySmsHelper.sendSms(mobile, obj, DySmsEnum.LOGIN_TEMPLATE_CODE);
                } else if ("2".equals(smsmode)) {
                    b = DySmsHelper.sendSms(mobile, obj, DySmsEnum.FORGET_PASSWORD_TEMPLATE_CODE);
                }
            }
            if (!b) {
                result.setMessage("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                result.setSuccess(false);
                return result;
            }
            this.redisUtil.set(mobile, captcha, 600L);
            result.setSuccess(true);
        }
        catch (ClientException e) {
            e.printStackTrace();
            result.error500(" \u77ed\u4fe1\u63a5\u53e3\u672a\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return result;
        }
        return result;
    }

    @ApiOperation(value="\u624b\u673a\u53f7\u767b\u5f55\u63a5\u53e3")
    @PostMapping(value={"/phoneLogin"})
    public Result<JSONObject> phoneLogin(@RequestBody JSONObject jsonObject) {
        Object code;
        Result result = new Result();
        String phone = jsonObject.getString("mobile");
        SysUser sysUser = this.sysUserService.getUserByPhone(phone);
        result = this.sysUserService.checkUserIsEffective(sysUser);
        if (!result.isSuccess()) {
            return result;
        }
        String smscode = jsonObject.getString("captcha");
        if (!smscode.equals(code = this.redisUtil.get(phone))) {
            result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
            return result;
        }
        this.userInfo(sysUser, result);
        this.sysBaseAPI.addLog("\u7528\u6237\u540d: " + sysUser.getUsername() + ",\u767b\u5f55\u6210\u529f\uff01", 1, null);
        return result;
    }

    private Result<JSONObject> userInfo(SysUser sysUser, Result<JSONObject> result) {
        String syspassword = sysUser.getPassword();
        String username = sysUser.getUsername();
        String token = JwtUtil.sign(username, syspassword);
        this.redisUtil.set("prefix_user_token_" + token, token);
        this.redisUtil.expire("prefix_user_token_" + token, 3600L);
        JSONObject obj = new JSONObject();
        List<SysDepart> departs = this.sysDepartService.queryUserDeparts(sysUser.getId());
        obj.put("departs", departs);
        if (departs == null || departs.size() == 0) {
            obj.put("multi_depart", (Object)0);
        } else if (departs.size() == 1) {
            this.sysUserService.updateUserDepart(username, departs.get(0).getOrgCode());
            obj.put("multi_depart", (Object)1);
        } else {
            obj.put("multi_depart", (Object)2);
        }
        obj.put("token", (Object)token);
        obj.put("userInfo", (Object)sysUser);
        obj.put("sysAllDictItems", this.sysDictService.queryAllDictItems());
        result.setResult(obj);
        result.success("\u767b\u5f55\u6210\u529f");
        return result;
    }

    @GetMapping(value={"/getEncryptedString"})
    public Result<Map<String, String>> getEncryptedString() {
        Result<Map<String, String>> result = new Result<Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", EncryptedString.key);
        map.put("iv", EncryptedString.iv);
        result.setResult(map);
        return result;
    }

    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/randomImage/{key}"})
    public Result<String> randomImage(HttpServletResponse response, @PathVariable String key) {
        Result<String> res = new Result<String>();
        try {
            String code = RandomUtil.randomString((String)BASE_CHECK_CODES, (int)4);
            String lowerCaseCode = code.toLowerCase();
            String realKey = MD5Util.MD5Encode(lowerCaseCode + key, "utf-8");
            this.redisUtil.set(realKey, lowerCaseCode, 60L);
            String base64 = RandImageUtil.generate(code);
            res.setSuccess(true);
            res.setResult(base64);
        }
        catch (Exception e) {
            res.error500("\u83b7\u53d6\u9a8c\u8bc1\u7801\u51fa\u9519" + e.getMessage());
            e.printStackTrace();
        }
        return res;
    }

    @RequestMapping(value={"/mLogin"}, method={RequestMethod.POST})
    public Result<JSONObject> mLogin(@RequestBody SysLoginModel sysLoginModel) throws Exception {
        Result result = new Result();
        String username = sysLoginModel.getUsername();
        String password = sysLoginModel.getPassword();
        SysUser sysUser = this.sysUserService.getUserByName(username);
        result = this.sysUserService.checkUserIsEffective(sysUser);
        if (!result.isSuccess()) {
            return result;
        }
        String userpassword = PasswordUtil.encrypt(username, password, sysUser.getSalt());
        String syspassword = sysUser.getPassword();
        if (!syspassword.equals(userpassword)) {
            result.error500("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            return result;
        }
        String orgCode = sysUser.getOrgCode();
        if (oConvertUtils.isEmpty(orgCode)) {
            List<SysDepart> departs = this.sysDepartService.queryUserDeparts(sysUser.getId());
            if (departs == null || departs.size() == 0) {
                result.error500("\u7528\u6237\u6682\u672a\u5f52\u5c5e\u90e8\u95e8,\u4e0d\u53ef\u767b\u5f55!");
                return result;
            }
            orgCode = departs.get(0).getOrgCode();
            sysUser.setOrgCode(orgCode);
            this.sysUserService.updateUserDepart(username, orgCode);
        }
        JSONObject obj = new JSONObject();
        obj.put("userInfo", (Object)sysUser);
        String token = JwtUtil.sign(username, syspassword);
        this.redisUtil.set("prefix_user_token_" + token, token);
        this.redisUtil.expire("prefix_user_token_" + token, 3600L);
        obj.put("token", (Object)token);
        result.setResult(obj);
        result.setSuccess(true);
        result.setCode(200);
        this.sysBaseAPI.addLog("\u7528\u6237\u540d: " + username + ",\u767b\u5f55\u6210\u529f[\u79fb\u52a8\u7aef]\uff01", 1, null);
        return result;
    }

    @RequestMapping(value={"/checkCaptcha"}, method={RequestMethod.POST})
    public Result<?> checkCaptcha(@RequestBody SysLoginModel sysLoginModel) {
        String captcha = sysLoginModel.getCaptcha();
        String checkKey = sysLoginModel.getCheckKey();
        if (captcha == null) {
            return Result.error("\u9a8c\u8bc1\u7801\u65e0\u6548");
        }
        String lowerCaseCaptcha = captcha.toLowerCase();
        String realKey = MD5Util.MD5Encode(lowerCaseCaptcha + checkKey, "utf-8");
        Object checkCode = this.redisUtil.get(realKey);
        if (checkCode == null || !checkCode.equals(lowerCaseCaptcha)) {
            return Result.error("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        return Result.ok();
    }
}

