/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.aspect;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.Dict;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.service.ISysDictService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class DictAspect {
    private static final Logger log = LoggerFactory.getLogger(DictAspect.class);
    @Autowired
    private ISysDictService dictService;

    @Pointcut(value="execution(public * org.jeecg.modules..*.*Controller.*(..))")
    public void excudeService() {
    }

    @Around(value="excudeService()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        long time1 = System.currentTimeMillis();
        Object result = pjp.proceed();
        long time2 = System.currentTimeMillis();
        log.debug("\u83b7\u53d6JSON\u6570\u636e \u8017\u65f6\uff1a" + (time2 - time1) + "ms");
        long start = System.currentTimeMillis();
        this.parseDictText(result);
        long end = System.currentTimeMillis();
        log.debug("\u89e3\u6790\u6ce8\u5165JSON\u6570\u636e  \u8017\u65f6" + (end - start) + "ms");
        return result;
    }

    private void parseDictText(Object result) {
        if (result instanceof Result && ((Result)result).getResult() instanceof IPage) {
            ArrayList<JSONObject> items = new ArrayList<JSONObject>();
            for (Object record : ((IPage)((Result)result).getResult()).getRecords()) {
                ObjectMapper mapper = new ObjectMapper();
                String json = "{}";
                try {
                    json = mapper.writeValueAsString(record);
                }
                catch (JsonProcessingException e) {
                    log.error("json\u89e3\u6790\u5931\u8d25" + e.getMessage(), (Throwable)e);
                }
                JSONObject item = JSONObject.parseObject((String)json);
                for (Field field : oConvertUtils.getAllFields(record)) {
                    if (field.getAnnotation(Dict.class) != null) {
                        String code = field.getAnnotation(Dict.class).dicCode();
                        String text = field.getAnnotation(Dict.class).dicText();
                        String table = field.getAnnotation(Dict.class).dictTable();
                        String key = String.valueOf(item.get((Object)field.getName()));
                        String textValue = this.translateDictValue(code, text, table, key);
                        log.debug(" \u5b57\u5178Val : " + textValue);
                        log.debug(" __\u7ffb\u8bd1\u5b57\u5178\u5b57\u6bb5__ " + field.getName() + "_dictText" + "\uff1a " + textValue);
                        item.put(field.getName() + "_dictText", (Object)textValue);
                    }
                    if (!field.getType().getName().equals("java.util.Date") || field.getAnnotation(JsonFormat.class) != null || item.get((Object)field.getName()) == null) continue;
                    SimpleDateFormat aDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    item.put(field.getName(), (Object)aDate.format(new Date((Long)item.get((Object)field.getName()))));
                }
                items.add(item);
            }
            ((IPage)((Result)result).getResult()).setRecords(items);
        }
    }

    private String translateDictValue(String code, String text, String table, String key) {
        String[] keys;
        if (oConvertUtils.isEmpty(key)) {
            return null;
        }
        StringBuffer textValue = new StringBuffer();
        for (String k : keys = key.split(",")) {
            String tmpValue = null;
            log.debug(" \u5b57\u5178 key : " + k);
            if (k.trim().length() == 0) continue;
            if (!StringUtils.isEmpty((Object)table)) {
                log.debug("--DictAspect------dicTable=" + table + " ,dicText= " + text + " ,dicCode=" + code);
                tmpValue = this.dictService.queryTableDictTextByKey(table, text, code, k.trim());
            } else {
                tmpValue = this.dictService.queryDictTextByKey(code, k.trim());
            }
            if (tmpValue == null) continue;
            if (!"".equals(textValue.toString())) {
                textValue.append(",");
            }
            textValue.append(tmpValue);
        }
        return textValue.toString();
    }
}

