/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.monitor.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.monitor.domain.RedisInfo;
import org.jeecg.modules.monitor.exception.RedisConnectException;
import org.jeecg.modules.monitor.service.RedisService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.stereotype.Service;

@Service(value="redisService")
public class RedisServiceImpl
implements RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceImpl.class);
    @Resource
    private RedisConnectionFactory redisConnectionFactory;

    @Override
    public List<RedisInfo> getRedisInfo() throws RedisConnectException {
        Properties info = this.redisConnectionFactory.getConnection().info();
        ArrayList<RedisInfo> infoList = new ArrayList<RedisInfo>();
        RedisInfo redisInfo = null;
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            redisInfo = new RedisInfo();
            redisInfo.setKey(oConvertUtils.getString(entry.getKey()));
            redisInfo.setValue(oConvertUtils.getString(entry.getValue()));
            infoList.add(redisInfo);
        }
        return infoList;
    }

    @Override
    public Map<String, Object> getKeysSize() throws RedisConnectException {
        Long dbSize = this.redisConnectionFactory.getConnection().dbSize();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("create_time", System.currentTimeMillis());
        map.put("dbSize", dbSize);
        log.info("--getKeysSize--: " + ((Object)map).toString());
        return map;
    }

    @Override
    public Map<String, Object> getMemoryInfo() throws RedisConnectException {
        HashMap<String, Object> map = null;
        Properties info = this.redisConnectionFactory.getConnection().info();
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            String key = oConvertUtils.getString(entry.getKey());
            if (!"used_memory".equals(key)) continue;
            map = new HashMap<String, Object>();
            map.put("used_memory", entry.getValue());
            map.put("create_time", System.currentTimeMillis());
        }
        log.info("--getMemoryInfo--: " + ((Object)map).toString());
        return map;
    }
}

