/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.dynamic.db;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.HashMap;
import java.util.Map;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.DynamicDataSourceModel;
import org.jeecg.common.util.SpringContextUtils;
import org.springframework.data.redis.core.RedisTemplate;

public class DataSourceCachePool {
    private static Map<String, DruidDataSource> dbSources = new HashMap<String, DruidDataSource>();
    private static RedisTemplate<String, Object> redisTemplate;

    private static RedisTemplate<String, Object> getRedisTemplate() {
        if (redisTemplate == null) {
            redisTemplate = (RedisTemplate)SpringContextUtils.getBean("redisTemplate");
        }
        return redisTemplate;
    }

    public static DynamicDataSourceModel getCacheDynamicDataSourceModel(String dbKey) {
        String redisCacheKey = "sys:cache:dbconnect:dynamic:" + dbKey;
        if (DataSourceCachePool.getRedisTemplate().hasKey((Object)redisCacheKey).booleanValue()) {
            return (DynamicDataSourceModel)DataSourceCachePool.getRedisTemplate().opsForValue().get((Object)redisCacheKey);
        }
        ISysBaseAPI sysBaseAPI = SpringContextUtils.getBean(ISysBaseAPI.class);
        DynamicDataSourceModel dbSource = sysBaseAPI.getDynamicDbSourceByCode(dbKey);
        if (dbSource != null) {
            DataSourceCachePool.getRedisTemplate().opsForValue().set((Object)redisCacheKey, (Object)dbSource);
        }
        return dbSource;
    }

    public static DruidDataSource getCacheBasicDataSource(String dbKey) {
        return dbSources.get(dbKey);
    }

    public static void putCacheBasicDataSource(String dbKey, DruidDataSource db) {
        dbSources.put(dbKey, db);
    }

    public static void cleanAllCache() {
        for (Map.Entry<String, DruidDataSource> entry : dbSources.entrySet()) {
            String dbkey = entry.getKey();
            DruidDataSource druidDataSource = entry.getValue();
            if (druidDataSource != null && druidDataSource.isEnable()) {
                druidDataSource.close();
            }
            DataSourceCachePool.getRedisTemplate().delete((Object)("sys:cache:dbconnect:dynamic:" + dbkey));
        }
        dbSources.clear();
    }

    public static void removeCache(String dbKey) {
        DruidDataSource druidDataSource = dbSources.get(dbKey);
        if (druidDataSource != null && druidDataSource.isEnable()) {
            druidDataSource.close();
        }
        DataSourceCachePool.getRedisTemplate().delete((Object)("sys:cache:dbconnect:dynamic:" + dbKey));
        dbSources.remove(dbKey);
    }
}

