/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectHelper {
    private static final Logger log = LoggerFactory.getLogger(ReflectHelper.class);
    private Class cls;
    private Object obj;
    private Hashtable<String, Method> getMethods = null;
    private Hashtable<String, Method> setMethods = null;

    public ReflectHelper(Object o) {
        this.obj = o;
        this.initMethods();
    }

    public void initMethods() {
        this.getMethods = new Hashtable();
        this.setMethods = new Hashtable();
        this.cls = this.obj.getClass();
        Method[] methods = this.cls.getMethods();
        String gs = "get(\\w+)";
        Pattern getM = Pattern.compile(gs);
        String ss = "set(\\w+)";
        Pattern setM = Pattern.compile(ss);
        String rapl = "$1";
        for (int i = 0; i < methods.length; ++i) {
            String param;
            Method m = methods[i];
            String methodName = m.getName();
            if (Pattern.matches(gs, methodName)) {
                param = getM.matcher(methodName).replaceAll(rapl).toLowerCase();
                this.getMethods.put(param, m);
                continue;
            }
            if (!Pattern.matches(ss, methodName)) continue;
            param = setM.matcher(methodName).replaceAll(rapl).toLowerCase();
            this.setMethods.put(param, m);
        }
    }

    public boolean setMethodValue(String property, Object object) {
        Method m = this.setMethods.get(property.toLowerCase());
        if (m != null) {
            try {
                m.invoke(this.obj, object);
                return true;
            }
            catch (Exception ex) {
                log.info("invoke getter on " + property + " error: " + ex.toString());
                return false;
            }
        }
        return false;
    }

    public Object getMethodValue(String property) {
        Object value = null;
        Method m = this.getMethods.get(property.toLowerCase());
        if (m != null) {
            try {
                value = m.invoke(this.obj, new Object[0]);
            }
            catch (Exception ex) {
                log.info("invoke getter on " + property + " error: " + ex.toString());
            }
        }
        return value;
    }

    public Object setAll(Map<String, Object> data) {
        if (data == null || data.keySet().size() <= 0) {
            return null;
        }
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            this.setMethodValue(entry.getKey(), entry.getValue());
        }
        return this.obj;
    }

    public static Object setAll(Object o, Map<String, Object> data) {
        ReflectHelper reflectHelper = new ReflectHelper(o);
        reflectHelper.setAll(data);
        return o;
    }

    public static <T> T setAll(Class<T> clazz, Map<String, Object> data) {
        T o = null;
        try {
            o = clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            o = null;
            return o;
        }
        return (T)ReflectHelper.setAll(o, data);
    }

    public static <T> List<T> transList2Entrys(List<Map<String, Object>> mapist, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        if (mapist != null && mapist.size() > 0) {
            for (Map<String, Object> data : mapist) {
                list.add(ReflectHelper.setAll(clazz, data));
            }
        }
        return list;
    }

    public static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getFiledName(Object o) {
        Field[] fields = o.getClass().getDeclaredFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    public static List<Map> getFiledsInfo(Object o) {
        Field[] fields = o.getClass().getDeclaredFields();
        String[] fieldNames = new String[fields.length];
        ArrayList<Map> list = new ArrayList<Map>();
        HashMap<String, Object> infoMap = null;
        for (int i = 0; i < fields.length; ++i) {
            infoMap = new HashMap<String, Object>();
            infoMap.put("type", fields[i].getType().toString());
            infoMap.put("name", fields[i].getName());
            infoMap.put("value", ReflectHelper.getFieldValueByName(fields[i].getName(), o));
            list.add(infoMap);
        }
        return list;
    }

    public static Object[] getFiledValues(Object o) {
        String[] fieldNames = ReflectHelper.getFiledName(o);
        Object[] value = new Object[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            value[i] = ReflectHelper.getFieldValueByName(fieldNames[i], o);
        }
        return value;
    }
}

