/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import org.jeecg.common.util.MinioUtil;
import org.jeecg.common.util.oss.OssBootUtil;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.springframework.util.FileCopyUtils;

public class CommonUtils {
    public static String uploadOnlineImage(byte[] data, String basePath, String bizPath, String uploadType) {
        String dbPath = null;
        String fileName = "image" + Math.round(Math.random() * 1.0E11);
        fileName = fileName + "." + PoiPublicUtil.getFileExtendName((byte[])data);
        try {
            if ("local".equals(uploadType)) {
                File file = new File(basePath + File.separator + bizPath + File.separator);
                if (!file.exists()) {
                    file.mkdirs();
                }
                String savePath = file.getPath() + File.separator + fileName;
                File savefile = new File(savePath);
                FileCopyUtils.copy((byte[])data, (File)savefile);
                dbPath = bizPath + File.separator + fileName;
            } else {
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                String relativePath = bizPath + "/" + fileName;
                if ("minio".equals(uploadType)) {
                    dbPath = MinioUtil.upload(in, relativePath);
                } else if ("alioss".equals(uploadType)) {
                    dbPath = OssBootUtil.upload(in, relativePath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dbPath;
    }

    public static String getFileName(String fileName) {
        int pos;
        int unixSep = fileName.lastIndexOf(47);
        int winSep = fileName.lastIndexOf(92);
        int n = pos = winSep > unixSep ? winSep : unixSep;
        if (pos != -1) {
            fileName = fileName.substring(pos + 1);
        }
        fileName = fileName.replace("=", "").replace(",", "").replace("&", "").replace("#", "");
        return fileName;
    }
}

