/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.Writable;
import com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import com.itextpdf.tool.xml.pipeline.ctx.MapContext;
import com.itextpdf.tool.xml.svg.graphic.Svg;
import com.itextpdf.tool.xml.svg.tags.Graphic;
import com.itextpdf.tool.xml.svg.utils.TransformationMatrix;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfTemplatePipeline
extends AbstractPipeline<MapContext> {
    private PdfTemplate template;

    public PdfTemplatePipeline(PdfContentByte cb) {
        super(null);
        this.template = cb.createTemplate(0.0f, 0.0f);
    }

    private void write(WorkerContext context, ProcessObject po, Tag t) throws PipelineException {
        if (po.containsWritable()) {
            Writable writable = null;
            while (null != (writable = po.poll())) {
                if (!(writable instanceof Graphic)) continue;
                ((Graphic)writable).draw((PdfContentByte)this.template, t.getCSS());
                if (!(writable instanceof Svg)) continue;
                Svg svg = (Svg)writable;
                Rectangle viewBox = svg.getViewBox();
                this.template.setBoundingBox(new Rectangle(viewBox.getWidth(), viewBox.getHeight()));
            }
        }
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        AffineTransform matrix;
        String transform;
        Map<String, String> attributes = t.getAttributes();
        if (attributes != null && (transform = attributes.get("transform")) != null && (matrix = TransformationMatrix.getTransformationMatrix(transform)) != null) {
            this.template.concatCTM(matrix);
        }
        this.write(context, po, t);
        return this.getNext();
    }

    @Override
    public Pipeline<?> content(WorkerContext context, Tag currentTag, String text, ProcessObject po) throws PipelineException {
        this.write(context, po, currentTag);
        return this.getNext();
    }

    @Override
    public Pipeline<?> close(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        this.write(context, po, t);
        return this.getNext();
    }

    public PdfTemplate getTemplate() {
        return this.template;
    }
}

