/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.graphic;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.tool.xml.svg.PathItem;
import com.itextpdf.tool.xml.svg.graphic.Path;
import com.itextpdf.tool.xml.svg.graphic.Text;
import com.itextpdf.tool.xml.svg.tags.Graphic;
import com.itextpdf.tool.xml.svg.utils.EllipseArc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextPathGroup
extends Graphic {
    final List<Element> list;
    final float width;
    final float height;
    final float x;
    final float y;
    Path path;
    static final int fontsize = 40;

    public TextPathGroup(List<Element> list, float x, float y, float width, float height, Map<String, String> css, Path path) {
        super(css);
        this.list = list;
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        this.path = path;
    }

    void drawGroup(PdfContentByte cb) throws Exception {
        this.draw(cb, this.pathToLineSegment(), this.list);
    }

    public void draw(PdfContentByte cb, List<float[]> lines, List<Element> list) throws Exception {
        if (lines.size() < 2) {
            return;
        }
        cb.setLineWidth(3.0f);
        BaseFont bf = BaseFont.createFont((String)"c:/windows/fonts/arial.ttf", (String)"Cp1252", (boolean)true);
        cb.setFontAndSize(bf, 40.0f);
        float xPrevious = lines.get(0)[0];
        float yPrevious = lines.get(0)[1];
        int indexOfTextElement = 0;
        int indexOfCharacter = 0;
        String currentCharacter = this.getCharacter(indexOfTextElement, indexOfCharacter);
        while (currentCharacter == null || currentCharacter.length() == 0) {
            if (indexOfCharacter >= this.getLengthOfText(indexOfTextElement) - 1) {
                if (indexOfTextElement == list.size() - 1) {
                    return;
                }
                ++indexOfTextElement;
                indexOfCharacter = 0;
            }
            currentCharacter = this.getCharacter(indexOfTextElement, indexOfCharacter);
        }
        double halfWidthOfCharacter = (double)cb.getEffectiveStringWidth(currentCharacter, true) / 2.0;
        double totalLength = 0.0;
        boolean lookForStart = true;
        for (int j = 1; j < lines.size(); ++j) {
            float[] point = lines.get(j);
            double lengthLijnStuk = this.calculateDistance(xPrevious, yPrevious, point[0], point[1]);
            totalLength += lengthLijnStuk;
            while (totalLength >= halfWidthOfCharacter) {
                double tussen = totalLength - halfWidthOfCharacter;
                double xyAlongThis = lengthLijnStuk - tussen - halfWidthOfCharacter;
                double[] xy = this.getPointOnLine(xPrevious, yPrevious, point[0], point[1], xyAlongThis);
                if (lookForStart) {
                    this.showText(cb, point[0], point[1], xPrevious, yPrevious, xy[0], xy[1], currentCharacter);
                    lookForStart = false;
                    totalLength = tussen;
                    continue;
                }
                lookForStart = true;
                totalLength = tussen;
                currentCharacter = this.getCharacter(indexOfTextElement, ++indexOfCharacter);
                while (currentCharacter == null || currentCharacter.length() == 0) {
                    if (indexOfCharacter >= this.getLengthOfText(indexOfTextElement) - 1) {
                        if (indexOfTextElement == list.size() - 1) {
                            return;
                        }
                        ++indexOfTextElement;
                        indexOfCharacter = 0;
                    }
                    currentCharacter = this.getCharacter(indexOfTextElement, indexOfCharacter);
                }
                halfWidthOfCharacter = (double)cb.getEffectiveStringWidth(currentCharacter, true) / 2.0;
            }
            xPrevious = point[0];
            yPrevious = point[1];
        }
    }

    private String getCharacter(int indexOfTextElement, int indexOfCharacter) {
        Text text = (Text)this.list.get(indexOfTextElement);
        if (text != null && text.getText().length() > indexOfCharacter) {
            return "" + text.getText().charAt(indexOfCharacter);
        }
        return null;
    }

    private int getLengthOfText(int indexOfTextElement) {
        Text text = (Text)this.list.get(indexOfTextElement);
        return text.getText().length();
    }

    public void drawLine(PdfContentByte cb, float x1, float y1, float x2, float y2, int step) throws Exception {
        cb.moveTo(x1, y1);
        cb.lineTo(x2, y2);
        cb.stroke();
        for (int i = 0; i < 10; ++i) {
            double[] point = this.getPointOnLine(x1, y1, x2, y2, i * step);
            cb.rectangle((float)point[0], (float)point[1], 2.0f, 2.0f);
            cb.stroke();
        }
    }

    private void showText(PdfContentByte cb, float x, float y, float xPrevious, float yPrevious, double xmidden, double ymidden, String character) throws Exception {
        double corner = this.calculateCorner(x, y, xPrevious, yPrevious);
        cb.saveState();
        PdfTemplate template2 = cb.createTemplate(1000.0f, 1000.0f);
        template2.beginText();
        template2.setColorFill(BaseColor.BLACK);
        BaseFont bf = BaseFont.createFont();
        template2.setFontAndSize(bf, 40.0f);
        template2.setTextMatrix(0.0f, 0.0f);
        template2.showText(character + "");
        template2.endText();
        cb.concatCTM(AffineTransform.getTranslateInstance((double)xmidden, (double)ymidden));
        cb.concatCTM(AffineTransform.getRotateInstance((double)Math.toRadians(corner)));
        cb.concatCTM(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        cb.addTemplate(template2, 0.0f, 0.0f);
        cb.restoreState();
    }

    private double calculateCorner(double x1, double y1, double x0, double y0) {
        double x = x1 - x0;
        double y = y1 - y0;
        if (x >= 0.0 && y >= 0.0) {
            return Math.toDegrees(Math.atan(y / x));
        }
        if (x < 0.0 && y > 0.0) {
            return Math.toDegrees(Math.atan(y / x)) + 180.0;
        }
        if (x < 0.0 && y < 0.0) {
            return Math.toDegrees(Math.atan(y / x)) + 180.0;
        }
        if (x >= 0.0 && y < 0.0) {
            return Math.toDegrees(Math.atan(y / x)) + 360.0;
        }
        return 0.0;
    }

    private double[] getPointOnLine(float x1, float y1, float x2, float y2, double length) {
        double corner = this.calculateCorner(x2, y2, x1, y1);
        double rad = Math.toRadians(corner);
        double[] result = new double[]{(double)x1 + length * Math.cos(rad), (double)y1 + length * Math.sin(rad)};
        return result;
    }

    private double calculateDistance(float x1, float y1, float x2, float y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    private List<float[]> pathToLineSegment() {
        return this.pathToLineSegment(this.path.getTranslatedPathItems());
    }

    private List<float[]> pathToLineSegment(List<PathItem> pathItems) {
        ArrayList<float[]> coordinates = new ArrayList<float[]>();
        for (PathItem item : pathItems) {
            List<Float> numbers = item.getCoordinates();
            if (item.isMoveTo() || item.isLineTo()) {
                float[] point = new float[]{numbers.get(0).floatValue(), numbers.get(1).floatValue()};
                coordinates.add(point);
                continue;
            }
            if (item.isCubicBezier() || item.isQuadraticBezier()) {
                coordinates.addAll(this.bezierCurveToLines(coordinates, item));
                continue;
            }
            if (!item.isArcTo()) continue;
            coordinates.addAll(this.arcToLines(item));
        }
        return coordinates;
    }

    private List<float[]> arcToLines(PathItem item) {
        List<Float> numbers = item.getCoordinates();
        EllipseArc ellipse = EllipseArc.createEllipseArc(numbers.get(7).floatValue(), numbers.get(8).floatValue(), numbers.get(5).floatValue(), numbers.get(6).floatValue(), numbers.get(0).floatValue(), numbers.get(1).floatValue(), numbers.get(4).floatValue(), numbers.get(3).floatValue());
        ArrayList newCoordinates = PdfContentByte.bezierArc((float)(ellipse.getCx() - numbers.get(0).floatValue()), (float)(ellipse.getCy() - numbers.get(1).floatValue()), (float)(ellipse.getCx() + numbers.get(0).floatValue()), (float)(ellipse.getCy() + numbers.get(1).floatValue()), (float)ellipse.getStartAng(), (float)ellipse.getExtend());
        ArrayList<float[]> result = new ArrayList<float[]>();
        if (newCoordinates.isEmpty()) {
            return result;
        }
        float[] pt = (float[])newCoordinates.get(0);
        float x0 = pt[0];
        float y0 = pt[1];
        for (int k = 0; k < newCoordinates.size(); ++k) {
            pt = (float[])newCoordinates.get(k);
            result.addAll(this.bezierCurveToLines(x0, y0, pt[2], pt[3], pt[4], pt[5], pt[6], pt[7], true));
            x0 = pt[6];
            y0 = pt[7];
        }
        return result;
    }

    private List<float[]> bezierCurveToLines(List<float[]> coordinates, PathItem item) {
        List<Float> numbers = item.getCoordinates();
        float[] start = coordinates.get(coordinates.size() - 1);
        float x0 = start[0];
        float y0 = start[1];
        float x1 = numbers.get(0).floatValue();
        float y1 = numbers.get(1).floatValue();
        float x2 = numbers.get(2).floatValue();
        float y2 = numbers.get(3).floatValue();
        float x3 = 0.0f;
        float y3 = 0.0f;
        if (item.isCubicBezier()) {
            x3 = numbers.get(4).floatValue();
            y3 = numbers.get(5).floatValue();
        }
        return this.bezierCurveToLines(x0, y0, x1, y1, x2, y2, x3, y3, item.isCubicBezier());
    }

    private List<float[]> bezierCurveToLines(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3, boolean cubic) {
        float step;
        float H;
        float G;
        float F;
        float E;
        float D;
        float C;
        float B;
        float A;
        if (cubic) {
            A = x3 - 3.0f * x2 + 3.0f * x1 - x0;
            B = 3.0f * x2 - 6.0f * x1 + 3.0f * x0;
            C = 3.0f * x1 - 3.0f * x0;
            D = x0;
            E = y3 - 3.0f * y2 + 3.0f * y1 - y0;
            F = 3.0f * y2 - 6.0f * y1 + 3.0f * y0;
            G = 3.0f * y1 - 3.0f * y0;
            H = y0;
        } else {
            A = 0.0f;
            B = x2 - 2.0f * x1 + x0;
            C = 2.0f * x1 - 2.0f * x0;
            D = x0;
            E = 0.0f;
            F = y2 - 2.0f * y1 + y0;
            G = 2.0f * y1 - 2.0f * y0;
            H = y0;
        }
        ArrayList<float[]> result = new ArrayList<float[]>();
        for (float t = step = 0.005f; t <= 1.0f; t += step) {
            float[] point = new float[]{A * t * t * t + B * t * t + C * t + D, E * t * t * t + F * t * t + G * t + H};
            result.add(point);
        }
        return result;
    }

    @Override
    public void draw(PdfContentByte cb) {
        try {
            this.drawGroup(cb);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

