/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;

public class FontSizeTranslator {
    public static final float DEFAULT_FONT_SIZE = 12.0f;
    private static CssUtils utils = CssUtils.getInstance();
    private static FontSizeTranslator myself;

    public static synchronized FontSizeTranslator getInstance() {
        if (null == myself) {
            myself = new FontSizeTranslator();
        }
        return myself;
    }

    public float translateFontSize(Tag tag) {
        float size = -1.0f;
        if (tag.getCSS().get("font-size") != null) {
            String value = tag.getCSS().get("font-size");
            if (value.equalsIgnoreCase("xx-small")) {
                size = 6.75f;
            } else if (value.equalsIgnoreCase("x-small")) {
                size = 7.5f;
            } else if (value.equalsIgnoreCase("small")) {
                size = 9.75f;
            } else if (value.equalsIgnoreCase("medium")) {
                size = 12.0f;
            } else if (value.equalsIgnoreCase("large")) {
                size = 13.5f;
            } else if (value.equalsIgnoreCase("x-large")) {
                size = 18.0f;
            } else if (value.equalsIgnoreCase("xx-large")) {
                size = 24.0f;
            } else if (value.equalsIgnoreCase("smaller")) {
                if (tag.getParent() != null) {
                    float parentSize = this.getFontSize(tag.getParent());
                    if (parentSize <= 6.75f) {
                        size = parentSize - 1.0f;
                    } else if (parentSize == 7.5f) {
                        size = 6.75f;
                    } else if (parentSize == 9.75f) {
                        size = 7.5f;
                    } else if (parentSize == 12.0f) {
                        size = 9.75f;
                    } else if (parentSize == 13.5f) {
                        size = 12.0f;
                    } else if (parentSize == 18.0f) {
                        size = 13.5f;
                    } else if (parentSize == 24.0f) {
                        size = 18.0f;
                    } else if (parentSize < 24.0f) {
                        size = parentSize * 0.85f;
                    } else if (parentSize >= 24.0f) {
                        size = parentSize * 2.0f / 3.0f;
                    }
                } else {
                    size = 9.75f;
                }
            } else if (value.equalsIgnoreCase("larger")) {
                float parentSize;
                size = tag.getParent() != null ? ((parentSize = this.getFontSize(tag.getParent())) == 6.75f ? 7.5f : (parentSize == 7.5f ? 9.75f : (parentSize == 9.75f ? 12.0f : (parentSize == 12.0f ? 13.5f : (parentSize == 13.5f ? 18.0f : (parentSize == 18.0f ? 24.0f : parentSize * 1.5f)))))) : 13.5f;
            } else if (utils.isMetricValue(value) || utils.isNumericValue(value)) {
                size = utils.parsePxInCmMmPcToPt(value);
            } else if (utils.isRelativeValue(value)) {
                float baseValue = -1.0f;
                if (tag.getParent() != null) {
                    baseValue = this.getFontSize(tag.getParent());
                }
                if (baseValue == -1.0f) {
                    baseValue = 12.0f;
                }
                size = utils.parseRelativeValue(value, baseValue);
            }
        }
        return size;
    }

    public float getFontSize(Tag tag) {
        String str = tag.getCSS().get("font-size");
        if (null != str) {
            return Float.parseFloat(str.replace("pt", ""));
        }
        return -1.0f;
    }
}

