/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml;

import com.itextpdf.text.Document;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.ElementHandler;
import com.itextpdf.tool.xml.XMLWorker;
import com.itextpdf.tool.xml.XMLWorkerFontProvider;
import com.itextpdf.tool.xml.css.CSSFileWrapper;
import com.itextpdf.tool.xml.css.CssFile;
import com.itextpdf.tool.xml.css.CssFileProcessor;
import com.itextpdf.tool.xml.css.CssFilesImpl;
import com.itextpdf.tool.xml.css.StyleAttrCSSResolver;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.CssAppliersImpl;
import com.itextpdf.tool.xml.html.TagProcessorFactory;
import com.itextpdf.tool.xml.html.Tags;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.end.ElementHandlerPipeline;
import com.itextpdf.tool.xml.pipeline.end.PdfWriterPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public class XMLWorkerHelper {
    private static XMLWorkerHelper myself = new XMLWorkerHelper();
    private TagProcessorFactory tpf;
    private CssFile defaultCssFile;

    public static synchronized XMLWorkerHelper getInstance() {
        return myself;
    }

    private XMLWorkerHelper() {
    }

    public static synchronized CssFile getCSS(InputStream in) {
        CSSFileWrapper cssFile = null;
        if (null != in) {
            CssFileProcessor cssFileProcessor = new CssFileProcessor();
            int i = -1;
            try {
                while (-1 != (i = in.read())) {
                    cssFileProcessor.process((char)i);
                }
                cssFile = new CSSFileWrapper(cssFileProcessor.getCss(), true);
            }
            catch (IOException e) {
                throw new RuntimeWorkerException(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeWorkerException(e);
                }
            }
        }
        return cssFile;
    }

    public synchronized CssFile getDefaultCSS() {
        if (null == this.defaultCssFile) {
            this.defaultCssFile = XMLWorkerHelper.getCSS(XMLWorkerHelper.class.getResourceAsStream("/default.css"));
        }
        return this.defaultCssFile;
    }

    public void parseXHtml(ElementHandler d, Reader in) throws IOException {
        CssFilesImpl cssFiles = new CssFilesImpl();
        cssFiles.add(this.getDefaultCSS());
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver(cssFiles);
        HtmlPipelineContext hpc = new HtmlPipelineContext(null);
        hpc.setAcceptUnknown(true).autoBookmark(true).setTagFactory(this.getDefaultTagProcessorFactory());
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, new HtmlPipeline(hpc, new ElementHandlerPipeline(d, null)));
        XMLWorker worker = new XMLWorker(pipeline, true);
        XMLParser p = new XMLParser();
        p.addListener(worker);
        p.parse(in);
    }

    public void parseXHtml(PdfWriter writer, Document doc, Reader in) throws IOException {
        CssFilesImpl cssFiles = new CssFilesImpl();
        cssFiles.add(this.getDefaultCSS());
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver(cssFiles);
        HtmlPipelineContext hpc = new HtmlPipelineContext(null);
        hpc.setAcceptUnknown(true).autoBookmark(true).setTagFactory(this.getDefaultTagProcessorFactory());
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, new HtmlPipeline(hpc, new PdfWriterPipeline(doc, writer)));
        XMLWorker worker = new XMLWorker(pipeline, true);
        XMLParser p = new XMLParser();
        p.addListener(worker);
        p.parse(in);
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in) throws IOException {
        this.parseXHtml(writer, doc, in, XMLWorkerHelper.class.getResourceAsStream("/default.css"), null, (FontProvider)new XMLWorkerFontProvider());
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in, Charset charset) throws IOException {
        this.parseXHtml(writer, doc, in, XMLWorkerHelper.class.getResourceAsStream("/default.css"), charset);
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in, InputStream inCssFile, Charset charset, FontProvider fontProvider) throws IOException {
        CssFilesImpl cssFiles = new CssFilesImpl();
        if (inCssFile != null) {
            cssFiles.add(XMLWorkerHelper.getCSS(inCssFile));
        } else {
            cssFiles.add(this.getDefaultCSS());
        }
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver(cssFiles);
        HtmlPipelineContext hpc = new HtmlPipelineContext(new CssAppliersImpl(fontProvider));
        hpc.setAcceptUnknown(true).autoBookmark(true).setTagFactory(this.getDefaultTagProcessorFactory());
        HtmlPipeline htmlPipeline = new HtmlPipeline(hpc, new PdfWriterPipeline(doc, writer));
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, htmlPipeline);
        XMLWorker worker = new XMLWorker(pipeline, true);
        XMLParser p = new XMLParser(true, worker, charset);
        if (charset != null) {
            p.parse(in, charset);
        } else {
            p.parse(in);
        }
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in, InputStream inCssFile) throws IOException {
        this.parseXHtml(writer, doc, in, inCssFile, null, (FontProvider)new XMLWorkerFontProvider());
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in, InputStream inCssFile, FontProvider fontProvider) throws IOException {
        this.parseXHtml(writer, doc, in, inCssFile, null, fontProvider);
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in, InputStream inCssFile, Charset charset) throws IOException {
        this.parseXHtml(writer, doc, in, inCssFile, charset, (FontProvider)new XMLWorkerFontProvider());
    }

    public void parseXHtml(ElementHandler d, InputStream in, Charset charset) throws IOException {
        CssFilesImpl cssFiles = new CssFilesImpl();
        cssFiles.add(this.getDefaultCSS());
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver(cssFiles);
        HtmlPipelineContext hpc = new HtmlPipelineContext(null);
        hpc.setAcceptUnknown(true).autoBookmark(true).setTagFactory(this.getDefaultTagProcessorFactory());
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, new HtmlPipeline(hpc, new ElementHandlerPipeline(d, null)));
        XMLWorker worker = new XMLWorker(pipeline, true);
        XMLParser p = new XMLParser(true, worker, charset);
        if (charset != null) {
            p.parse(in, charset);
        } else {
            p.parse(in);
        }
    }

    public CSSResolver getDefaultCssResolver(boolean addDefaultCss) {
        StyleAttrCSSResolver resolver = new StyleAttrCSSResolver();
        if (addDefaultCss) {
            resolver.addCss(this.getDefaultCSS());
        }
        return resolver;
    }

    protected synchronized TagProcessorFactory getDefaultTagProcessorFactory() {
        if (null == this.tpf) {
            this.tpf = Tags.getHtmlTagProcessorFactory();
        }
        return this.tpf;
    }
}

