/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.utils;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.tool.xml.svg.exceptions.SvgParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationMatrix {
    public static AffineTransform getTransformationMatrix(String transform) {
        AffineTransform matrix = null;
        List<String> listWithTransformations = TransformationMatrix.splitString(transform);
        for (String str : listWithTransformations) {
            AffineTransform newMatrix = TransformationMatrix.strToMatrix(str);
            if (newMatrix == null) continue;
            if (matrix == null) {
                matrix = newMatrix;
                continue;
            }
            matrix.concatenate(newMatrix);
        }
        return matrix;
    }

    static List<String> splitString(String transform) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(transform, ")", false);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken().trim() + ")");
        }
        return list;
    }

    static AffineTransform strToMatrix(String str) {
        try {
            if (str.startsWith("matrix")) {
                return TransformationMatrix.createWithMatrix(TransformationMatrix.getValuesFromStr(str));
            }
            if (str.startsWith("translate")) {
                return TransformationMatrix.createForTranslate(TransformationMatrix.getValuesFromStr(str));
            }
            if (str.startsWith("scale")) {
                return TransformationMatrix.createForScale(TransformationMatrix.getValuesFromStr(str));
            }
            if (str.startsWith("rotate")) {
                return TransformationMatrix.createForRotate(TransformationMatrix.getValuesFromStr(str));
            }
            if (str.startsWith("skewX")) {
                return TransformationMatrix.createForSkewX(TransformationMatrix.getValuesFromStr(str));
            }
            if (str.startsWith("skewY")) {
                return TransformationMatrix.createForSkewY(TransformationMatrix.getValuesFromStr(str));
            }
            return null;
        }
        catch (SvgParseException exp) {
            return null;
        }
    }

    static AffineTransform createForSkewY(List<Float> values) throws SvgParseException {
        if (values.size() != 1) {
            throw new SvgParseException("Could not parse the transform");
        }
        return new AffineTransform(1.0, Math.tan(Math.toRadians(values.get(0).floatValue())), 0.0, 1.0, 0.0, 0.0);
    }

    static AffineTransform createForSkewX(List<Float> values) throws SvgParseException {
        if (values.size() != 1) {
            throw new SvgParseException("Could not parse the transform");
        }
        return new AffineTransform(1.0, 0.0, Math.tan(Math.toRadians(values.get(0).floatValue())), 1.0, 0.0, 0.0);
    }

    static AffineTransform createForRotate(List<Float> values) throws SvgParseException {
        if (values.size() != 1) {
            throw new SvgParseException("Could not parse the transform");
        }
        return AffineTransform.getRotateInstance((double)Math.toRadians(values.get(0).floatValue()));
    }

    static AffineTransform createForScale(List<Float> values) throws SvgParseException {
        if (values.size() == 1) {
            return AffineTransform.getScaleInstance((double)values.get(0).floatValue(), (double)values.get(0).floatValue());
        }
        if (values.size() != 2) {
            throw new SvgParseException("Could not parse the transform");
        }
        return AffineTransform.getScaleInstance((double)values.get(0).floatValue(), (double)values.get(1).floatValue());
    }

    static AffineTransform createForTranslate(List<Float> values) throws SvgParseException {
        if (values.size() == 1) {
            return AffineTransform.getTranslateInstance((double)values.get(0).floatValue(), (double)0.0);
        }
        if (values.size() != 2) {
            throw new SvgParseException("Could not parse the transform");
        }
        return AffineTransform.getTranslateInstance((double)values.get(0).floatValue(), (double)values.get(1).floatValue());
    }

    static AffineTransform createWithMatrix(List<Float> values) throws SvgParseException {
        if (values.size() != 6) {
            throw new SvgParseException("Could not parse the transform");
        }
        return new AffineTransform(values.get(0).floatValue(), values.get(1).floatValue(), values.get(2).floatValue(), values.get(3).floatValue(), values.get(4).floatValue(), values.get(5).floatValue());
    }

    static List<Float> getValuesFromStr(String str) throws SvgParseException {
        try {
            String numbers = str.substring(str.indexOf(40) + 1, str.indexOf(41));
            ArrayList<Float> result = new ArrayList<Float>();
            StringTokenizer tokenizer = new StringTokenizer(numbers, ",");
            while (tokenizer.hasMoreTokens()) {
                result.add(Float.valueOf(Float.parseFloat(tokenizer.nextToken())));
            }
            return result;
        }
        catch (Exception exp) {
            throw new SvgParseException("Could not parse the transform");
        }
    }
}

