/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.graphic;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.tool.xml.svg.graphic.SVGAttributes;
import com.itextpdf.tool.xml.svg.tags.TagUtils;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssSvgAppliers {
    private static CssSvgAppliers myself = new CssSvgAppliers();

    public static CssSvgAppliers getInstance() {
        return myself;
    }

    public void applyForText(PdfContentByte cb, Map<String, String> css, Chunk chunk) {
        this.setStrokeAndFillColor(cb, css);
        this.setStrokeAndFill(cb, css);
        try {
            Font font = new Font(Font.FontFamily.COURIER, 6.0f, 0, BaseColor.BLACK);
            Font font2 = chunk.getFont();
            BaseFont bf2 = font2.getBaseFont();
            if (bf2 == null) {
                cb.setFontAndSize(font.getCalculatedBaseFont(false), font2.getSize());
            } else {
                cb.setFontAndSize(bf2, font2.getSize());
            }
        }
        catch (Exception exp) {
            // empty catch block
        }
    }

    void setStrokeAndFill(PdfContentByte cb, Map<String, String> css) {
        boolean stroke;
        String fillValue = css.get("fill");
        String strokeValue = css.get("stroke");
        boolean fill = fillValue == null || !fillValue.equals("none");
        boolean bl = stroke = strokeValue != null && !strokeValue.equals("none");
        if (fill && stroke) {
            cb.setTextRenderingMode(2);
        } else if (fill) {
            cb.setTextRenderingMode(0);
        } else if (stroke) {
            cb.setTextRenderingMode(1);
        } else {
            cb.setTextRenderingMode(3);
        }
    }

    public void apply(PdfContentByte cb, Map<String, String> css) {
        this.setStrokeAndFillColor(cb, css);
        this.setLineWidth(cb, css);
        this.setLineCap(cb, css);
        this.setLineJoin(cb, css);
        this.setLineDash(cb, css);
    }

    void setStrokeAndFillColor(PdfContentByte cb, Map<String, String> css) {
        BaseColor fillColor = this.getColor(css.get("fill"));
        if (fillColor == null) {
            fillColor = BaseColor.BLACK;
        }
        cb.setColorFill(fillColor);
        BaseColor strokeColor = this.getColor(css.get("stroke"));
        if (strokeColor == null) {
            strokeColor = fillColor;
        }
        cb.setColorStroke(strokeColor);
    }

    private BaseColor getColor(String name) {
        if (name == null || name.equals("none")) {
            return null;
        }
        BaseColor color = HtmlUtilities.decodeColor((String)name);
        if (color == null) {
            color = SVGAttributes.cleanColorString(name);
        }
        return color;
    }

    void setLineWidth(PdfContentByte cb, Map<String, String> css) {
        String width = css.get("stroke-width");
        if (width != null) {
            try {
                cb.setLineWidth(Float.parseFloat(width));
            }
            catch (Exception exp) {
                // empty catch block
            }
        }
    }

    void setLineDash(PdfContentByte cb, Map<String, String> css) {
        String lineDash = css.get("stroke-dasharray");
        if (lineDash == null || lineDash.equals("none")) {
            return;
        }
        List<String> list = TagUtils.splitValueList(lineDash);
        if (list == null) {
            return;
        }
        float[] phase = new float[list.size() * 2];
        boolean allZero = true;
        int i = 0;
        for (String str : list) {
            try {
                phase[i] = Integer.parseInt(str);
                phase[i + list.size()] = phase[i];
                if (phase[i] != 0.0f) {
                    allZero = false;
                }
                ++i;
            }
            catch (Exception exp) {}
        }
        if (!allZero) {
            cb.setLineDash(phase, 0.0f);
        }
    }

    void setLineCap(PdfContentByte cb, Map<String, String> css) {
        String lineCap = css.get("stroke-linecap");
        if (lineCap != null) {
            if (lineCap.equals("round")) {
                cb.setLineCap(1);
            } else if (lineCap.equals("square")) {
                cb.setLineCap(2);
            } else {
                cb.setLineCap(0);
            }
        } else {
            cb.setLineCap(0);
        }
    }

    void setLineJoin(PdfContentByte cb, Map<String, String> css) {
        String lineJoin = css.get("stroke-linejoin");
        if (lineJoin != null) {
            if (lineJoin.equals("round")) {
                cb.setLineJoin(1);
            } else if (lineJoin.equals("bevel")) {
                cb.setLineJoin(2);
            } else {
                cb.setLineJoin(0);
            }
        } else {
            cb.setLineJoin(0);
        }
    }

    public void close(PdfContentByte cb, Map<String, String> css) {
        boolean stroke;
        String fillValue = css.get("fill");
        String strokeValue = css.get("stroke");
        boolean fill = fillValue == null || !fillValue.equals("none");
        boolean bl = stroke = strokeValue == null || !strokeValue.equals("none");
        if (fill && stroke) {
            cb.fillStroke();
        } else if (fill) {
            cb.fill();
        } else if (stroke) {
            cb.stroke();
        }
    }
}

