/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.parse;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.selector.item.CssAttributeSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssClassSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssIdSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoElementSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssSeparatorSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssTagSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.ICssSelectorItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CssSelectorParser {
    private static final List<String> LEGACY_PSEUDO_ELEMENTS = Arrays.asList("first-line", "first-letter", "before", "after");

    private CssSelectorParser() {
    }

    public static List<ICssSelectorItem> parseSelectorItems(String selector) {
        ArrayList<ICssSelectorItem> selectorItems = new ArrayList<ICssSelectorItem>();
        State state = new NoneState();
        for (int i = 0; i < selector.length(); ++i) {
            State nextState;
            char c = selector.charAt(i);
            boolean isEscaped = false;
            if (c == '\\') {
                Tuple2<Integer, Character> escapedSeq = CssSelectorParser.processEscape(i, selector);
                i = (Integer)escapedSeq.getFirst();
                c = ((Character)escapedSeq.getSecond()).charValue();
                isEscaped = true;
                nextState = CssSelectorParser.trySwitchToTagState(state);
            } else {
                nextState = CssSelectorParser.trySwitchState(state, c);
            }
            if (state != nextState) {
                state.process(selectorItems);
                state = nextState;
            }
            state.addChar(c, isEscaped);
        }
        state.process(selectorItems);
        return selectorItems;
    }

    private static Tuple2<Integer, Character> processEscape(int start, String source) {
        char c;
        int i;
        if (start + 1 >= source.length()) {
            return new Tuple2((Object)start, (Object)Character.valueOf('\ufffd'));
        }
        StringBuilder pendingUnicodeSequence = new StringBuilder();
        for (i = start + 1; i < source.length() && CssSelectorParser.isHexDigit(c = source.charAt(i)) && pendingUnicodeSequence.length() < 6; ++i) {
            pendingUnicodeSequence.append(c);
        }
        if (pendingUnicodeSequence.length() == 0) {
            return new Tuple2((Object)i, (Object)Character.valueOf(source.charAt(start + 1)));
        }
        int lastConsumedIndex = i - 1;
        int codePoint = Integer.parseInt(pendingUnicodeSequence.toString(), 16);
        if (i < source.length() && Character.isWhitespace(source.charAt(i))) {
            lastConsumedIndex = i;
        }
        if (Character.isValidCodePoint(codePoint) && codePoint != 0) {
            return new Tuple2((Object)lastConsumedIndex, (Object)Character.valueOf((char)codePoint));
        }
        return new Tuple2((Object)lastConsumedIndex, (Object)Character.valueOf('\ufffd'));
    }

    private static boolean isHexDigit(char c) {
        return '/' < c && c < ':' || '@' < c && c < 'G' || '`' < c && c < 'g';
    }

    private static State trySwitchToTagState(State state) {
        if (state instanceof NoneState || state instanceof SeparatorState) {
            return new TagState();
        }
        return state;
    }

    private static State trySwitchState(State state, char c) {
        if (!state.isReadyForSwitch(c)) {
            return state;
        }
        switch (c) {
            case '.': {
                return new ClassState();
            }
            case '#': {
                return new IdState();
            }
            case ':': {
                return new PseudoState();
            }
            case '[': {
                return new AttributeState();
            }
            case ' ': 
            case '+': 
            case ',': 
            case '>': 
            case '|': 
            case '~': {
                return new SeparatorState();
            }
            case '*': {
                return new TagState();
            }
        }
        return state instanceof SeparatorState || state instanceof NoneState ? new TagState() : state;
    }

    private static final class PseudoState
    extends FunctionState {
        private final StringBuilder data = new StringBuilder();
        private boolean isFunction = false;

        public PseudoState() {
            super(')');
        }

        @Override
        public boolean isReadyForSwitch(char c) {
            return !this.isFunction && this.data.length() > 1 || super.isReadyForSwitch(c);
        }

        @Override
        public void addChar(char c, boolean isEscaped) {
            super.addChar(c, isEscaped);
            char c2 = c = this.isFunction ? c : Character.toLowerCase(c);
            if (c == '(' && !isEscaped) {
                this.isFunction = true;
            }
            this.data.append(c);
        }

        @Override
        public void process(List<ICssSelectorItem> selectorItems) {
            String pseudoElement = this.data.toString();
            if (pseudoElement.startsWith("::")) {
                selectorItems.add(new CssPseudoElementSelectorItem(pseudoElement.substring(2)));
            } else if (pseudoElement.startsWith(":") && LEGACY_PSEUDO_ELEMENTS.contains(pseudoElement.substring(1))) {
                selectorItems.add(new CssPseudoElementSelectorItem(pseudoElement.substring(1)));
            } else {
                CssPseudoClassSelectorItem pseudoClassSelectorItem = CssPseudoClassSelectorItem.create(pseudoElement.substring(1));
                if (pseudoClassSelectorItem == null) {
                    throw new IllegalArgumentException(MessageFormatUtil.format((String)"Unsupported pseudo css selector: {0}", (Object[])new Object[]{pseudoElement}));
                }
                selectorItems.add(pseudoClassSelectorItem);
            }
        }
    }

    private static final class AttributeState
    extends FunctionState {
        private final StringBuilder data = new StringBuilder();

        public AttributeState() {
            super(']');
        }

        @Override
        public void process(List<ICssSelectorItem> selectorItems) {
            selectorItems.add(new CssAttributeSelectorItem(this.data.toString()));
        }

        @Override
        public void addChar(char c, boolean isEscaped) {
            super.addChar(c, isEscaped);
            this.data.append(c);
        }
    }

    private static abstract class FunctionState
    implements State {
        protected char closure;
        protected boolean inString = false;
        protected boolean isReadyForSwitch = false;

        public FunctionState(char closure) {
            this.closure = closure;
        }

        @Override
        public boolean isReadyForSwitch(char c) {
            return this.isReadyForSwitch;
        }

        @Override
        public void addChar(char c, boolean isEscaped) {
            if (!(c != '\"' && c != '\'' || isEscaped)) {
                boolean bl = this.inString = !this.inString;
            }
            if (c == this.closure && !isEscaped && !this.inString) {
                this.isReadyForSwitch = true;
            }
        }
    }

    private static final class IdState
    implements State {
        private final StringBuilder data = new StringBuilder();

        private IdState() {
        }

        @Override
        public boolean isReadyForSwitch(char c) {
            return true;
        }

        @Override
        public void addChar(char c, boolean isEscaped) {
            this.data.append(c);
        }

        @Override
        public void process(List<ICssSelectorItem> selectorItems) {
            selectorItems.add(new CssIdSelectorItem(this.data.toString().substring(1)));
        }
    }

    private static final class ClassState
    implements State {
        private final StringBuilder data = new StringBuilder();

        private ClassState() {
        }

        @Override
        public boolean isReadyForSwitch(char c) {
            return true;
        }

        @Override
        public void addChar(char c, boolean isEscaped) {
            this.data.append(c);
        }

        @Override
        public void process(List<ICssSelectorItem> selectorItems) {
            selectorItems.add(new CssClassSelectorItem(this.data.toString().substring(1)));
        }
    }

    private static final class SeparatorState
    implements State {
        private char data = '\u0000';

        private SeparatorState() {
        }

        @Override
        public boolean isReadyForSwitch(char c) {
            return true;
        }

        @Override
        public void addChar(char c, boolean isEscaped) {
            if (this.data != '\u0000') {
                throw new IllegalArgumentException(MessageFormatUtil.format((String)"Invalid token encountered in the selector string: \"{0}\"", (Object[])new Object[]{"" + this.data + c}));
            }
            this.data = c;
        }

        @Override
        public void process(List<ICssSelectorItem> selectorItems) {
            if (selectorItems.isEmpty()) {
                throw new IllegalArgumentException(MessageFormatUtil.format((String)"Invalid token encountered in the selector string: \"{0}\"", (Object[])new Object[]{Character.valueOf(this.data)}));
            }
            ICssSelectorItem lastItem = selectorItems.get(selectorItems.size() - 1);
            CssSeparatorSelectorItem curItem = new CssSeparatorSelectorItem(this.data);
            if (lastItem instanceof CssSeparatorSelectorItem) {
                if (((CssSeparatorSelectorItem)lastItem).getSeparator() == ' ') {
                    selectorItems.set(selectorItems.size() - 1, curItem);
                } else if (((CssSeparatorSelectorItem)lastItem).getSeparator() != ' ' && this.data != ' ') {
                    throw new IllegalArgumentException(MessageFormatUtil.format((String)"Invalid token encountered in the selector string: \"{0}\"", (Object[])new Object[]{"" + ((CssSeparatorSelectorItem)lastItem).getSeparator() + curItem.getSeparator()}));
                }
            } else {
                selectorItems.add(curItem);
            }
        }
    }

    private static final class TagState
    implements State {
        private final StringBuilder data = new StringBuilder();

        private TagState() {
        }

        @Override
        public boolean isReadyForSwitch(char c) {
            return true;
        }

        @Override
        public void addChar(char c, boolean isEscaped) {
            this.data.append(c);
        }

        @Override
        public void process(List<ICssSelectorItem> selectorItems) {
            if (!selectorItems.isEmpty() && !(selectorItems.get(selectorItems.size() - 1) instanceof CssSeparatorSelectorItem)) {
                throw new IllegalArgumentException(MessageFormatUtil.format((String)"Invalid token encountered in the selector string: \"{0}\"", (Object[])new Object[]{this.data.toString()}));
            }
            selectorItems.add(new CssTagSelectorItem(this.data.toString()));
        }
    }

    private static final class NoneState
    implements State {
        private NoneState() {
        }

        @Override
        public boolean isReadyForSwitch(char c) {
            return true;
        }

        @Override
        public void addChar(char c, boolean isEscaped) {
        }

        @Override
        public void process(List<ICssSelectorItem> selectorItems) {
        }
    }

    private static interface State {
        public boolean isReadyForSwitch(char var1);

        public void addChar(char var1, boolean var2);

        public void process(List<ICssSelectorItem> var1);
    }
}

