/*
    This file is part of the iText (R) project.
    Copyright (c) 1998-2025 Apryse Group NV
    Authors: Apryse Software.

    This program is offered under a commercial and under the AGPL license.
    For commercial licensing, contact us at https://itextpdf.com/sales.  For AGPL licensing, see below.

    AGPL licensing:
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.itextpdf.styledxmlparser.css;

/**
 * Class containing possible CSS rule names.
 */
public final class CssRuleName {

    /**
     * Creates a new {@link CssRuleName} instance.
     */
    private CssRuleName() {
    }

    /** The Constant BOTTOM_CENTER. */
    public static final String BOTTOM_CENTER = "bottom-center";
    
    /** The Constant BOTTOM_LEFT. */
    public static final String BOTTOM_LEFT = "bottom-left";
    
    /** The Constant BOTTOM_LEFT_CORNER. */
    public static final String BOTTOM_LEFT_CORNER = "bottom-left-corner";
    
    /** The Constant BOTTOM_RIGHT. */
    public static final String BOTTOM_RIGHT = "bottom-right";
    
    /** The Constant BOTTOM_RIGHT_CORNER. */
    public static final String BOTTOM_RIGHT_CORNER = "bottom-right-corner";

    /** The Constant CHARSET. */
    public static final String CHARSET = "charset";

    /** The Constant IMPORT. */
    public static final String IMPORT = "import";

    /** The Constant LAYER. */
    public static final String LAYER = "layer";
    
    /** The Constant LEFT_BOTTOM. */
    public static final String LEFT_BOTTOM = "left-bottom";
    
    /** The Constant LEFT_MIDDLE. */
    public static final String LEFT_MIDDLE = "left-middle";
    
    /** The Constant LEFT_TOP. */
    public static final String LEFT_TOP = "left-top";
    
    /** The Constant FONT_FACE. */
    public static final String FONT_FACE = "font-face";
    
    /** The Constant MEDIA. */
    public static final String MEDIA = "media";
    
    /** The Constant PAGE. */
    public static final String PAGE = "page";
    
    /** The Constant RIGHT_BOTTOM. */
    public static final String RIGHT_BOTTOM = "right-bottom";
    
    /** The Constant RIGHT_MIDDLE. */
    public static final String RIGHT_MIDDLE = "right-middle";
    
    /** The Constant RIGHT_TOP. */
    public static final String RIGHT_TOP = "right-top";
    
    /** The Constant TOP_CENTER. */
    public static final String TOP_CENTER = "top-center";
    
    /** The Constant TOP_LEFT. */
    public static final String TOP_LEFT = "top-left";
    
    /** The Constant TOP_LEFT_CORNER. */
    public static final String TOP_LEFT_CORNER = "top-left-corner";
    
    /** The Constant TOP_RIGHT. */
    public static final String TOP_RIGHT = "top-right";
    
    /** The Constant TOP_RIGHT_CORNER. */
    public static final String TOP_RIGHT_CORNER = "top-right-corner";
}
