/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.node.impl.jsoup.node;

import com.itextpdf.styledxmlparser.jsoup.nodes.Element;
import com.itextpdf.styledxmlparser.node.IAttributes;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupAttributes;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsoupElementNode
extends JsoupNode
implements IElementNode {
    private Element element;
    private IAttributes attributes;
    private Map<String, String> elementResolvedStyles;
    private List<Map<String, String>> customDefaultStyles;
    private String lang = null;

    public JsoupElementNode(Element element) {
        super(element);
        this.element = element;
        this.attributes = new JsoupAttributes(element.attributes());
        this.lang = this.getAttribute("lang");
    }

    @Override
    public String name() {
        return this.element.nodeName();
    }

    @Override
    public IAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public String getAttribute(String key) {
        return this.attributes.getAttribute(key);
    }

    @Override
    public void setStyles(Map<String, String> elementResolvedStyles) {
        this.elementResolvedStyles = elementResolvedStyles;
    }

    @Override
    public Map<String, String> getStyles() {
        return this.elementResolvedStyles;
    }

    @Override
    public List<Map<String, String>> getAdditionalHtmlStyles() {
        return this.customDefaultStyles;
    }

    @Override
    public void addAdditionalHtmlStyles(Map<String, String> styles) {
        if (this.customDefaultStyles == null) {
            this.customDefaultStyles = new ArrayList<Map<String, String>>();
        }
        this.customDefaultStyles.add(styles);
    }

    @Override
    public String getLang() {
        if (this.lang != null) {
            return this.lang;
        }
        INode parent = this.parentNode;
        String string = this.lang = parent instanceof IElementNode ? ((IElementNode)parent).getLang() : null;
        if (this.lang == null) {
            this.lang = "";
        }
        return this.lang;
    }

    public String text() {
        return this.element.text();
    }
}

