/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua1;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public final class PdfUA1FormulaChecker {
    private final PdfUAValidationContext context;

    private PdfUA1FormulaChecker(PdfUAValidationContext context) {
        this.context = context;
    }

    public void checkStructElement(IStructureNode elem) {
        PdfStructElem structElem = this.context.getElementIfRoleMatches(PdfName.Formula, elem);
        if (structElem == null) {
            return;
        }
        PdfDictionary pdfObject = (PdfDictionary)structElem.getPdfObject();
        if (PdfUA1FormulaChecker.hasInvalidValues(pdfObject.getAsString(PdfName.Alt), pdfObject.getAsString(PdfName.ActualText))) {
            throw new PdfUAConformanceException("Formula tags shall include an alternative representation or replacement text.");
        }
    }

    private static boolean hasInvalidValues(PdfString altText, PdfString actualText) {
        String altTextValue = null;
        if (altText != null) {
            altTextValue = altText.getValue();
        }
        String actualTextValue = null;
        if (actualText != null) {
            actualTextValue = actualText.getValue();
        }
        return (altTextValue == null || altTextValue.isEmpty()) && actualTextValue == null;
    }

    public static class PdfUA1FormulaTagHandler
    extends ContextAwareTagTreeIteratorHandler {
        private final PdfUA1FormulaChecker checker;

        public PdfUA1FormulaTagHandler(PdfUAValidationContext context) {
            super(context);
            this.checker = new PdfUA1FormulaChecker(context);
        }

        public boolean accept(IStructureNode node) {
            return node != null;
        }

        public void processElement(IStructureNode elem) {
            this.checker.checkStructElement(elem);
        }
    }
}

