/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfUAConformance;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagutils.IRoleMappingResolver;

public class PdfUAValidationContext {
    private final PdfDocument pdfDocument;

    public PdfUAValidationContext(PdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
    }

    public String resolveToStandardRole(IStructureNode node) {
        if (node == null) {
            return null;
        }
        PdfName originalRole = node.getRole();
        if (originalRole == null) {
            return null;
        }
        PdfNamespace namespace = node instanceof PdfStructElem ? ((PdfStructElem)node).getNamespace() : null;
        return this.resolveToStandardRole(originalRole.getValue(), namespace);
    }

    public String resolveToStandardRole(String role) {
        return this.resolveToStandardRole(role, null);
    }

    public String resolveToStandardRole(String role, PdfNamespace namespace) {
        if (role == null) {
            return null;
        }
        IRoleMappingResolver resolver = this.pdfDocument.getTagStructureContext().resolveMappingToStandardOrDomainSpecificRole(role, namespace);
        if (resolver == null) {
            return role;
        }
        return resolver.getRole();
    }

    public PdfStructElem getElementIfRoleMatches(PdfName role, IStructureNode structureNode) {
        if (structureNode == null) {
            return null;
        }
        if (!(structureNode instanceof PdfStructElem)) {
            return null;
        }
        if (role.equals((Object)structureNode.getRole()) || role.getValue().equals(this.resolveToStandardRole(structureNode))) {
            return (PdfStructElem)structureNode;
        }
        return null;
    }

    public PdfObjRef findObjRefByStructParentIndex(int i, PdfDictionary pageDict) {
        return this.pdfDocument.getStructTreeRoot().findObjRefByStructParentIndex(pageDict, i);
    }

    public PdfUAConformance getUAConformance() {
        return this.pdfDocument.getConformance().getUAConformance();
    }
}

