/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua2;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNameTree;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutline;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.navigation.PdfDestination;
import com.itextpdf.kernel.pdf.navigation.PdfExplicitDestination;
import com.itextpdf.kernel.pdf.navigation.PdfExplicitRemoteGoToDestination;
import com.itextpdf.kernel.pdf.navigation.PdfNamedDestination;
import com.itextpdf.kernel.pdf.navigation.PdfStringDestination;
import com.itextpdf.kernel.pdf.navigation.PdfStructureDestination;
import com.itextpdf.kernel.validation.context.PdfDestinationAdditionContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.util.ArrayList;
import java.util.List;

public class PdfUA2DestinationsChecker {
    private final PdfDestinationAdditionContext context;
    private final PdfDocument document;

    public PdfUA2DestinationsChecker(PdfDestinationAdditionContext context, PdfDocument document) {
        this.context = context;
        this.document = document;
    }

    public PdfUA2DestinationsChecker(PdfDocument document) {
        this.context = null;
        this.document = document;
    }

    public void checkDestinations() {
        this.checkDestinationsInLinks();
        if (this.document.hasOutlines()) {
            this.checkDestinationsInOutline(this.document.getOutlines(true));
        }
        this.checkAllGoToActions();
    }

    public void checkDestinationsOnCreation() {
        if (this.context != null && !PdfUA2DestinationsChecker.isDestinationAllowed(this.context.getDestination(), this.document, 0) && !PdfUA2DestinationsChecker.isActionAllowed(this.context.getAction(), this.document, 0)) {
            throw new PdfUAConformanceException("All destinations whose target lies within the same document shall be structure destinations.");
        }
    }

    private void checkDestinationsInLinks() {
        for (int i = 1; i < this.document.getNumberOfPages() + 1; ++i) {
            PdfPage page = this.document.getPage(i);
            for (PdfAnnotation annotation : page.getAnnotations()) {
                PdfLinkAnnotation linkAnnotation;
                if (!(annotation instanceof PdfLinkAnnotation) || PdfUA2DestinationsChecker.isDestinationAllowed((linkAnnotation = (PdfLinkAnnotation)annotation).getDestinationObject(), this.document, 0)) continue;
                throw new PdfUAConformanceException("All destinations whose target lies within the same document shall be structure destinations.");
            }
        }
    }

    private void checkDestinationsInOutline(PdfOutline outline) {
        if (outline != null) {
            if (!PdfUA2DestinationsChecker.isDestinationAllowed(outline.getDestination(), this.document, 0)) {
                throw new PdfUAConformanceException("All destinations whose target lies within the same document shall be structure destinations.");
            }
            for (PdfOutline kid : outline.getAllChildren()) {
                this.checkDestinationsInOutline(kid);
            }
        }
    }

    private void checkAllGoToActions() {
        PdfDictionary catalog = (PdfDictionary)this.document.getCatalog().getPdfObject();
        this.checkAllGoToActions((PdfObject)catalog, new ArrayList<PdfObject>());
    }

    private void checkAllGoToActions(PdfObject object, List<PdfObject> visitedObjects) {
        if (visitedObjects.stream().anyMatch(visitedObject -> visitedObject == object)) {
            return;
        }
        visitedObjects.add(object);
        switch (object.getType()) {
            case 1: {
                for (PdfObject kid : (PdfArray)object) {
                    this.checkAllGoToActions(kid, visitedObjects);
                }
                break;
            }
            case 3: 
            case 9: {
                this.checkGoToAction((PdfDictionary)object);
                for (PdfObject kid : ((PdfDictionary)object).values()) {
                    this.checkAllGoToActions(kid, visitedObjects);
                }
                break;
            }
        }
    }

    private void checkGoToAction(PdfDictionary dictionary) {
        if (PdfName.GoTo.equals((Object)dictionary.getAsName(PdfName.S)) && !PdfUA2DestinationsChecker.isDestinationAllowed(dictionary, this.document, 0)) {
            throw new PdfUAConformanceException("All destinations whose target lies within the same document shall be structure destinations.");
        }
    }

    private static boolean isDestinationAllowed(PdfObject destinationObject, PdfDocument document, int counter) {
        if (counter > 50) {
            return false;
        }
        return destinationObject == null || PdfUA2DestinationsChecker.isDestinationAllowed(PdfDestination.makeDestination((PdfObject)destinationObject, (boolean)false), document, ++counter);
    }

    private static boolean isDestinationAllowed(PdfDestination destination, PdfDocument document, int counter) {
        if (destination == null || destination instanceof PdfStructureDestination) {
            return true;
        }
        if (destination instanceof PdfExplicitDestination || destination instanceof PdfExplicitRemoteGoToDestination) {
            return false;
        }
        if (destination instanceof PdfNamedDestination) {
            return PdfUA2DestinationsChecker.isDestinationAllowed((PdfNamedDestination)destination, document, counter);
        }
        if (destination instanceof PdfStringDestination) {
            return PdfUA2DestinationsChecker.isDestinationAllowed((PdfStringDestination)destination, document, counter);
        }
        return true;
    }

    private static boolean isDestinationAllowed(PdfNamedDestination namedDestination, PdfDocument document, int counter) {
        PdfCatalog catalog = document.getCatalog();
        PdfDictionary dests = ((PdfDictionary)catalog.getPdfObject()).getAsDictionary(PdfName.Dests);
        if (dests != null) {
            PdfObject actualDestinationObject = dests.get((PdfName)namedDestination.getPdfObject());
            if (actualDestinationObject instanceof PdfDictionary) {
                return PdfUA2DestinationsChecker.isDestinationAllowed((PdfDictionary)actualDestinationObject, document, counter);
            }
            return PdfUA2DestinationsChecker.isDestinationAllowed(actualDestinationObject, document, counter);
        }
        return true;
    }

    private static boolean isDestinationAllowed(PdfStringDestination stringDestination, PdfDocument document, int counter) {
        PdfCatalog catalog = document.getCatalog();
        PdfNameTree dests = catalog.getNameTree(PdfName.Dests);
        PdfObject actualDestinationObject = dests.getEntry((PdfString)stringDestination.getPdfObject());
        if (actualDestinationObject instanceof PdfDictionary) {
            return PdfUA2DestinationsChecker.isDestinationAllowed((PdfDictionary)actualDestinationObject, document, counter);
        }
        return PdfUA2DestinationsChecker.isDestinationAllowed(actualDestinationObject, document, counter);
    }

    private static boolean isDestinationAllowed(PdfDictionary destDictionary, PdfDocument document, int counter) {
        boolean isSdPresent;
        if (destDictionary == null) {
            return true;
        }
        boolean bl = isSdPresent = destDictionary.get(PdfName.SD) != null && PdfDestination.makeDestination((PdfObject)destDictionary.get(PdfName.SD)) != null;
        if (!PdfUA2DestinationsChecker.isDestinationAllowed(destDictionary.get(PdfName.SD), document, counter)) {
            return false;
        }
        return isSdPresent || PdfUA2DestinationsChecker.isDestinationAllowed(destDictionary.get(PdfName.D), document, counter);
    }

    private static boolean isActionAllowed(PdfAction action, PdfDocument document, int counter) {
        return action == null || PdfUA2DestinationsChecker.isDestinationAllowed((PdfDictionary)action.getPdfObject(), document, counter);
    }
}

