/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfa;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.PdfAConformance;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfOutputIntent;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.kernel.validation.IValidationChecker;
import com.itextpdf.kernel.validation.ValidationContainer;
import com.itextpdf.pdfa.PdfADefaultFontStrategy;
import com.itextpdf.pdfa.PdfADocumentInfoHelper;
import com.itextpdf.pdfa.PdfAPageFactory;
import com.itextpdf.pdfa.checker.PdfA1Checker;
import com.itextpdf.pdfa.checker.PdfA2Checker;
import com.itextpdf.pdfa.checker.PdfA3Checker;
import com.itextpdf.pdfa.checker.PdfA4Checker;
import com.itextpdf.pdfa.checker.PdfAChecker;
import com.itextpdf.pdfa.exceptions.PdfAConformanceException;
import org.slf4j.LoggerFactory;

public class PdfADocument
extends PdfDocument {
    public PdfADocument(PdfWriter writer, PdfAConformance aConformance, PdfOutputIntent outputIntent) {
        this(writer, aConformance, outputIntent, new DocumentProperties());
    }

    public PdfADocument(PdfWriter writer, PdfAConformance aConformance, PdfOutputIntent outputIntent, DocumentProperties properties) {
        super(PdfADocument.configureWriterProperties(writer, aConformance), properties);
        PdfAChecker checker = PdfADocument.getCorrectCheckerFromConformance(this.getConformance().getAConformance());
        ValidationContainer validationContainer = new ValidationContainer();
        validationContainer.addChecker((IValidationChecker)checker);
        this.getDiContainer().register(ValidationContainer.class, (Object)validationContainer);
        this.pdfPageFactory = new PdfAPageFactory(checker);
        this.documentInfoHelper = new PdfADocumentInfoHelper(this);
        this.defaultFontStrategy = new PdfADefaultFontStrategy(this);
        this.addOutputIntent(outputIntent);
    }

    public PdfADocument(PdfReader reader, PdfWriter writer) {
        this(reader, writer, new StampingProperties());
    }

    public PdfADocument(PdfReader reader, PdfWriter writer, StampingProperties properties) {
        super(reader, writer, properties);
        if (!this.getConformance().isPdfA()) {
            throw new PdfAConformanceException("Document to read from shall be a pdfa conformant file with valid xmp metadata");
        }
        PdfAChecker checker = PdfADocument.getCorrectCheckerFromConformance(this.getConformance().getAConformance());
        ValidationContainer validationContainer = new ValidationContainer();
        validationContainer.addChecker((IValidationChecker)checker);
        this.getDiContainer().register(ValidationContainer.class, (Object)validationContainer);
        this.pdfPageFactory = new PdfAPageFactory(checker);
        this.documentInfoHelper = new PdfADocumentInfoHelper(this);
        this.defaultFontStrategy = new PdfADefaultFontStrategy(this);
    }

    public static PdfAChecker getCorrectCheckerFromConformance(PdfAConformance aConformance) {
        PdfA1Checker checker;
        switch (aConformance.getPart()) {
            case "1": {
                checker = new PdfA1Checker(aConformance);
                break;
            }
            case "2": {
                checker = new PdfA2Checker(aConformance);
                break;
            }
            case "3": {
                checker = new PdfA3Checker(aConformance);
                break;
            }
            case "4": {
                checker = new PdfA4Checker(aConformance);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't find an appropriate checker for a specified name.");
            }
        }
        return checker;
    }

    private static PdfVersion getPdfVersionAccordingToConformance(PdfAConformance aConformance) {
        switch (aConformance.getPart()) {
            case "1": {
                return PdfVersion.PDF_1_4;
            }
            case "2": 
            case "3": {
                return PdfVersion.PDF_1_7;
            }
            case "4": {
                return PdfVersion.PDF_2_0;
            }
        }
        return PdfVersion.PDF_1_7;
    }

    private static PdfWriter configureWriterProperties(PdfWriter writer, PdfAConformance aConformance) {
        writer.getProperties().addPdfAXmpMetadata(aConformance);
        PdfVersion aConformancePdfVersion = PdfADocument.getPdfVersionAccordingToConformance(aConformance);
        if (writer.getPdfVersion() != null && !writer.getPdfVersion().equals((Object)aConformancePdfVersion)) {
            LoggerFactory.getLogger(PdfADocument.class).warn(MessageFormatUtil.format((String)"Pdf version from writer properties isn't compatible with specified PDF/A conformance, it was overridden to {0} version.", (Object[])new Object[]{aConformancePdfVersion}));
        }
        writer.getProperties().setPdfVersion(aConformancePdfVersion);
        return writer;
    }
}

