/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.element;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.DefaultAccessibilityProperties;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cell
extends BlockElement<Cell> {
    private static final Border DEFAULT_BORDER = new SolidBorder(0.5f);
    private int row;
    private int col;
    private int rowspan;
    private int colspan;
    protected DefaultAccessibilityProperties tagProperties;

    public Cell(int rowspan, int colspan) {
        this.rowspan = Math.max(rowspan, 1);
        this.colspan = Math.max(colspan, 1);
    }

    public Cell() {
        this(1, 1);
    }

    @Override
    public IRenderer getRenderer() {
        IRenderer cellRenderer = null;
        if (this.nextRenderer != null) {
            if (this.nextRenderer instanceof CellRenderer) {
                IRenderer renderer = this.nextRenderer;
                this.nextRenderer = this.nextRenderer.getNextRenderer();
                cellRenderer = (CellRenderer)renderer;
            } else {
                Logger logger = LoggerFactory.getLogger(Table.class);
                logger.error("Invalid renderer for Table: must be inherited from TableRenderer");
            }
        }
        return cellRenderer == null ? this.makeNewRenderer() : cellRenderer;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public int getColspan() {
        return this.colspan;
    }

    public Cell add(IBlockElement element) {
        this.childElements.add(element);
        return this;
    }

    public Cell add(Image element) {
        this.childElements.add(element);
        return this;
    }

    public Cell clone(boolean includeContent) {
        Cell newCell = new Cell(this.rowspan, this.colspan);
        newCell.row = this.row;
        newCell.col = this.col;
        newCell.properties = new HashMap(this.properties);
        if (null != this.styles) {
            newCell.styles = new LinkedHashSet(this.styles);
        }
        if (includeContent) {
            newCell.childElements = new ArrayList(this.childElements);
        }
        return newCell;
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        switch (property) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return (T1)DEFAULT_BORDER;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return (T1)UnitValue.createPointValue(2.0f);
            }
        }
        return super.getDefaultProperty(property);
    }

    public String toString() {
        return MessageFormatUtil.format((String)"Cell[row={0}, col={1}, rowspan={2}, colspan={3}]", (Object[])new Object[]{this.row, this.col, this.rowspan, this.colspan});
    }

    @Override
    public AccessibilityProperties getAccessibilityProperties() {
        if (this.tagProperties == null) {
            this.tagProperties = new DefaultAccessibilityProperties("TD");
        }
        return this.tagProperties;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        return new CellRenderer(this);
    }

    protected Cell updateCellIndexes(int row, int col, int numberOfColumns) {
        this.row = row;
        this.col = col;
        this.colspan = Math.min(this.colspan, numberOfColumns - this.col);
        return this;
    }
}

